/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.rabbitmq;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import rx.Observable;

public class RabbitMQClient {
    final io.vertx.rabbitmq.RabbitMQClient delegate;

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public Observable<JsonObject> basicAckObservable(long deliveryTag, boolean multiple) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public Observable<JsonObject> basicNackObservable(long deliveryTag, boolean multiple, boolean requeue) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, resultHandler);
    }

    public Observable<JsonObject> basicGetObservable(String queue, boolean autoAck) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicGet(queue, autoAck, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicConsume(String queue, String address, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicConsume(queue, address, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> basicConsumeObservable(String queue, String address) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicConsume(queue, address, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicConsume(String queue, String address, boolean autoAck, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicConsume(queue, address, autoAck, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> basicConsumeObservable(String queue, String address, boolean autoAck) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicConsume(queue, address, autoAck, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicPublish(String exchange, String routingKey, JsonObject message, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, message, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> basicPublishObservable(String exchange, String routingKey, JsonObject message) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicPublish(exchange, routingKey, message, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void basicQos(int prefetchCount, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> basicQosObservable(int prefetchCount) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> exchangeDeclareObservable(String exchange, String type, boolean durable, boolean autoDelete) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void exchangeDelete(String exchange, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> exchangeDeleteObservable(String exchange) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void exchangeBind(String destination, String source, String routingKey, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> exchangeBindObservable(String destination, String source, String routingKey) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void exchangeUnbind(String destination, String source, String routingKey, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> exchangeUnbindObservable(String destination, String source, String routingKey) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public Observable<JsonObject> queueDeclareAutoObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    public Observable<JsonObject> queueDeclareObservable(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    public Observable<JsonObject> queueDeleteObservable(String queue) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queueDelete(queue, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    public Observable<JsonObject> queueDeleteIfObservable(String queue, boolean ifUnused, boolean ifEmpty) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void queueBind(String queue, String exchange, String routingKey, final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> queueBindObservable(String queue, String exchange, String routingKey) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void messageCount(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    public Observable<JsonObject> messageCountObservable(String queue) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.messageCount(queue, (Handler<AsyncResult<JsonObject>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void start(final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> startObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.start((Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void stop(final Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<Void> stopObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.stop((Handler<AsyncResult<Void>>)resultHandler.toHandler());
        return resultHandler;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

