/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.groovy.rabbitmq;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ConversionHelper;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.RabbitMQClient;
import java.util.Map;
import java.util.stream.Collectors;

public class RabbitMQClient_GroovyExtension {
    public static void basicAck(RabbitMQClient j_receiver, long deliveryTag, boolean multiple, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicAck(deliveryTag, multiple, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void basicNack(RabbitMQClient j_receiver, long deliveryTag, boolean multiple, boolean requeue, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicNack(deliveryTag, multiple, requeue, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void basicGet(RabbitMQClient j_receiver, String queue, boolean autoAck, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicGet(queue, autoAck, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void basicPublish(RabbitMQClient j_receiver, String exchange, String routingKey, Map<String, Object> message, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.basicPublish(exchange, routingKey, message != null ? ConversionHelper.toJsonObject(message) : null, resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null);
    }

    public static void queueDeclareAuto(RabbitMQClient j_receiver, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclareAuto(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void queueDeclare(RabbitMQClient j_receiver, String queue, boolean durable, boolean exclusive, boolean autoDelete, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void queueDeclare(RabbitMQClient j_receiver, String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, String> config, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclare(queue, durable, exclusive, autoDelete, config != null ? config.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)entry.getValue())) : null, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void queueDelete(RabbitMQClient j_receiver, String queue, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDelete(queue, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void queueDeleteIf(RabbitMQClient j_receiver, String queue, boolean ifUnused, boolean ifEmpty, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }

    public static void messageCount(RabbitMQClient j_receiver, String queue, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.messageCount(queue, resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null);
    }
}

