/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

class Utils {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_DATE_TIME;

    Utils() {
    }

    public static void populate(JsonObject json, Envelope envelope) {
        if (envelope == null) {
            return;
        }
        Utils.put("deliveryTag", envelope.getDeliveryTag(), json);
        Utils.put("isRedeliver", envelope.isRedeliver(), json);
        Utils.put("exchange", envelope.getExchange(), json);
        Utils.put("routingKey", envelope.getRoutingKey(), json);
    }

    public static JsonObject toJson(AMQP.Queue.DeclareOk queueDeclare) {
        if (queueDeclare == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        Utils.put("queue", queueDeclare.getQueue(), json);
        Utils.put("messageCount", queueDeclare.getMessageCount(), json);
        Utils.put("consumerCount", queueDeclare.getConsumerCount(), json);
        return json;
    }

    public static JsonObject toJson(AMQP.Queue.DeleteOk queueDelete) {
        if (queueDelete == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        Utils.put("messageCount", queueDelete.getMessageCount(), json);
        return json;
    }

    public static JsonObject toJson(AMQP.BasicProperties properties) {
        if (properties == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        Utils.put("contentType", properties.getContentType(), json);
        Utils.put("contentEncoding", properties.getContentEncoding(), json);
        Utils.put("headers", properties.getHeaders(), json);
        Utils.put("deliveryMode", properties.getDeliveryMode(), json);
        Utils.put("priority", properties.getPriority(), json);
        Utils.put("correlationId", properties.getCorrelationId(), json);
        Utils.put("replyTo", properties.getReplyTo(), json);
        Utils.put("expiration", properties.getExpiration(), json);
        Utils.put("messageId", properties.getMessageId(), json);
        Utils.put("timestamp", properties.getTimestamp(), json);
        Utils.put("type", properties.getType(), json);
        Utils.put("userId", properties.getUserId(), json);
        Utils.put("appId", properties.getAppId(), json);
        Utils.put("clusterId", properties.getClusterId(), json);
        return json;
    }

    public static AMQP.BasicProperties fromJson(JsonObject json) {
        if (json == null) {
            return new AMQP.BasicProperties();
        }
        return new AMQP.BasicProperties.Builder().contentType(json.getString("contentType")).contentEncoding(json.getString("contentEncoding")).headers(Utils.asMap(json.getJsonObject("headers"))).deliveryMode(json.getInteger("deliveryMode")).priority(json.getInteger("priority")).correlationId(json.getString("correlationId")).replyTo(json.getString("replyTo")).expiration(json.getString("expiration")).messageId(json.getString("messageId")).timestamp(Utils.parseDate(json.getString("timestamp"))).type(json.getString("type")).userId(json.getString("userId")).appId(json.getString("appId")).clusterId(json.getString("clusterId")).build();
    }

    public static Object parse(AMQP.BasicProperties properties, byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        if (properties != null) {
            String encoding = properties.getContentEncoding();
            String ct = properties.getContentType();
            if (ct == null) {
                return Utils.decode(encoding, bytes);
            }
            switch (ct) {
                case "application/json": {
                    return new JsonObject(Utils.decode(encoding, bytes));
                }
                case "application/octet-stream": {
                    return bytes;
                }
            }
            return Utils.decode(encoding, bytes);
        }
        return Utils.decode(null, bytes);
    }

    public static String decode(String encoding, byte[] bytes) throws UnsupportedEncodingException {
        if (encoding == null) {
            return new String(bytes, "UTF-8");
        }
        return new String(bytes, encoding);
    }

    public static byte[] encode(String encoding, String string) throws UnsupportedEncodingException {
        if (encoding == null) {
            return string.getBytes();
        }
        return string.getBytes(encoding);
    }

    public static void put(String field, Object value, JsonObject json) {
        if (value != null) {
            json.put(field, value);
        }
    }

    public static void put(String field, Date value, JsonObject json) {
        if (value == null) {
            return;
        }
        OffsetDateTime date = OffsetDateTime.ofInstant(value.toInstant(), ZoneId.of("UTC"));
        String format = date.format(dateTimeFormatter);
        json.put(field, format);
    }

    public static Date parseDate(String date) {
        if (date == null) {
            return null;
        }
        OffsetDateTime odt = OffsetDateTime.parse(date, dateTimeFormatter);
        return Date.from(odt.toInstant());
    }

    public static Map<String, Object> asMap(JsonObject json) {
        if (json == null) {
            return null;
        }
        return json.getMap();
    }
}

