/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.rabbitmq;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.rabbitmq.RabbitMQOptions;
import java.util.Map;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQClient that = (RabbitMQClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<RabbitMQClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient) obj),
    RabbitMQClient::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQClient delegate;
  
  public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
    return delegate;
  }

  /**
   * Create and return a client.
   * @param vertx the vertx instance
   * @param config the client config
   * @return the client
   */
  public static RabbitMQClient create(Vertx vertx, RabbitMQOptions config) { 
    RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @param resultHandler 
   */
  public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicAck(deliveryTag, multiple, resultHandler);
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   */
  public Single<JsonObject> rxBasicAck(long deliveryTag, boolean multiple) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      basicAck(deliveryTag, multiple, handler);
    });
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @param resultHandler 
   */
  public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   */
  public Single<JsonObject> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      basicNack(deliveryTag, multiple, requeue, handler);
    });
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @param resultHandler 
   */
  public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicGet(queue, autoAck, resultHandler);
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   */
  public Single<JsonObject> rxBasicGet(String queue, boolean autoAck) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      basicGet(queue, autoAck, handler);
    });
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with auto acknowledgement and a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param resultHandler 
   */
  public void basicConsume(String queue, String address, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicConsume(queue, address, resultHandler);
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with auto acknowledgement and a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @return 
   */
  public Completable rxBasicConsume(String queue, String address) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      basicConsume(queue, address, handler);
    });
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param autoAck 
   * @param resultHandler 
   */
  public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicConsume(queue, address, autoAck, resultHandler);
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param autoAck 
   * @return 
   */
  public Completable rxBasicConsume(String queue, String address, boolean autoAck) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      basicConsume(queue, address, autoAck, handler);
    });
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag and error handler
   * @param queue 
   * @param address 
   * @param autoAck 
   * @param resultHandler 
   * @param errorHandler 
   */
  public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler, Handler<Throwable> errorHandler) { 
    delegate.basicConsume(queue, address, autoAck, resultHandler, errorHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param message 
   * @param resultHandler 
   */
  public void basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicPublish(exchange, routingKey, message, resultHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param message 
   * @return 
   */
  public Completable rxBasicPublish(String exchange, String routingKey, JsonObject message) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      basicPublish(exchange, routingKey, message, handler);
    });
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @param resultHandler 
   */
  public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.confirmSelect(resultHandler);
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   */
  public Completable rxConfirmSelect() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      confirmSelect(handler);
    });
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @param resultHandler 
   */
  public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.waitForConfirms(resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   */
  public Completable rxWaitForConfirms() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      waitForConfirms(handler);
    });
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @param resultHandler 
   */
  public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.waitForConfirms(timeout, resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   */
  public Completable rxWaitForConfirms(long timeout) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      waitForConfirms(timeout, handler);
    });
  }

  /**
   * Request specific "quality of service" settings, Limiting the number of unacknowledged messages on
   * a channel (or connection). This limit is applied separately to each new consumer on the channel.
   * @param prefetchCount 
   * @param resultHandler 
   */
  public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicQos(prefetchCount, resultHandler);
  }

  /**
   * Request specific "quality of service" settings, Limiting the number of unacknowledged messages on
   * a channel (or connection). This limit is applied separately to each new consumer on the channel.
   * @param prefetchCount 
   * @return 
   */
  public Completable rxBasicQos(int prefetchCount) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      basicQos(prefetchCount, handler);
    });
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   */
  public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      exchangeDeclare(exchange, type, durable, autoDelete, handler);
    });
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering or an alternate exchnage.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String,String> config, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering or an alternate exchnage.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String,String> config) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      exchangeDeclare(exchange, type, durable, autoDelete, config, handler);
    });
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @param resultHandler 
   */
  public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDelete(exchange, resultHandler);
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   */
  public Completable rxExchangeDelete(String exchange) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      exchangeDelete(exchange, handler);
    });
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeBind(destination, source, routingKey, resultHandler);
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public Completable rxExchangeBind(String destination, String source, String routingKey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      exchangeBind(destination, source, routingKey, handler);
    });
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public Completable rxExchangeUnbind(String destination, String source, String routingKey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      exchangeUnbind(destination, source, routingKey, handler);
    });
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @param resultHandler 
   */
  public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclareAuto(resultHandler);
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   */
  public Single<JsonObject> rxQueueDeclareAuto() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      queueDeclareAuto(handler);
    });
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   */
  public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      queueDeclare(queue, durable, exclusive, autoDelete, handler);
    });
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String,String> config, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String,String> config) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      queueDeclare(queue, durable, exclusive, autoDelete, config, handler);
    });
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @param resultHandler 
   */
  public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDelete(queue, resultHandler);
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   */
  public Single<JsonObject> rxQueueDelete(String queue) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      queueDelete(queue, handler);
    });
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @param resultHandler 
   */
  public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   */
  public Single<JsonObject> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      queueDeleteIf(queue, ifUnused, ifEmpty, handler);
    });
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param resultHandler 
   */
  public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.queueBind(queue, exchange, routingKey, resultHandler);
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public Completable rxQueueBind(String queue, String exchange, String routingKey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      queueBind(queue, exchange, routingKey, handler);
    });
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @param resultHandler 
   */
  public void messageCount(String queue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.messageCount(queue, resultHandler);
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   */
  public Single<JsonObject> rxMessageCount(String queue) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      messageCount(queue, handler);
    });
  }

  /**
   * Start the rabbitMQ client. Create the connection and the chanel.
   * @param resultHandler 
   */
  public void start(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.start(resultHandler);
  }

  /**
   * Start the rabbitMQ client. Create the connection and the chanel.
   * @return 
   */
  public Completable rxStart() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      start(handler);
    });
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its chanel.
   * @param resultHandler 
   */
  public void stop(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.stop(resultHandler);
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its chanel.
   * @return 
   */
  public Completable rxStop() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      stop(handler);
    });
  }

  /**
   * Check if a connection is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Check if a channel is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isOpenChannel() { 
    boolean ret = delegate.isOpenChannel();
    return ret;
  }


  public static  RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
    return arg != null ? new RabbitMQClient(arg) : null;
  }
}
