/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.rabbitmq;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rabbitmq.RabbitMQOptions;
import java.util.Map;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQClient that = (RabbitMQClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<RabbitMQClient> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient) obj),
    RabbitMQClient::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQClient delegate;
  
  public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
    return delegate;
  }

  /**
   * Create and return a client.
   * @param vertx the vertx instance
   * @param config the client config
   * @return the client
   */
  public static RabbitMQClient create(Vertx vertx, RabbitMQOptions config) { 
    RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @param resultHandler 
   */
  public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicAck(deliveryTag, multiple, resultHandler);
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   * @deprecated use {@link #rxBasicAck} instead
   */
  @Deprecated()
  public Observable<JsonObject> basicAckObservable(long deliveryTag, boolean multiple) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicAck(deliveryTag, multiple, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   */
  public Single<JsonObject> rxBasicAck(long deliveryTag, boolean multiple) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicAck(deliveryTag, multiple, fut);
    }));
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @param resultHandler 
   */
  public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   * @deprecated use {@link #rxBasicNack} instead
   */
  @Deprecated()
  public Observable<JsonObject> basicNackObservable(long deliveryTag, boolean multiple, boolean requeue) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicNack(deliveryTag, multiple, requeue, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   */
  public Single<JsonObject> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicNack(deliveryTag, multiple, requeue, fut);
    }));
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @param resultHandler 
   */
  public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.basicGet(queue, autoAck, resultHandler);
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   * @deprecated use {@link #rxBasicGet} instead
   */
  @Deprecated()
  public Observable<JsonObject> basicGetObservable(String queue, boolean autoAck) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicGet(queue, autoAck, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   */
  public Single<JsonObject> rxBasicGet(String queue, boolean autoAck) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicGet(queue, autoAck, fut);
    }));
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with auto acknowledgement and a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param resultHandler 
   */
  public void basicConsume(String queue, String address, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicConsume(queue, address, resultHandler);
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with auto acknowledgement and a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @return 
   * @deprecated use {@link #rxBasicConsume} instead
   */
  @Deprecated()
  public Observable<Void> basicConsumeObservable(String queue, String address) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicConsume(queue, address, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with auto acknowledgement and a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @return 
   */
  public Single<Void> rxBasicConsume(String queue, String address) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicConsume(queue, address, fut);
    }));
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param autoAck 
   * @param resultHandler 
   */
  public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicConsume(queue, address, autoAck, resultHandler);
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param autoAck 
   * @return 
   * @deprecated use {@link #rxBasicConsume} instead
   */
  @Deprecated()
  public Observable<Void> basicConsumeObservable(String queue, String address, boolean autoAck) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicConsume(queue, address, autoAck, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag.
   * @param queue 
   * @param address 
   * @param autoAck 
   * @return 
   */
  public Single<Void> rxBasicConsume(String queue, String address, boolean autoAck) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicConsume(queue, address, autoAck, fut);
    }));
  }

  /**
   * Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag and error handler
   * @param queue 
   * @param address 
   * @param autoAck 
   * @param resultHandler 
   * @param errorHandler 
   */
  public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler, Handler<Throwable> errorHandler) { 
    delegate.basicConsume(queue, address, autoAck, resultHandler, errorHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param message 
   * @param resultHandler 
   */
  public void basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicPublish(exchange, routingKey, message, resultHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param message 
   * @return 
   * @deprecated use {@link #rxBasicPublish} instead
   */
  @Deprecated()
  public Observable<Void> basicPublishObservable(String exchange, String routingKey, JsonObject message) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicPublish(exchange, routingKey, message, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param message 
   * @return 
   */
  public Single<Void> rxBasicPublish(String exchange, String routingKey, JsonObject message) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicPublish(exchange, routingKey, message, fut);
    }));
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @param resultHandler 
   */
  public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.confirmSelect(resultHandler);
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   * @deprecated use {@link #rxConfirmSelect} instead
   */
  @Deprecated()
  public Observable<Void> confirmSelectObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    confirmSelect(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   */
  public Single<Void> rxConfirmSelect() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      confirmSelect(fut);
    }));
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @param resultHandler 
   */
  public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.waitForConfirms(resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   * @deprecated use {@link #rxWaitForConfirms} instead
   */
  @Deprecated()
  public Observable<Void> waitForConfirmsObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    waitForConfirms(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   */
  public Single<Void> rxWaitForConfirms() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      waitForConfirms(fut);
    }));
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @param resultHandler 
   */
  public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.waitForConfirms(timeout, resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   * @deprecated use {@link #rxWaitForConfirms} instead
   */
  @Deprecated()
  public Observable<Void> waitForConfirmsObservable(long timeout) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    waitForConfirms(timeout, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   */
  public Single<Void> rxWaitForConfirms(long timeout) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      waitForConfirms(timeout, fut);
    }));
  }

  /**
   * Request specific "quality of service" settings, Limiting the number of unacknowledged messages on
   * a channel (or connection). This limit is applied separately to each new consumer on the channel.
   * @param prefetchCount 
   * @param resultHandler 
   */
  public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.basicQos(prefetchCount, resultHandler);
  }

  /**
   * Request specific "quality of service" settings, Limiting the number of unacknowledged messages on
   * a channel (or connection). This limit is applied separately to each new consumer on the channel.
   * @param prefetchCount 
   * @return 
   * @deprecated use {@link #rxBasicQos} instead
   */
  @Deprecated()
  public Observable<Void> basicQosObservable(int prefetchCount) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    basicQos(prefetchCount, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Request specific "quality of service" settings, Limiting the number of unacknowledged messages on
   * a channel (or connection). This limit is applied separately to each new consumer on the channel.
   * @param prefetchCount 
   * @return 
   */
  public Single<Void> rxBasicQos(int prefetchCount) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      basicQos(prefetchCount, fut);
    }));
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   * @deprecated use {@link #rxExchangeDeclare} instead
   */
  @Deprecated()
  public Observable<Void> exchangeDeclareObservable(String exchange, String type, boolean durable, boolean autoDelete) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    exchangeDeclare(exchange, type, durable, autoDelete, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   */
  public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exchangeDeclare(exchange, type, durable, autoDelete, fut);
    }));
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering or an alternate exchnage.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String,String> config, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering or an alternate exchnage.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   * @deprecated use {@link #rxExchangeDeclare} instead
   */
  @Deprecated()
  public Observable<Void> exchangeDeclareObservable(String exchange, String type, boolean durable, boolean autoDelete, Map<String,String> config) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering or an alternate exchnage.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String,String> config) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exchangeDeclare(exchange, type, durable, autoDelete, config, fut);
    }));
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @param resultHandler 
   */
  public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeDelete(exchange, resultHandler);
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   * @deprecated use {@link #rxExchangeDelete} instead
   */
  @Deprecated()
  public Observable<Void> exchangeDeleteObservable(String exchange) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    exchangeDelete(exchange, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   */
  public Single<Void> rxExchangeDelete(String exchange) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exchangeDelete(exchange, fut);
    }));
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeBind(destination, source, routingKey, resultHandler);
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   * @deprecated use {@link #rxExchangeBind} instead
   */
  @Deprecated()
  public Observable<Void> exchangeBindObservable(String destination, String source, String routingKey) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    exchangeBind(destination, source, routingKey, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public Single<Void> rxExchangeBind(String destination, String source, String routingKey) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exchangeBind(destination, source, routingKey, fut);
    }));
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   * @deprecated use {@link #rxExchangeUnbind} instead
   */
  @Deprecated()
  public Observable<Void> exchangeUnbindObservable(String destination, String source, String routingKey) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    exchangeUnbind(destination, source, routingKey, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public Single<Void> rxExchangeUnbind(String destination, String source, String routingKey) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      exchangeUnbind(destination, source, routingKey, fut);
    }));
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @param resultHandler 
   */
  public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclareAuto(resultHandler);
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   * @deprecated use {@link #rxQueueDeclareAuto} instead
   */
  @Deprecated()
  public Observable<JsonObject> queueDeclareAutoObservable() { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueDeclareAuto(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   */
  public Single<JsonObject> rxQueueDeclareAuto() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueDeclareAuto(fut);
    }));
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   * @deprecated use {@link #rxQueueDeclare} instead
   */
  @Deprecated()
  public Observable<JsonObject> queueDeclareObservable(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueDeclare(queue, durable, exclusive, autoDelete, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   */
  public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueDeclare(queue, durable, exclusive, autoDelete, fut);
    }));
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String,String> config, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   * @deprecated use {@link #rxQueueDeclare} instead
   */
  @Deprecated()
  public Observable<JsonObject> queueDeclareObservable(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String,String> config) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String,String> config) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueDeclare(queue, durable, exclusive, autoDelete, config, fut);
    }));
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @param resultHandler 
   */
  public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDelete(queue, resultHandler);
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   * @deprecated use {@link #rxQueueDelete} instead
   */
  @Deprecated()
  public Observable<JsonObject> queueDeleteObservable(String queue) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueDelete(queue, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   */
  public Single<JsonObject> rxQueueDelete(String queue) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueDelete(queue, fut);
    }));
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @param resultHandler 
   */
  public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   * @deprecated use {@link #rxQueueDeleteIf} instead
   */
  @Deprecated()
  public Observable<JsonObject> queueDeleteIfObservable(String queue, boolean ifUnused, boolean ifEmpty) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   */
  public Single<JsonObject> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueDeleteIf(queue, ifUnused, ifEmpty, fut);
    }));
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param resultHandler 
   */
  public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.queueBind(queue, exchange, routingKey, resultHandler);
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   * @deprecated use {@link #rxQueueBind} instead
   */
  @Deprecated()
  public Observable<Void> queueBindObservable(String queue, String exchange, String routingKey) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queueBind(queue, exchange, routingKey, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public Single<Void> rxQueueBind(String queue, String exchange, String routingKey) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queueBind(queue, exchange, routingKey, fut);
    }));
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @param resultHandler 
   */
  public void messageCount(String queue, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.messageCount(queue, resultHandler);
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   * @deprecated use {@link #rxMessageCount} instead
   */
  @Deprecated()
  public Observable<JsonObject> messageCountObservable(String queue) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    messageCount(queue, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   */
  public Single<JsonObject> rxMessageCount(String queue) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      messageCount(queue, fut);
    }));
  }

  /**
   * Start the rabbitMQ client. Create the connection and the chanel.
   * @param resultHandler 
   */
  public void start(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.start(resultHandler);
  }

  /**
   * Start the rabbitMQ client. Create the connection and the chanel.
   * @return 
   * @deprecated use {@link #rxStart} instead
   */
  @Deprecated()
  public Observable<Void> startObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    start(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Start the rabbitMQ client. Create the connection and the chanel.
   * @return 
   */
  public Single<Void> rxStart() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      start(fut);
    }));
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its chanel.
   * @param resultHandler 
   */
  public void stop(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.stop(resultHandler);
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its chanel.
   * @return 
   * @deprecated use {@link #rxStop} instead
   */
  @Deprecated()
  public Observable<Void> stopObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    stop(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its chanel.
   * @return 
   */
  public Single<Void> rxStop() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      stop(fut);
    }));
  }

  /**
   * Check if a connection is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Check if a channel is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isOpenChannel() { 
    boolean ret = delegate.isOpenChannel();
    return ret;
  }


  public static  RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
    return arg != null ? new RabbitMQClient(arg) : null;
  }
}
