/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.rabbitmq;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public Single<JsonObject> rxBasicAck(long deliveryTag, boolean multiple) {
        return new AsyncResultSingle(handler -> this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public Single<JsonObject> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return new AsyncResultSingle(handler -> this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, resultHandler);
    }

    public Single<JsonObject> rxBasicGet(String queue, boolean autoAck) {
        return new AsyncResultSingle(handler -> this.basicGet(queue, autoAck, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void basicConsume(String queue, String address, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicConsume(queue, address, resultHandler);
    }

    public Completable rxBasicConsume(String queue, String address) {
        return new AsyncResultCompletable(handler -> this.basicConsume(queue, address, (Handler<AsyncResult<Void>>)handler));
    }

    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler);
    }

    public Completable rxBasicConsume(String queue, String address, boolean autoAck) {
        return new AsyncResultCompletable(handler -> this.basicConsume(queue, address, autoAck, (Handler<AsyncResult<Void>>)handler));
    }

    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<Void>> resultHandler, Handler<Throwable> errorHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler, errorHandler);
    }

    public void basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, message, resultHandler);
    }

    public Completable rxBasicPublish(String exchange, String routingKey, JsonObject message) {
        return new AsyncResultCompletable(handler -> this.basicPublish(exchange, routingKey, message, (Handler<AsyncResult<Void>>)handler));
    }

    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    public Completable rxConfirmSelect() {
        return new AsyncResultCompletable(handler -> this.confirmSelect((Handler<AsyncResult<Void>>)handler));
    }

    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    public Completable rxWaitForConfirms() {
        return new AsyncResultCompletable(handler -> this.waitForConfirms((Handler<AsyncResult<Void>>)handler));
    }

    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    public Completable rxWaitForConfirms(long timeout) {
        return new AsyncResultCompletable(handler -> this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)handler));
    }

    public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    public Completable rxBasicQos(int prefetchCount) {
        return new AsyncResultCompletable(handler -> this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)handler));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return new AsyncResultCompletable(handler -> this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)handler));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return new AsyncResultCompletable(handler -> this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)handler));
    }

    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    public Completable rxExchangeDelete(String exchange) {
        return new AsyncResultCompletable(handler -> this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)handler));
    }

    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, resultHandler);
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey) {
        return new AsyncResultCompletable(handler -> this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey) {
        return new AsyncResultCompletable(handler -> this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return new AsyncResultSingle(handler -> this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)handler));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return new AsyncResultSingle(handler -> this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    }

    public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return new AsyncResultSingle(handler -> this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    public Single<JsonObject> rxQueueDelete(String queue) {
        return new AsyncResultSingle(handler -> this.queueDelete(queue, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    public Single<JsonObject> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return new AsyncResultSingle(handler -> this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, resultHandler);
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey) {
        return new AsyncResultCompletable(handler -> this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public void messageCount(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    public Single<JsonObject> rxMessageCount(String queue) {
        return new AsyncResultSingle(handler -> this.messageCount(queue, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public void start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    public Completable rxStart() {
        return new AsyncResultCompletable(handler -> this.start((Handler<AsyncResult<Void>>)handler));
    }

    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    public Completable rxStop() {
        return new AsyncResultCompletable(handler -> this.stop((Handler<AsyncResult<Void>>)handler));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

