/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rabbitmq.impl.RabbitMQClientImpl;
import java.util.Map;

@VertxGen
public interface RabbitMQClient {
    public static RabbitMQClient create(Vertx vertx, RabbitMQOptions config) {
        return new RabbitMQClientImpl(vertx, config);
    }

    @GenIgnore
    public static RabbitMQClient create(Vertx vertx, JsonObject config) {
        return new RabbitMQClientImpl(vertx, new RabbitMQOptions(config));
    }

    public void basicAck(long var1, boolean var3, Handler<AsyncResult<JsonObject>> var4);

    public void basicNack(long var1, boolean var3, boolean var4, Handler<AsyncResult<JsonObject>> var5);

    public void basicGet(String var1, boolean var2, Handler<AsyncResult<JsonObject>> var3);

    public void basicConsume(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public void basicConsume(String var1, String var2, boolean var3, Handler<AsyncResult<Void>> var4);

    public void basicConsume(String var1, String var2, boolean var3, Handler<AsyncResult<Void>> var4, Handler<Throwable> var5);

    public void basicPublish(String var1, String var2, JsonObject var3, Handler<AsyncResult<Void>> var4);

    public void confirmSelect(Handler<AsyncResult<Void>> var1);

    public void waitForConfirms(Handler<AsyncResult<Void>> var1);

    public void waitForConfirms(long var1, Handler<AsyncResult<Void>> var3);

    public void basicQos(int var1, Handler<AsyncResult<Void>> var2);

    public void exchangeDeclare(String var1, String var2, boolean var3, boolean var4, Handler<AsyncResult<Void>> var5);

    @GenIgnore
    @Deprecated
    public void exchangeDeclare(String var1, String var2, boolean var3, boolean var4, Map<String, String> var5, Handler<AsyncResult<Void>> var6);

    public void exchangeDeclare(String var1, String var2, boolean var3, boolean var4, JsonObject var5, Handler<AsyncResult<Void>> var6);

    public void exchangeDelete(String var1, Handler<AsyncResult<Void>> var2);

    public void exchangeBind(String var1, String var2, String var3, Handler<AsyncResult<Void>> var4);

    public void exchangeUnbind(String var1, String var2, String var3, Handler<AsyncResult<Void>> var4);

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> var1);

    public void queueDeclare(String var1, boolean var2, boolean var3, boolean var4, Handler<AsyncResult<JsonObject>> var5);

    @GenIgnore
    @Deprecated
    public void queueDeclare(String var1, boolean var2, boolean var3, boolean var4, Map<String, String> var5, Handler<AsyncResult<JsonObject>> var6);

    public void queueDeclare(String var1, boolean var2, boolean var3, boolean var4, JsonObject var5, Handler<AsyncResult<JsonObject>> var6);

    public void queueDelete(String var1, Handler<AsyncResult<JsonObject>> var2);

    public void queueDeleteIf(String var1, boolean var2, boolean var3, Handler<AsyncResult<JsonObject>> var4);

    public void queueBind(String var1, String var2, String var3, Handler<AsyncResult<Void>> var4);

    public void messageCount(String var1, Handler<AsyncResult<JsonObject>> var2);

    public void start(Handler<AsyncResult<Void>> var1);

    public void stop(Handler<AsyncResult<Void>> var1);

    public boolean isConnected();

    public boolean isOpenChannel();
}

