/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import com.rabbitmq.client.Address;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.RabbitMQOptionsConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RabbitMQOptions {
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASSWORD = "guest";
    public static final String DEFAULT_VIRTUAL_HOST = "/";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_REQUESTED_HEARTBEAT = 60;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_REQUESTED_CHANNEL_MAX = 2047;
    public static final long DEFAULT_NETWORK_RECOVERY_INTERNAL = 5000L;
    public static final boolean DEFAULT_AUTOMATIC_RECOVERY_ENABLED = false;
    public static final long DEFAULT_CONNECTION_RETRY_DELAY = 10000L;
    public static final Integer DEFAULT_CONNECTION_RETRIES = null;
    private Integer connectionRetries = DEFAULT_CONNECTION_RETRIES;
    private long connectionRetryDelay = 10000L;
    private String uri = null;
    private List<Address> addresses = Collections.emptyList();
    private String user = "guest";
    private String password = "guest";
    private String host = "localhost";
    private String virtualHost = "/";
    private int port = -1;
    private int connectionTimeout = 60000;
    private int requestedHeartbeat = 60;
    private int handshakeTimeout = 10000;
    private int requestedChannelMax = 2047;
    private long networkRecoveryInterval = 5000L;
    private boolean automaticRecoveryEnabled = false;
    private boolean includeProperties = false;

    public RabbitMQOptions() {
    }

    public RabbitMQOptions(JsonObject json) {
        this();
        RabbitMQOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RabbitMQOptions(RabbitMQOptions that) {
        this.connectionRetries = that.connectionRetries;
        this.connectionRetryDelay = that.connectionRetryDelay;
        this.uri = that.uri;
        this.addresses = that.addresses;
        this.user = that.user;
        this.password = that.password;
        this.host = that.host;
        this.virtualHost = that.virtualHost;
        this.port = that.port;
        this.connectionTimeout = that.connectionTimeout;
        this.requestedHeartbeat = that.requestedHeartbeat;
        this.handshakeTimeout = that.handshakeTimeout;
        this.networkRecoveryInterval = that.networkRecoveryInterval;
        this.automaticRecoveryEnabled = that.automaticRecoveryEnabled;
        this.includeProperties = that.includeProperties;
        this.requestedChannelMax = that.requestedChannelMax;
    }

    public Integer getConnectionRetries() {
        return this.connectionRetries;
    }

    public RabbitMQOptions setConnectionRetries(Integer connectionRetries) {
        this.connectionRetries = connectionRetries;
        return this;
    }

    public long getConnectionRetryDelay() {
        return this.connectionRetryDelay;
    }

    public RabbitMQOptions setConnectionRetryDelay(long connectionRetryDelay) {
        this.connectionRetryDelay = connectionRetryDelay;
        return this;
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public RabbitMQOptions setAddresses(List<Address> addresses) {
        this.addresses = new ArrayList<Address>(addresses);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public RabbitMQOptions setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public RabbitMQOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RabbitMQOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RabbitMQOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public RabbitMQOptions setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RabbitMQOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RabbitMQOptions setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public RabbitMQOptions setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
        return this;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public RabbitMQOptions setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public RabbitMQOptions setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
        return this;
    }

    public long getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public RabbitMQOptions setNetworkRecoveryInterval(long networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
        return this;
    }

    public boolean isAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public RabbitMQOptions setAutomaticRecoveryEnabled(boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
        return this;
    }

    public boolean getIncludeProperties() {
        return this.includeProperties;
    }

    public RabbitMQOptions setIncludeProperties(boolean includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }
}

