/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rabbitmq.impl.ConsumerHandler;
import io.vertx.rabbitmq.impl.QueueConsumerHandler;
import io.vertx.rabbitmq.impl.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RabbitMQClientImpl
implements RabbitMQClient,
ShutdownListener {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClientImpl.class);
    private static final JsonObject emptyConfig = new JsonObject();
    private final Vertx vertx;
    private final RabbitMQOptions config;
    private final Integer retries;
    private final boolean includeProperties;
    private Connection connection;
    private Channel channel;
    private boolean channelConfirms = false;

    public RabbitMQClientImpl(Vertx vertx, RabbitMQOptions config) {
        this.vertx = vertx;
        this.config = config;
        this.retries = config.getConnectionRetries();
        this.includeProperties = config.getIncludeProperties();
    }

    private static Connection newConnection(RabbitMQOptions config) throws IOException, TimeoutException {
        ConnectionFactory cf = new ConnectionFactory();
        String uri = config.getUri();
        List<Address> addresses = null;
        if (uri != null) {
            try {
                cf.setUri(uri);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid rabbitmq connection uri " + uri);
            }
        } else {
            cf.setUsername(config.getUser());
            cf.setPassword(config.getPassword());
            addresses = config.getAddresses().isEmpty() ? Collections.singletonList(new Address(config.getHost(), config.getPort())) : config.getAddresses();
            cf.setVirtualHost(config.getVirtualHost());
        }
        cf.setConnectionTimeout(config.getConnectionTimeout());
        cf.setRequestedHeartbeat(config.getRequestedHeartbeat());
        cf.setHandshakeTimeout(config.getHandshakeTimeout());
        cf.setRequestedChannelMax(config.getRequestedChannelMax());
        cf.setNetworkRecoveryInterval(config.getNetworkRecoveryInterval());
        cf.setAutomaticRecoveryEnabled(config.isAutomaticRecoveryEnabled());
        return addresses == null ? cf.newConnection() : cf.newConnection(addresses);
    }

    @Override
    public boolean isConnected() {
        boolean connected = false;
        if (this.connection != null && this.connection.isOpen()) {
            connected = true;
        }
        return connected;
    }

    @Override
    public boolean isOpenChannel() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicAck(deliveryTag, multiple);
            return null;
        });
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicNack(deliveryTag, multiple, requeue);
            return null;
        });
    }

    @Override
    public void basicConsumer(String queue, QueueOptions options, Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.forChannel(ar -> {
            if (ar.succeeded()) {
                RabbitMQConsumer q = ((QueueConsumerHandler)((Object)((Object)ar.result()))).queue();
                q.resume();
                resultHandler.handle((Object)Future.succeededFuture((Object)q));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }, channel -> {
            QueueConsumerHandler handler = new QueueConsumerHandler(this.vertx, channel, this.includeProperties, options);
            String consumerTag = channel.basicConsume(queue, options.isAutoAck(), (Consumer)handler);
            return handler;
        });
    }

    @Override
    public void basicConsume(String queue, String address, Handler<AsyncResult<String>> resultHandler) {
        this.basicConsume(queue, address, true, resultHandler);
    }

    @Override
    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler) {
        this.basicConsume(queue, address, autoAck, resultHandler, null);
    }

    @Override
    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler, Handler<Throwable> errorHandler) {
        this.forChannel(resultHandler, channel -> channel.basicConsume(queue, autoAck, (Consumer)new ConsumerHandler(this.vertx, channel, this.includeProperties, (Handler<AsyncResult<JsonObject>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.vertx.eventBus().send(address, ar.result());
            } else {
                log.error((Object)"Exception occurred inside rabbitmq service consumer.", ar.cause());
                if (errorHandler != null) {
                    errorHandler.handle((Object)ar.cause());
                }
            }
        }))));
    }

    @Override
    public void basicCancel(String consumerTag) {
        this.basicCancel(consumerTag, null);
    }

    @Override
    public void basicCancel(String consumerTag, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicCancel(consumerTag);
            return null;
        });
    }

    @Override
    public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            GetResponse response = channel.basicGet(queue, autoAck);
            if (response == null) {
                return null;
            }
            JsonObject json = new JsonObject();
            Utils.populate(json, response.getEnvelope());
            if (this.includeProperties) {
                Utils.put("properties", Utils.toJson(response.getProps()), json);
            }
            Utils.put("body", Utils.parse(response.getProps(), response.getBody()), json);
            Utils.put("messageCount", response.getMessageCount(), json);
            return json;
        });
    }

    @Override
    public void basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            byte[] body;
            String encoding;
            JsonObject properties = message.getJsonObject("properties");
            String contentType = properties == null ? null : properties.getString("contentType");
            String string = encoding = properties == null ? null : properties.getString("contentEncoding");
            if (contentType != null) {
                switch (contentType) {
                    case "application/json": {
                        body = Utils.encode(encoding, message.getJsonObject("body").toString());
                        break;
                    }
                    case "application/octet-stream": {
                        body = message.getBinary("body");
                        break;
                    }
                    default: {
                        body = Utils.encode(encoding, message.getString("body"));
                        break;
                    }
                }
            } else {
                body = Utils.encode(encoding, message.getString("body"));
            }
            channel.basicPublish(exchange, routingKey, Utils.fromJson(properties), body);
            return null;
        });
    }

    @Override
    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.confirmSelect();
            this.channelConfirms = true;
            return null;
        });
    }

    @Override
    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.waitForConfirmsOrDie();
            return null;
        });
    }

    @Override
    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.waitForConfirmsOrDie(timeout);
            return null;
        });
    }

    @Override
    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicQos(prefetchSize, prefetchCount, global);
            return null;
        });
    }

    @Override
    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, emptyConfig, resultHandler);
    }

    @Override
    @Deprecated
    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, String> config, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeDeclare(exchange, type, durable, autoDelete, this.toArgumentsMap(config));
            return null;
        });
    }

    @Override
    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeDeclare(exchange, type, durable, autoDelete, new LinkedHashMap(config.getMap()));
            return null;
        });
    }

    @Override
    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeDelete(exchange);
            return null;
        });
    }

    @Override
    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeBind(destination, source, routingKey);
            return null;
        });
    }

    @Override
    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeBind(destination, source, routingKey, arguments);
            return null;
        });
    }

    @Override
    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeUnbind(destination, source, routingKey);
            return null;
        });
    }

    @Override
    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeUnbind(destination, source, routingKey, arguments);
            return null;
        });
    }

    @Override
    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeclareOk result = channel.queueDeclare();
            return Utils.toJson(result);
        });
    }

    @Override
    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, emptyConfig, resultHandler);
    }

    @Override
    @Deprecated
    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, String> config, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeclareOk result = channel.queueDeclare(queue, durable, exclusive, autoDelete, this.toArgumentsMap(config));
            return Utils.toJson(result);
        });
    }

    @Override
    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeclareOk result = channel.queueDeclare(queue, durable, exclusive, autoDelete, new LinkedHashMap(config.getMap()));
            return Utils.toJson(result);
        });
    }

    @Override
    public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeleteOk result = channel.queueDelete(queue);
            return Utils.toJson(result);
        });
    }

    @Override
    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeleteOk result = channel.queueDelete(queue, ifUnused, ifEmpty);
            return Utils.toJson(result);
        });
    }

    @Override
    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.queueBind(queue, exchange, routingKey);
            return null;
        });
    }

    @Override
    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.queueBind(queue, exchange, routingKey, arguments);
            return null;
        });
    }

    @Override
    public void queueUnbind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.queueUnbind(queue, exchange, routingKey);
            return null;
        });
    }

    @Override
    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.queueUnbind(queue, exchange, routingKey, arguments);
            return null;
        });
    }

    @Override
    public void messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.forChannel(resultHandler, channel -> channel.messageCount(queue));
    }

    @Override
    public void start(Handler<AsyncResult<Void>> resultHandler) {
        log.info((Object)"Starting rabbitmq client");
        this.start(0, resultHandler);
    }

    private void start(int attempts, Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            try {
                this.connect();
                future.complete();
            }
            catch (IOException | TimeoutException e) {
                log.error((Object)"Could not connect to rabbitmq", (Throwable)e);
                future.fail((Throwable)e);
            }
        }, ar -> {
            if (ar.succeeded() || this.retries == null) {
                resultHandler.handle(ar);
            } else if (attempts >= this.retries) {
                log.info((Object)("Max number of connect attempts (" + this.retries + ") reached. Will not attempt to connect again"));
                resultHandler.handle(ar);
            } else {
                long delay = this.config.getConnectionRetryDelay();
                log.info((Object)"Attempting to reconnect to rabbitmq...");
                this.vertx.setTimer(delay, id -> {
                    log.debug((Object)("Reconnect attempt # " + attempts));
                    this.start(attempts + 1, resultHandler);
                });
            }
        });
    }

    @Override
    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        log.info((Object)"Stopping rabbitmq client");
        this.vertx.executeBlocking(future -> {
            try {
                this.disconnect();
                future.complete();
            }
            catch (IOException e) {
                future.fail((Throwable)e);
            }
        }, resultHandler);
    }

    private <T> void forChannel(Handler<AsyncResult<T>> resultHandler, ChannelHandler<T> channelHandler) {
        if (this.connection == null || this.channel == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"Not connected"));
            return;
        }
        if (!this.channel.isOpen()) {
            try {
                log.debug((Object)"channel is close, try create Channel");
                this.channel = this.connection.createChannel();
                if (this.channelConfirms) {
                    this.channel.confirmSelect();
                }
            }
            catch (IOException e) {
                log.debug((Object)"create channel error");
                resultHandler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }
        this.vertx.executeBlocking(future -> {
            try {
                Object t = channelHandler.handle(this.channel);
                future.complete(t);
            }
            catch (Throwable t) {
                future.fail(t);
            }
        }, resultHandler);
    }

    private void connect() throws IOException, TimeoutException {
        log.debug((Object)"Connecting to rabbitmq...");
        this.connection = RabbitMQClientImpl.newConnection(this.config);
        this.connection.addShutdownListener((ShutdownListener)this);
        this.channel = this.connection.createChannel();
        log.debug((Object)"Connected to rabbitmq !");
    }

    private void disconnect() throws IOException {
        try {
            log.debug((Object)"Disconnecting from rabbitmq...");
            this.connection.close();
            log.debug((Object)"Disconnected from rabbitmq !");
        }
        finally {
            this.connection = null;
            this.channel = null;
        }
    }

    private Map<String, Object> toArgumentsMap(Map<String, String> map) {
        HashMap transformedMap = null;
        if (map != null) {
            transformedMap = new HashMap();
            map.forEach(transformedMap::put);
        }
        return transformedMap;
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        if (cause.isInitiatedByApplication()) {
            return;
        }
        log.info((Object)"RabbitMQ connection shutdown! The client will attempt to reconnect automatically", (Throwable)cause);
    }

    private static interface ChannelHandler<T> {
        public T handle(Channel var1) throws Exception;
    }
}

