/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.impl.ConsumerHandler;
import io.vertx.rabbitmq.impl.RabbitMQConsumerImpl;
import io.vertx.rabbitmq.impl.RabbitMQMessageImpl;

public class QueueConsumerHandler
extends DefaultConsumer {
    private final RabbitMQConsumerImpl queue;
    private final Context handlerContext;
    private static final Logger log = LoggerFactory.getLogger(ConsumerHandler.class);

    QueueConsumerHandler(Vertx vertx, Channel channel, QueueOptions options) {
        super(channel);
        this.handlerContext = vertx.getOrCreateContext();
        this.queue = new RabbitMQConsumerImpl(this.handlerContext, this, options);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        RabbitMQMessageImpl msg = new RabbitMQMessageImpl(body, consumerTag, envelope, properties, null);
        this.handlerContext.runOnContext(v -> this.queue.handleMessage(msg));
    }

    public void handleCancel(String consumerTag) {
        log.debug((Object)"consumer has been cancelled unexpectedly");
        this.queue.handleEnd();
    }

    public RabbitMQConsumer queue() {
        return this.queue;
    }
}

