/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.RabbitMQMessage;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rabbitmq.impl.QueueConsumerHandler;
import io.vertx.rabbitmq.impl.RabbitMQMessageImpl;
import io.vertx.rabbitmq.impl.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RabbitMQClientImpl
implements RabbitMQClient,
ShutdownListener {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClientImpl.class);
    private static final JsonObject emptyConfig = new JsonObject();
    private final Vertx vertx;
    private final RabbitMQOptions config;
    private final Integer retries;
    private Connection connection;
    private Channel channel;
    private boolean channelConfirms = false;

    public RabbitMQClientImpl(Vertx vertx, RabbitMQOptions config) {
        this.vertx = vertx;
        this.config = config;
        this.retries = config.getConnectionRetries();
    }

    private static Connection newConnection(RabbitMQOptions config) throws IOException, TimeoutException {
        ConnectionFactory cf = new ConnectionFactory();
        String uri = config.getUri();
        List<Address> addresses = null;
        if (uri != null) {
            try {
                cf.setUri(uri);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid rabbitmq connection uri " + uri);
            }
        } else {
            cf.setUsername(config.getUser());
            cf.setPassword(config.getPassword());
            addresses = config.getAddresses().isEmpty() ? Collections.singletonList(new Address(config.getHost(), config.getPort())) : config.getAddresses();
            cf.setVirtualHost(config.getVirtualHost());
        }
        cf.setConnectionTimeout(config.getConnectionTimeout());
        cf.setRequestedHeartbeat(config.getRequestedHeartbeat());
        cf.setHandshakeTimeout(config.getHandshakeTimeout());
        cf.setRequestedChannelMax(config.getRequestedChannelMax());
        cf.setNetworkRecoveryInterval(config.getNetworkRecoveryInterval());
        cf.setAutomaticRecoveryEnabled(config.isAutomaticRecoveryEnabled());
        return addresses == null ? cf.newConnection() : cf.newConnection(addresses);
    }

    @Override
    public boolean isConnected() {
        boolean connected = false;
        if (this.connection != null && this.connection.isOpen()) {
            connected = true;
        }
        return connected;
    }

    @Override
    public boolean isOpenChannel() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicAck(deliveryTag, multiple);
            return null;
        });
    }

    @Override
    public Future<Void> basicAck(long deliveryTag, boolean multiple) {
        Promise promise = Promise.promise();
        this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicNack(deliveryTag, multiple, requeue);
            return null;
        });
    }

    @Override
    public Future<Void> basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        Promise promise = Promise.promise();
        this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void basicConsumer(String queue, QueueOptions options, Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.forChannel(ar -> {
            if (ar.succeeded()) {
                RabbitMQConsumer q = ((QueueConsumerHandler)((Object)((Object)ar.result()))).queue();
                q.resume();
                resultHandler.handle((Object)Future.succeededFuture((Object)q));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }, channel -> {
            QueueConsumerHandler handler = new QueueConsumerHandler(this.vertx, channel, options);
            String consumerTag = channel.basicConsume(queue, options.isAutoAck(), (Consumer)handler);
            return handler;
        });
    }

    @Override
    public Future<RabbitMQConsumer> basicConsumer(String queue, QueueOptions options) {
        Promise promise = Promise.promise();
        this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)promise);
        return promise.future();
    }

    @Override
    public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<RabbitMQMessage>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            GetResponse response = channel.basicGet(queue, autoAck);
            if (response == null) {
                return null;
            }
            return new RabbitMQMessageImpl(response.getBody(), null, response.getEnvelope(), response.getProps(), response.getMessageCount());
        });
    }

    @Override
    public Future<RabbitMQMessage> basicGet(String queue, boolean autoAck) {
        Promise promise = Promise.promise();
        this.basicGet(queue, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)promise);
        return promise.future();
    }

    @Override
    public void basicPublish(String exchange, String routingKey, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.basicPublish(exchange, routingKey, (BasicProperties)new AMQP.BasicProperties(), body, resultHandler);
    }

    @Override
    public Future<Void> basicPublish(String exchange, String routingKey, Buffer body) {
        Promise promise = Promise.promise();
        this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicPublish(exchange, routingKey, (AMQP.BasicProperties)properties, body.getBytes());
            return null;
        });
    }

    @Override
    public Future<Void> basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        Promise promise = Promise.promise();
        this.basicPublish(exchange, routingKey, properties, body, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.confirmSelect();
            this.channelConfirms = true;
            return null;
        });
    }

    @Override
    public Future<Void> confirmSelect() {
        Promise promise = Promise.promise();
        this.confirmSelect((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.waitForConfirmsOrDie();
            return null;
        });
    }

    @Override
    public Future<Void> waitForConfirms() {
        Promise promise = Promise.promise();
        this.waitForConfirms((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.waitForConfirmsOrDie(timeout);
            return null;
        });
    }

    @Override
    public Future<Void> waitForConfirms(long timeout) {
        Promise promise = Promise.promise();
        this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.basicQos(prefetchSize, prefetchCount, global);
            return null;
        });
    }

    @Override
    public Future<Void> basicQos(int prefetchSize, int prefetchCount, boolean global) {
        Promise promise = Promise.promise();
        this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, emptyConfig, resultHandler);
    }

    @Override
    public Future<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        Promise promise = Promise.promise();
        this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeDeclare(exchange, type, durable, autoDelete, new LinkedHashMap(config.getMap()));
            return null;
        });
    }

    @Override
    public Future<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        Promise promise = Promise.promise();
        this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeDelete(exchange);
            return null;
        });
    }

    @Override
    public Future<Void> exchangeDelete(String exchange) {
        Promise promise = Promise.promise();
        this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeBind(destination, source, routingKey);
            return null;
        });
    }

    @Override
    public Future<Void> exchangeBind(String destination, String source, String routingKey) {
        Promise promise = Promise.promise();
        this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.exchangeUnbind(destination, source, routingKey);
            return null;
        });
    }

    @Override
    public Future<Void> exchangeUnbind(String destination, String source, String routingKey) {
        Promise promise = Promise.promise();
        this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            AMQP.Queue.DeclareOk result = channel.queueDeclare();
            return Utils.toJson(result);
        });
    }

    @Override
    public Future<JsonObject> queueDeclareAuto() {
        Promise promise = Promise.promise();
        this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    @Override
    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, emptyConfig, resultHandler);
    }

    @Override
    public Future<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        Promise promise = Promise.promise();
        this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)promise);
        return promise.future();
    }

    @Override
    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.forChannel(resultHandler, channel -> channel.queueDeclare(queue, durable, exclusive, autoDelete, new LinkedHashMap(config.getMap())));
    }

    @Override
    public Future<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        Promise promise = Promise.promise();
        this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)promise);
        return promise.future();
    }

    @Override
    public void queueDelete(String queue, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.forChannel(resultHandler, channel -> channel.queueDelete(queue));
    }

    @Override
    public Future<AMQP.Queue.DeleteOk> queueDelete(String queue) {
        Promise promise = Promise.promise();
        this.queueDelete(queue, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)promise);
        return promise.future();
    }

    @Override
    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.forChannel(resultHandler, channel -> channel.queueDelete(queue, ifUnused, ifEmpty));
    }

    @Override
    public Future<AMQP.Queue.DeleteOk> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        Promise promise = Promise.promise();
        this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)promise);
        return promise.future();
    }

    @Override
    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.forChannel(resultHandler, channel -> {
            channel.queueBind(queue, exchange, routingKey);
            return null;
        });
    }

    @Override
    public Future<Void> queueBind(String queue, String exchange, String routingKey) {
        Promise promise = Promise.promise();
        this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.forChannel(resultHandler, channel -> channel.messageCount(queue));
    }

    @Override
    public Future<Long> messageCount(String queue) {
        Promise promise = Promise.promise();
        this.messageCount(queue, (Handler<AsyncResult<Long>>)promise);
        return promise.future();
    }

    @Override
    public void start(Handler<AsyncResult<Void>> resultHandler) {
        log.info((Object)"Starting rabbitmq client");
        this.start(0, resultHandler);
    }

    @Override
    public Future<Void> start() {
        Promise promise = Promise.promise();
        this.start((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    private void start(int attempts, Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            try {
                this.connect();
                future.complete();
            }
            catch (IOException | TimeoutException e) {
                log.error((Object)"Could not connect to rabbitmq", (Throwable)e);
                future.fail((Throwable)e);
            }
        }, ar -> {
            if (ar.succeeded() || this.retries == null) {
                resultHandler.handle(ar);
            } else if (attempts >= this.retries) {
                log.info((Object)("Max number of connect attempts (" + this.retries + ") reached. Will not attempt to connect again"));
                resultHandler.handle(ar);
            } else {
                long delay = this.config.getConnectionRetryDelay();
                log.info((Object)"Attempting to reconnect to rabbitmq...");
                this.vertx.setTimer(delay, id -> {
                    log.debug((Object)("Reconnect attempt # " + attempts));
                    this.start(attempts + 1, resultHandler);
                });
            }
        });
    }

    @Override
    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        log.info((Object)"Stopping rabbitmq client");
        this.vertx.executeBlocking(future -> {
            try {
                this.disconnect();
                future.complete();
            }
            catch (IOException e) {
                future.fail((Throwable)e);
            }
        }, resultHandler);
    }

    @Override
    public Future<Void> stop() {
        Promise promise = Promise.promise();
        this.stop((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    private <T> void forChannel(Handler<AsyncResult<T>> resultHandler, ChannelHandler<T> channelHandler) {
        if (this.connection == null || this.channel == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"Not connected"));
            return;
        }
        if (!this.channel.isOpen()) {
            try {
                log.debug((Object)"channel is close, try create Channel");
                this.channel = this.connection.createChannel();
                if (this.channelConfirms) {
                    this.channel.confirmSelect();
                }
            }
            catch (IOException e) {
                log.debug((Object)"create channel error");
                resultHandler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }
        this.vertx.executeBlocking(future -> {
            try {
                Object t = channelHandler.handle(this.channel);
                future.complete(t);
            }
            catch (Throwable t) {
                future.fail(t);
            }
        }, resultHandler);
    }

    private void connect() throws IOException, TimeoutException {
        log.debug((Object)"Connecting to rabbitmq...");
        this.connection = RabbitMQClientImpl.newConnection(this.config);
        this.connection.addShutdownListener((ShutdownListener)this);
        this.channel = this.connection.createChannel();
        log.debug((Object)"Connected to rabbitmq !");
    }

    private void disconnect() throws IOException {
        try {
            log.debug((Object)"Disconnecting from rabbitmq...");
            this.connection.close();
            log.debug((Object)"Disconnected from rabbitmq !");
        }
        finally {
            this.connection = null;
            this.channel = null;
        }
    }

    private Map<String, Object> toArgumentsMap(Map<String, String> map) {
        HashMap transformedMap = null;
        if (map != null) {
            transformedMap = new HashMap();
            map.forEach(transformedMap::put);
        }
        return transformedMap;
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        if (cause.isInitiatedByApplication()) {
            return;
        }
        log.info((Object)"RabbitMQ connection shutdown! The client will attempt to reconnect automatically", (Throwable)cause);
    }

    private static interface ChannelHandler<T> {
        public T handle(Channel var1) throws Exception;
    }
}

