/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import com.rabbitmq.client.Address;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.rabbitmq.RabbitMQOptionsConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RabbitMQOptions
extends NetClientOptions {
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASSWORD = "guest";
    public static final String DEFAULT_VIRTUAL_HOST = "/";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_REQUESTED_HEARTBEAT = 60;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_REQUESTED_CHANNEL_MAX = 2047;
    public static final long DEFAULT_NETWORK_RECOVERY_INTERNAL = 5000L;
    public static final boolean DEFAULT_AUTOMATIC_RECOVERY_ENABLED = false;
    public static final long DEFAULT_RECONNECT_INTERVAL = 10000L;
    private String uri = null;
    private List<Address> addresses = Collections.emptyList();
    private String user;
    private String password;
    private String host;
    private String virtualHost;
    private int port;
    private int connectionTimeout;
    private int requestedHeartbeat;
    private int handshakeTimeout;
    private int requestedChannelMax;
    private long networkRecoveryInterval;
    private boolean automaticRecoveryEnabled;
    private boolean includeProperties;

    public RabbitMQOptions() {
        this.setReconnectInterval(10000L);
        this.init();
    }

    public RabbitMQOptions(JsonObject json) {
        super(json);
        this.init();
        RabbitMQOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RabbitMQOptions(RabbitMQOptions other) {
        super((NetClientOptions)other);
        this.uri = other.uri;
        this.addresses = other.addresses;
        this.user = other.user;
        this.password = other.password;
        this.host = other.host;
        this.virtualHost = other.virtualHost;
        this.port = other.port;
        this.connectionTimeout = other.connectionTimeout;
        this.requestedHeartbeat = other.requestedHeartbeat;
        this.handshakeTimeout = other.handshakeTimeout;
        this.networkRecoveryInterval = other.networkRecoveryInterval;
        this.automaticRecoveryEnabled = other.automaticRecoveryEnabled;
        this.includeProperties = other.includeProperties;
        this.requestedChannelMax = other.requestedChannelMax;
    }

    private void init() {
        this.uri = null;
        this.addresses = Collections.emptyList();
        this.user = "guest";
        this.password = "guest";
        this.host = DEFAULT_HOST;
        this.virtualHost = DEFAULT_VIRTUAL_HOST;
        this.port = -1;
        this.connectionTimeout = 60000;
        this.requestedHeartbeat = 60;
        this.handshakeTimeout = 10000;
        this.requestedChannelMax = 2047;
        this.networkRecoveryInterval = 5000L;
        this.automaticRecoveryEnabled = false;
        this.includeProperties = false;
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public RabbitMQOptions setAddresses(List<Address> addresses) {
        this.addresses = new ArrayList<Address>(addresses);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public RabbitMQOptions setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public RabbitMQOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RabbitMQOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RabbitMQOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public RabbitMQOptions setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RabbitMQOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RabbitMQOptions setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public RabbitMQOptions setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
        return this;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public RabbitMQOptions setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public RabbitMQOptions setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
        return this;
    }

    public long getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public RabbitMQOptions setNetworkRecoveryInterval(long networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
        return this;
    }

    public boolean isAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public RabbitMQOptions setAutomaticRecoveryEnabled(boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
        return this;
    }

    public boolean getIncludeProperties() {
        return this.includeProperties;
    }

    public RabbitMQOptions setIncludeProperties(boolean includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public RabbitMQOptions setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    public RabbitMQOptions setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public RabbitMQOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public RabbitMQOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public RabbitMQOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public RabbitMQOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public RabbitMQOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public RabbitMQOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public RabbitMQOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public RabbitMQOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public RabbitMQOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }
}

