/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.ConfirmListener;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.rabbitmq.impl.RabbitMQClientImpl;
import io.vertx.rabbitmq.impl.RabbitMQConfirmListenerImpl;
import java.io.IOException;

public class ChannelConfirmHandler
implements ConfirmListener {
    private final RabbitMQConfirmListenerImpl listener;
    private final Context handlerContext;

    ChannelConfirmHandler(Vertx vertx, RabbitMQClientImpl client, int maxQueueSize) {
        this.handlerContext = vertx.getOrCreateContext();
        this.listener = new RabbitMQConfirmListenerImpl(client, this.handlerContext, maxQueueSize);
    }

    public void handleAck(long deliveryTag, boolean multiple) throws IOException {
        this.handlerContext.runOnContext(v -> this.listener.handleAck(deliveryTag, multiple, true));
    }

    public void handleNack(long deliveryTag, boolean multiple) throws IOException {
        this.handlerContext.runOnContext(v -> this.listener.handleAck(deliveryTag, multiple, false));
    }

    public RabbitMQConfirmListenerImpl getListener() {
        return this.listener;
    }
}

