/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.QueueOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class QueueOptions {
    private static final int DEFAULT_QUEUE_SIZE = Integer.MAX_VALUE;
    private static final boolean DEFAULT_AUTO_ACK = true;
    private static final boolean DEFAULT_KEEP_MOST_RECENT = false;
    private boolean autoAck = true;
    private boolean keepMostRecent = false;
    private int maxInternalQueueSize = Integer.MAX_VALUE;

    public QueueOptions() {
    }

    public QueueOptions(JsonObject json) {
        this();
        QueueOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public QueueOptions setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
        return this;
    }

    public QueueOptions setKeepMostRecent(boolean keepMostRecent) {
        this.keepMostRecent = keepMostRecent;
        return this;
    }

    public QueueOptions setMaxInternalQueueSize(int maxInternalQueueSize) {
        this.maxInternalQueueSize = maxInternalQueueSize;
        return this;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public int maxInternalQueueSize() {
        return this.maxInternalQueueSize;
    }

    public boolean isKeepMostRecent() {
        return this.keepMostRecent;
    }
}

