/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import com.rabbitmq.client.BasicProperties;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQPublisherConfirmation;
import io.vertx.rabbitmq.RabbitMQPublisherOptions;
import io.vertx.rabbitmq.impl.RabbitMQPublisherImpl;

@VertxGen
public interface RabbitMQPublisher {
    public static RabbitMQPublisher create(Vertx vertx, RabbitMQClient client, RabbitMQPublisherOptions options) {
        return new RabbitMQPublisherImpl(vertx, client, options);
    }

    public void start(Handler<AsyncResult<Void>> var1);

    public Future<Void> start();

    public void stop(Handler<AsyncResult<Void>> var1);

    public Future<Void> stop();

    public void restart();

    public ReadStream<RabbitMQPublisherConfirmation> getConfirmationStream();

    @GenIgnore(value={"permitted-type"})
    public void publish(String var1, String var2, BasicProperties var3, Buffer var4, Handler<AsyncResult<Void>> var5);

    @GenIgnore(value={"permitted-type"})
    public Future<Void> publish(String var1, String var2, BasicProperties var3, Buffer var4);

    @GenIgnore(value={"permitted-type"})
    public void publishConfirm(String var1, String var2, BasicProperties var3, Buffer var4, Handler<AsyncResult<Long>> var5);

    @GenIgnore(value={"permitted-type"})
    public Future<Long> publishConfirm(String var1, String var2, BasicProperties var3, Buffer var4);

    public int queueSize();
}

