/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.RabbitMQMessage;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rabbitmq.impl.RabbitMQClientImpl;
import java.util.Map;

@VertxGen
public interface RabbitMQClient {
    public static RabbitMQClient create(Vertx vertx) {
        return new RabbitMQClientImpl(vertx, new RabbitMQOptions());
    }

    public static RabbitMQClient create(Vertx vertx, RabbitMQOptions config) {
        return new RabbitMQClientImpl(vertx, config);
    }

    @GenIgnore
    public void addConnectionEstablishedCallback(Handler<Promise<Void>> var1);

    @GenIgnore
    public static RabbitMQClient create(Vertx vertx, JsonObject config) {
        return new RabbitMQClientImpl(vertx, new RabbitMQOptions(config));
    }

    public Future<Void> basicAck(long var1, boolean var3);

    public Future<Void> basicNack(long var1, boolean var3, boolean var4);

    public Future<RabbitMQMessage> basicGet(String var1, boolean var2);

    default public Future<RabbitMQConsumer> basicConsumer(String queue) {
        return this.basicConsumer(queue, new QueueOptions());
    }

    public Future<RabbitMQConsumer> basicConsumer(String var1, QueueOptions var2);

    public Future<Void> basicPublish(String var1, String var2, Buffer var3);

    @GenIgnore(value={"permitted-type"})
    public Future<Void> basicPublish(String var1, String var2, BasicProperties var3, Buffer var4);

    @GenIgnore(value={"permitted-type"})
    public Future<Void> basicPublishWithDeliveryTag(String var1, String var2, BasicProperties var3, Buffer var4, @Nullable Handler<Long> var5);

    public Future<ReadStream<RabbitMQConfirmation>> addConfirmListener(int var1);

    public Future<Void> confirmSelect();

    public Future<Void> waitForConfirms();

    public Future<Void> waitForConfirms(long var1);

    default public Future<Void> basicQos(int prefetchCount) {
        return this.basicQos(prefetchCount, false);
    }

    default public Future<Void> basicQos(int prefetchCount, boolean global) {
        return this.basicQos(0, prefetchCount, global);
    }

    public Future<Void> basicQos(int var1, int var2, boolean var3);

    public Future<Void> exchangeDeclare(String var1, String var2, boolean var3, boolean var4);

    public Future<Void> exchangeDeclare(String var1, String var2, boolean var3, boolean var4, JsonObject var5);

    public Future<Void> exchangeDelete(String var1);

    public Future<Void> exchangeBind(String var1, String var2, String var3);

    public Future<Void> exchangeBind(String var1, String var2, String var3, Map<String, Object> var4);

    public Future<Void> exchangeUnbind(String var1, String var2, String var3);

    public Future<Void> exchangeUnbind(String var1, String var2, String var3, Map<String, Object> var4);

    public Future<JsonObject> queueDeclareAuto();

    @GenIgnore(value={"permitted-type"})
    public Future<AMQP.Queue.DeclareOk> queueDeclare(String var1, boolean var2, boolean var3, boolean var4);

    @GenIgnore(value={"permitted-type"})
    public Future<AMQP.Queue.DeclareOk> queueDeclare(String var1, boolean var2, boolean var3, boolean var4, JsonObject var5);

    @GenIgnore(value={"permitted-type"})
    public Future<AMQP.Queue.DeleteOk> queueDelete(String var1);

    @GenIgnore(value={"permitted-type"})
    public Future<AMQP.Queue.DeleteOk> queueDeleteIf(String var1, boolean var2, boolean var3);

    public Future<Void> queueBind(String var1, String var2, String var3);

    public Future<Void> queueBind(String var1, String var2, String var3, Map<String, Object> var4);

    public Future<Void> queueUnbind(String var1, String var2, String var3);

    public Future<Void> queueUnbind(String var1, String var2, String var3, Map<String, Object> var4);

    public Future<Long> messageCount(String var1);

    public Future<Void> start();

    public Future<Void> stop();

    public boolean isConnected();

    public Future<Void> restartConnect(int var1);

    public boolean isOpenChannel();
}

