/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.Script;
import io.vertx.redis.impl.RedisClientImpl;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;

@VertxGen
public interface RedisClient {
    public static RedisClient create(Vertx vertx) {
        return new RedisClientImpl(vertx, new RedisOptions());
    }

    @Deprecated
    @GenIgnore
    public static RedisClient create(Vertx vertx, JsonObject config) {
        return new RedisClientImpl(vertx, new RedisOptions(config));
    }

    public static RedisClient create(Vertx vertx, RedisOptions config) {
        return new RedisClientImpl(vertx, config);
    }

    public void close(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient append(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient auth(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient bgsave(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient bitcount(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient bitcountRange(String var1, long var2, long var4, Handler<AsyncResult<Long>> var6);

    @Fluent
    public RedisClient bitop(BitOperation var1, String var2, List<String> var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient bitpos(String var1, int var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient bitposFrom(String var1, int var2, int var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient bitposRange(String var1, int var2, int var3, int var4, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient blpop(String var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient blpopMany(List<String> var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient brpop(String var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient brpopMany(List<String> var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient brpoplpush(String var1, String var2, int var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public RedisClient clientKill(KillFilter var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient clientList(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient clientGetname(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient clientPause(long var1, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient clientSetname(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient clusterAddslots(List<Long> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterCountFailureReports(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient clusterCountkeysinslot(long var1, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient clusterDelslots(long var1, Handler<AsyncResult<Void>> var3);

    @Fluent
    public RedisClient clusterDelslotsMany(List<Long> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterFailover(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient clusterFailOverWithOptions(FailoverOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterForget(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterGetkeysinslot(long var1, long var3, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient clusterKeyslot(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient clusterMeet(String var1, long var2, Handler<AsyncResult<Void>> var4);

    @Fluent
    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient clusterReplicate(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterReset(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient clusterResetWithOptions(ResetOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient clusterSetConfigEpoch(long var1, Handler<AsyncResult<Void>> var3);

    @Fluent
    public RedisClient clusterSetslot(long var1, SlotCmd var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public RedisClient clusterSetslotWithNode(long var1, SlotCmd var3, String var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public RedisClient clusterSlaves(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient command(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient commandCount(Handler<AsyncResult<Long>> var1);

    @Fluent
    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient commandInfo(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient configGet(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient configRewrite(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient configSet(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient configResetstat(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient dbsize(Handler<AsyncResult<Long>> var1);

    @Fluent
    public RedisClient debugObject(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient debugSegfault(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient decr(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient decrby(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient del(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient delMany(List<String> var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient dump(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient echo(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient eval(String var1, List<String> var2, List<String> var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient evalsha(String var1, List<String> var2, List<String> var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient evalScript(Script var1, List<String> var2, List<String> var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient exists(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient expire(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient expireat(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient flushall(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient flushdb(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient get(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient getBinary(String var1, Handler<AsyncResult<Buffer>> var2);

    @Fluent
    public RedisClient getbit(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient getrange(String var1, long var2, long var4, Handler<AsyncResult<String>> var6);

    @Fluent
    public RedisClient getset(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient hdel(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient hdelMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient hexists(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient hget(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient hgetall(String var1, Handler<AsyncResult<JsonObject>> var2);

    @Fluent
    public RedisClient hincrby(String var1, String var2, long var3, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient hincrbyfloat(String var1, String var2, double var3, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient hkeys(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient hlen(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient hmget(String var1, List<String> var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient hmset(String var1, JsonObject var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient hset(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient hsetnx(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient hvals(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient incr(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient incrby(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient incrbyfloat(String var1, double var2, Handler<AsyncResult<String>> var4);

    @Fluent
    public RedisClient info(Handler<AsyncResult<JsonObject>> var1);

    @Fluent
    public RedisClient infoSection(String var1, Handler<AsyncResult<JsonObject>> var2);

    @Fluent
    public RedisClient keys(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient lastsave(Handler<AsyncResult<Long>> var1);

    @Fluent
    public RedisClient lindex(String var1, int var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient linsert(String var1, InsertOptions var2, String var3, String var4, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient llen(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient lpop(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient lpushMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient lpush(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient lpushx(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient lrange(String var1, long var2, long var4, Handler<AsyncResult<JsonArray>> var6);

    @Fluent
    public RedisClient lrem(String var1, long var2, String var4, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient lset(String var1, long var2, String var4, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient ltrim(String var1, long var2, long var4, Handler<AsyncResult<String>> var6);

    @Fluent
    public RedisClient mget(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient mgetMany(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient migrate(String var1, int var2, String var3, int var4, long var5, MigrateOptions var7, Handler<AsyncResult<String>> var8);

    @Fluent
    public RedisClient monitor(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient move(String var1, int var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient mset(JsonObject var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient msetnx(JsonObject var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient object(String var1, ObjectCmd var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public RedisClient persist(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient pexpire(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient pexpireat(String var1, long var2, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient pfadd(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient pfaddMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient pfcount(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient pfcountMany(List<String> var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient pfmerge(String var1, List<String> var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient ping(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient psetex(String var1, long var2, String var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public RedisClient psubscribe(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient psubscribeMany(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient pubsubChannels(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient pubsubNumsub(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> var1);

    @Fluent
    public RedisClient pttl(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient publish(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient punsubscribe(List<String> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient randomkey(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient rename(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient renamenx(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient restore(String var1, long var2, String var4, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient role(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisClient rpop(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient rpoplpush(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient rpushMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient rpush(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient rpushx(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient sadd(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient saddMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient save(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient scard(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient scriptExists(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient scriptExistsMany(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient scriptFlush(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient scriptKill(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient scriptLoad(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient sdiff(String var1, List<String> var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient sdiffstore(String var1, String var2, List<String> var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient select(int var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient set(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public RedisClient setWithOptions(String var1, String var2, SetOptions var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public RedisClient setBinary(String var1, Buffer var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public RedisClient setBinaryWithOptions(String var1, Buffer var2, SetOptions var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public RedisClient setbit(String var1, long var2, int var4, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient setex(String var1, long var2, String var4, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient setnx(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient setrange(String var1, int var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient sinter(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient sinterstore(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient sismember(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient slaveof(String var1, int var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient slaveofNoone(Handler<AsyncResult<String>> var1);

    @Fluent
    public RedisClient slowlogGet(int var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient slowlogLen(Handler<AsyncResult<Long>> var1);

    @Fluent
    public RedisClient slowlogReset(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient smembers(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient smove(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient sort(String var1, SortOptions var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient spop(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient spopMany(String var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient srandmember(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient srandmemberCount(String var1, int var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient srem(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient sremMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient strlen(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient subscribe(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient subscribeMany(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient sunion(List<String> var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisClient sunionstore(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient sync(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisClient time(Handler<AsyncResult<JsonArray>> var1);

    public RedisTransaction transaction();

    @Fluent
    public RedisClient ttl(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient type(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient unsubscribe(List<String> var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisClient wait(long var1, long var3, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient zadd(String var1, double var2, String var4, Handler<AsyncResult<Long>> var5);

    @Fluent
    public RedisClient zaddMany(String var1, Map<String, Double> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient zcard(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient zcount(String var1, double var2, double var4, Handler<AsyncResult<Long>> var6);

    @Fluent
    public RedisClient zincrby(String var1, double var2, String var4, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient zinterstore(String var1, List<String> var2, AggregateOptions var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zinterstoreWeighed(String var1, Map<String, Double> var2, AggregateOptions var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zlexcount(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zrange(String var1, long var2, long var4, Handler<AsyncResult<JsonArray>> var6);

    @Fluent
    public RedisClient zrangeWithOptions(String var1, long var2, long var4, RangeOptions var6, Handler<AsyncResult<JsonArray>> var7);

    @Fluent
    public RedisClient zrangebylex(String var1, String var2, String var3, LimitOptions var4, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public RedisClient zrangebyscore(String var1, String var2, String var3, RangeLimitOptions var4, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public RedisClient zrank(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient zrem(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient zremMany(String var1, List<String> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient zremrangebylex(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zremrangebyrank(String var1, long var2, long var4, Handler<AsyncResult<Long>> var6);

    @Fluent
    public RedisClient zremrangebyscore(String var1, String var2, String var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zrevrange(String var1, long var2, long var4, RangeOptions var6, Handler<AsyncResult<JsonArray>> var7);

    @Fluent
    public RedisClient zrevrangebylex(String var1, String var2, String var3, LimitOptions var4, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public RedisClient zrevrangebyscore(String var1, String var2, String var3, RangeLimitOptions var4, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public RedisClient zrevrank(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient zscore(String var1, String var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public RedisClient zunionstore(String var1, List<String> var2, AggregateOptions var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient zunionstoreWeighed(String var1, Map<String, Double> var2, AggregateOptions var3, Handler<AsyncResult<Long>> var4);

    @Fluent
    public RedisClient scan(String var1, ScanOptions var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient sscan(String var1, String var2, ScanOptions var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient hscan(String var1, String var2, ScanOptions var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient zscan(String var1, String var2, ScanOptions var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public RedisClient geoadd(String var1, double var2, double var4, String var6, Handler<AsyncResult<Long>> var7);

    @Fluent
    public RedisClient geoaddMany(String var1, List<GeoMember> var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient geohash(String var1, String var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient geohashMany(String var1, List<String> var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient geopos(String var1, String var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient geoposMany(String var1, List<String> var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient geodist(String var1, String var2, String var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public RedisClient geodistWithUnit(String var1, String var2, String var3, GeoUnit var4, Handler<AsyncResult<String>> var5);

    @Fluent
    public RedisClient georadius(String var1, double var2, double var4, double var6, GeoUnit var8, Handler<AsyncResult<JsonArray>> var9);

    @Fluent
    public RedisClient georadiusWithOptions(String var1, double var2, double var4, double var6, GeoUnit var8, GeoRadiusOptions var9, Handler<AsyncResult<JsonArray>> var10);

    @Fluent
    public RedisClient georadiusbymember(String var1, String var2, double var3, GeoUnit var5, Handler<AsyncResult<JsonArray>> var6);

    @Fluent
    public RedisClient georadiusbymemberWithOptions(String var1, String var2, double var3, GeoUnit var5, GeoRadiusOptions var6, Handler<AsyncResult<JsonArray>> var7);

    @Fluent
    public RedisClient clientReply(ClientReplyOptions var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient hstrlen(String var1, String var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public RedisClient touch(String var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient touchMany(List<String> var1, Handler<AsyncResult<Long>> var2);

    @Fluent
    public RedisClient scriptDebug(ScriptDebugOptions var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisClient bitfield(String var1, BitFieldOptions var2, Handler<AsyncResult<JsonArray>> var3);

    @Fluent
    public RedisClient bitfieldWithOverflow(String var1, BitFieldOptions var2, BitFieldOverflowOptions var3, Handler<AsyncResult<JsonArray>> var4);
}

