/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.Script;
import io.vertx.redis.impl.AbstractRedisClient;
import io.vertx.redis.impl.RedisCommand;
import io.vertx.redis.impl.RedisEncoding;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class RedisClientImpl
extends AbstractRedisClient {
    private RedisTransaction transaction = new RedisTransactionImpl();

    public RedisClientImpl(Vertx vertx, RedisOptions config) {
        super(vertx, config);
    }

    private static List<?> toPayload(Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(el -> el != null).forEach(result::add);
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey());
                    result.add(pair.getValue());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        for (Object item : (Object[])e) {
                            result.add(item);
                        }
                    } else {
                        result.add(e);
                    }
                });
                continue;
            }
            if (param instanceof Buffer) {
                result.add(((Buffer)param).getBytes());
                continue;
            }
            if (param == null) continue;
            result.add(param);
        }
        return result;
    }

    @Override
    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.APPEND, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.AUTH, RedisClientImpl.toPayload(password), handler);
        return this;
    }

    @Override
    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.BGREWRITEAOF, null, handler);
        return this;
    }

    @Override
    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.BGSAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITCOUNT, RedisClientImpl.toPayload(key, start, end), handler);
        return this;
    }

    @Override
    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITOP, RedisClientImpl.toPayload(operation.name(), destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITPOS, RedisClientImpl.toPayload(key, bit), handler);
        return this;
    }

    @Override
    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITPOS, RedisClientImpl.toPayload(key, bit, start), handler);
        return this;
    }

    @Override
    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.BITPOS, RedisClientImpl.toPayload(key, bit, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BLPOP, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BLPOP, RedisClientImpl.toPayload(keys, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BRPOP, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BRPOP, RedisClientImpl.toPayload(keys, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.BRPOPLPUSH, RedisClientImpl.toPayload(key, destkey, seconds), handler);
        return this;
    }

    @Override
    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.CLIENT_KILL, filter.toJsonArray().getList(), handler);
        return this;
    }

    @Override
    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CLIENT_LIST, null, handler);
        return this;
    }

    @Override
    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CLIENT_GETNAME, null, handler);
        return this;
    }

    @Override
    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CLIENT_PAUSE, RedisClientImpl.toPayload(millis), handler);
        return this;
    }

    @Override
    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CLIENT_SETNAME, RedisClientImpl.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_ADDSLOTS, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.CLUSTER_COUNT_FAILURE_REPORTS, RedisClientImpl.toPayload(nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.CLUSTER_COUNTKEYSINSLOT, RedisClientImpl.toPayload(slot), handler);
        return this;
    }

    @Override
    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_DELSLOTS, RedisClientImpl.toPayload(slot), handler);
        return this;
    }

    @Override
    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_DELSLOTS, RedisClientImpl.toPayload(slots), handler);
        return this;
    }

    @Override
    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_FAILOVER, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_FAILOVER, RedisClientImpl.toPayload(new Object[]{options}), handler);
        return this;
    }

    @Override
    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_FORGET, RedisClientImpl.toPayload(nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CLUSTER_GETKEYSINSLOT, RedisClientImpl.toPayload(slot, count), handler);
        return this;
    }

    @Override
    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CLUSTER_INFO, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.CLUSTER_KEYSLOT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_MEET, RedisClientImpl.toPayload(ip, port), handler);
        return this;
    }

    @Override
    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CLUSTER_NODES, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_REPLICATE, RedisClientImpl.toPayload(nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_RESET, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_RESET, RedisClientImpl.toPayload(new Object[]{options}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_SAVECONFIG, null, handler);
        return this;
    }

    @Override
    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_SET_CONFIG_EPOCH, RedisClientImpl.toPayload(epoch), handler);
        return this;
    }

    @Override
    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_SETSLOT, RedisClientImpl.toPayload(new Object[]{slot, subcommand}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.CLUSTER_SETSLOT, RedisClientImpl.toPayload(new Object[]{slot, subcommand, nodeId}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CLUSTER_SLAVES, RedisClientImpl.toPayload(nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CLUSTER_SLOTS, null, handler);
        return this;
    }

    @Override
    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.COMMAND, null, handler);
        return this;
    }

    @Override
    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.COMMAND_COUNT, null, handler);
        return this;
    }

    @Override
    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.COMMAND_GETKEYS, null, handler);
        return this;
    }

    @Override
    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.COMMAND_INFO, RedisClientImpl.toPayload(commands), handler);
        return this;
    }

    @Override
    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.CONFIG_GET, RedisClientImpl.toPayload(parameter), handler);
        return this;
    }

    @Override
    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CONFIG_REWRITE, null, handler);
        return this;
    }

    @Override
    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CONFIG_SET, RedisClientImpl.toPayload(parameter, value), handler);
        return this;
    }

    @Override
    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CONFIG_RESETSTAT, null, handler);
        return this;
    }

    @Override
    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.DBSIZE, null, handler);
        return this;
    }

    @Override
    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.DEBUG_OBJECT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.DEBUG_SEGFAULT, null, handler);
        return this;
    }

    @Override
    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.DECR, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.DECRBY, RedisClientImpl.toPayload(key, decrement), handler);
        return this;
    }

    @Override
    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.DEL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.DEL, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.send(RedisCommand.DUMP, RedisClientImpl.toPayload(key), String.class, true, dump -> {
            if (dump.failed()) {
                handler.handle(dump);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)dump.result())));
            }
        });
        return this;
    }

    @Override
    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.ECHO, RedisClientImpl.toPayload(message), handler);
        return this;
    }

    @Override
    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(RedisCommand.EVAL, RedisClientImpl.toPayload(script, keys.size(), keys, args), handler);
        return this;
    }

    @Override
    public RedisClient evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(RedisCommand.EVALSHA, RedisClientImpl.toPayload(sha1, keys.size(), keys, args), handler);
        return this;
    }

    @Override
    public RedisClient evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.evalsha(script.getSha1(), keys, args, (Handler<AsyncResult<JsonArray>>)((Handler)res -> {
            if (res.failed() && res.cause().getMessage().startsWith("NOSCRIPT")) {
                this.eval(script.getScript(), keys, args, handler);
            } else {
                handler.handle(res);
            }
        }));
        return this;
    }

    @Override
    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.EXISTS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.EXPIRE, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.EXPIREAT, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.FLUSHALL, null, handler);
        return this;
    }

    @Override
    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.FLUSHDB, null, handler);
        return this;
    }

    @Override
    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.GET, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient getBinary(String key, Handler<AsyncResult<Buffer>> handler) {
        this.send(RedisCommand.GET, RedisClientImpl.toPayload(key), Buffer.class, true, handler);
        return this;
    }

    @Override
    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.GETBIT, RedisClientImpl.toPayload(key, offset), handler);
        return this;
    }

    @Override
    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.GETRANGE, RedisClientImpl.toPayload(key, start, end), handler);
        return this;
    }

    @Override
    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.GETSET, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HDEL, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HDEL, RedisClientImpl.toPayload(key, fields), handler);
        return this;
    }

    @Override
    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HEXISTS, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.HGET, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.sendJsonObject(RedisCommand.HGETALL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HINCRBY, RedisClientImpl.toPayload(key, field, increment), handler);
        return this;
    }

    @Override
    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.HINCRBYFLOAT, RedisClientImpl.toPayload(key, field, increment), handler);
        return this;
    }

    @Override
    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.HKEYS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.HMGET, RedisClientImpl.toPayload(key, fields), handler);
        return this;
    }

    @Override
    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.HMSET, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HSET, RedisClientImpl.toPayload(key, field, value), handler);
        return this;
    }

    @Override
    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HSETNX, RedisClientImpl.toPayload(key, field, value), handler);
        return this;
    }

    @Override
    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.HVALS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.INCR, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.INCRBY, RedisClientImpl.toPayload(key, increment), handler);
        return this;
    }

    @Override
    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.INCRBYFLOAT, RedisClientImpl.toPayload(key, increment), handler);
        return this;
    }

    @Override
    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.sendJsonObject(RedisCommand.INFO, Collections.emptyList(), handler);
        return this;
    }

    @Override
    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.sendJsonObject(RedisCommand.INFO, RedisClientImpl.toPayload(section), handler);
        return this;
    }

    @Override
    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.KEYS, RedisClientImpl.toPayload(pattern), handler);
        return this;
    }

    @Override
    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LASTSAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.LINDEX, RedisClientImpl.toPayload(key, index), handler);
        return this;
    }

    @Override
    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LINSERT, RedisClientImpl.toPayload(key, option.name(), pivot, value), handler);
        return this;
    }

    @Override
    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.LPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LPUSH, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LPUSH, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LPUSHX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.LRANGE, RedisClientImpl.toPayload(key, from, to), handler);
        return this;
    }

    @Override
    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.LREM, RedisClientImpl.toPayload(key, count, value), handler);
        return this;
    }

    @Override
    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.LSET, RedisClientImpl.toPayload(key, index, value), handler);
        return this;
    }

    @Override
    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.LTRIM, RedisClientImpl.toPayload(key, from, to), handler);
        return this;
    }

    @Override
    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.MGET, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.MGET, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.MIGRATE, RedisClientImpl.toPayload(host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.MONITOR, null, handler);
        return this;
    }

    @Override
    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.MOVE, RedisClientImpl.toPayload(key, destdb), handler);
        return this;
    }

    @Override
    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.MSET, RedisClientImpl.toPayload(keyvals), handler);
        return this;
    }

    @Override
    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.MSETNX, RedisClientImpl.toPayload(keyvals), handler);
        return this;
    }

    @Override
    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.OBJECT, RedisClientImpl.toPayload(cmd.name(), key), handler);
        return this;
    }

    @Override
    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PERSIST, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PEXPIRE, RedisClientImpl.toPayload(key, millis), handler);
        return this;
    }

    @Override
    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PEXPIREAT, RedisClientImpl.toPayload(key, millis), handler);
        return this;
    }

    @Override
    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PFADD, RedisClientImpl.toPayload(key, element), handler);
        return this;
    }

    @Override
    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PFADD, RedisClientImpl.toPayload(key, elements), handler);
        return this;
    }

    @Override
    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PFCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pfcountMany(List<String> key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PFCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.PFMERGE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.PING, null, handler);
        return this;
    }

    @Override
    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.PSETEX, RedisClientImpl.toPayload(key, millis, value), handler);
        return this;
    }

    @Override
    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.PSUBSCRIBE, RedisClientImpl.toPayload(pattern), handler);
        return this;
    }

    @Override
    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.PSUBSCRIBE, RedisClientImpl.toPayload(patterns), handler);
        return this;
    }

    @Override
    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.PUBSUB, RedisClientImpl.toPayload("CHANNELS", pattern == null || "".equals(pattern) ? null : pattern), handler);
        return this;
    }

    @Override
    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.PUBSUB, RedisClientImpl.toPayload("NUMSUB", channels), handler);
        return this;
    }

    @Override
    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PUBSUB, RedisClientImpl.toPayload("NUMPAT"), handler);
        return this;
    }

    @Override
    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PTTL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.PUBLISH, RedisClientImpl.toPayload(channel, message), handler);
        return this;
    }

    @Override
    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.PUNSUBSCRIBE, RedisClientImpl.toPayload(patterns), handler);
        return this;
    }

    @Override
    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.RANDOMKEY, null, handler);
        return this;
    }

    @Override
    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.RENAME, RedisClientImpl.toPayload(key, newkey), handler);
        return this;
    }

    @Override
    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.RENAMENX, RedisClientImpl.toPayload(key, newkey), handler);
        return this;
    }

    @Override
    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.send(RedisCommand.RESTORE, RedisClientImpl.toPayload(key, millis, RedisEncoding.decode(serialized)), String.class, true, handler);
        return this;
    }

    @Override
    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ROLE, null, handler);
        return this;
    }

    @Override
    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.RPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.RPOPLPUSH, RedisClientImpl.toPayload(key, destkey), handler);
        return this;
    }

    @Override
    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.RPUSH, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.RPUSH, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.RPUSHX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SADD, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SADD, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SCARD, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SCRIPT_EXISTS, RedisClientImpl.toPayload(script), handler);
        return this;
    }

    @Override
    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SCRIPT_EXISTS, RedisClientImpl.toPayload(scripts), handler);
        return this;
    }

    @Override
    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SCRIPT_FLUSH, null, handler);
        return this;
    }

    @Override
    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SCRIPT_KILL, null, handler);
        return this;
    }

    @Override
    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SCRIPT_LOAD, RedisClientImpl.toPayload(script), handler);
        return this;
    }

    @Override
    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SDIFF, RedisClientImpl.toPayload(key, cmpkeys), handler);
        return this;
    }

    @Override
    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SDIFFSTORE, RedisClientImpl.toPayload(destkey, key, cmpkeys), handler);
        return this;
    }

    @Override
    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SELECT, RedisClientImpl.toPayload(dbindex), handler);
        return this;
    }

    @Override
    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.SET, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SET, RedisClientImpl.toPayload(key, value, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient setBinary(String key, Buffer value, Handler<AsyncResult<Void>> handler) {
        this.send(RedisCommand.SET, RedisClientImpl.toPayload(key, value), Void.class, true, handler);
        return this;
    }

    @Override
    public RedisClient setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.send(RedisCommand.SET, RedisClientImpl.toPayload(key, value, options != null ? options.toJsonArray() : null), Void.class, true, handler);
        return this;
    }

    @Override
    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SETBIT, RedisClientImpl.toPayload(key, offset, bit), handler);
        return this;
    }

    @Override
    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SETEX, RedisClientImpl.toPayload(key, seconds, value), handler);
        return this;
    }

    @Override
    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SETNX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SETRANGE, RedisClientImpl.toPayload(key, offset, value), handler);
        return this;
    }

    @Override
    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SINTER, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SINTERSTORE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SISMEMBER, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SLAVEOF, RedisClientImpl.toPayload(host, port), handler);
        return this;
    }

    @Override
    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SLAVEOF, RedisClientImpl.toPayload("NO", "ONE"), handler);
        return this;
    }

    @Override
    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SLOWLOG, RedisClientImpl.toPayload("GET", limit < 0 ? null : Integer.valueOf(limit)), handler);
        return this;
    }

    @Override
    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SLOWLOG, RedisClientImpl.toPayload("LEN"), handler);
        return this;
    }

    @Override
    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.SLOWLOG, RedisClientImpl.toPayload("RESET"), handler);
        return this;
    }

    @Override
    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SMEMBERS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SMOVE, RedisClientImpl.toPayload(key, destkey, member), handler);
        return this;
    }

    @Override
    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SORT, RedisClientImpl.toPayload(key, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SPOP, RedisClientImpl.toPayload(key, count), handler);
        return this;
    }

    @Override
    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SRANDMEMBER, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SRANDMEMBER, RedisClientImpl.toPayload(key, count), handler);
        return this;
    }

    @Override
    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SREM, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SREM, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.STRLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SUBSCRIBE, RedisClientImpl.toPayload(channel), handler);
        return this;
    }

    @Override
    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SUBSCRIBE, RedisClientImpl.toPayload(channels), handler);
        return this;
    }

    @Override
    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SUNION, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.SUNIONSTORE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.SYNC, null, handler);
        return this;
    }

    @Override
    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.TIME, null, handler);
        return this;
    }

    @Override
    public RedisTransaction transaction() {
        return this.transaction;
    }

    @Override
    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.TTL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.TYPE, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisCommand.UNSUBSCRIBE, RedisClientImpl.toPayload(channels), handler);
        return this;
    }

    @Override
    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.WAIT, RedisClientImpl.toPayload(numSlaves, timeout), handler);
        return this;
    }

    @Override
    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZADD, RedisClientImpl.toPayload(key, score, member), handler);
        return this;
    }

    /*
     * Exception decompiling
     */
    @Override
    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZCARD, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
        String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
        this.sendLong(RedisCommand.ZCOUNT, RedisClientImpl.toPayload(key, minVal, maxVal), handler);
        return this;
    }

    @Override
    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.ZINCRBY, RedisClientImpl.toPayload(key, increment, member), handler);
        return this;
    }

    @Override
    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZINTERSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    @Override
    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZINTERSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZLEXCOUNT, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZRANGE, RedisClientImpl.toPayload(key, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZRANGE, RedisClientImpl.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZRANGEBYLEX, RedisClientImpl.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZRANGEBYSCORE, RedisClientImpl.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZRANK, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREM, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREM, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREMRANGEBYLEX, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREMRANGEBYRANK, RedisClientImpl.toPayload(key, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREMRANGEBYSCORE, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZREVRANGE, RedisClientImpl.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZREVRANGEBYLEX, RedisClientImpl.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZREVRANGEBYSCORE, RedisClientImpl.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZREVRANK, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.ZSCORE, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZUNIONSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    @Override
    public RedisClient zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.ZUNIONSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SCAN, RedisClientImpl.toPayload(cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.SSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.HSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.ZSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.GEOADD, RedisClientImpl.toPayload(key, longitude, latitude, member), handler);
        return this;
    }

    @Override
    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.GEOADD, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEOHASH, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEOHASH, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEOPOS, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEOPOS, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.GEODIST, RedisClientImpl.toPayload(key, member1, member2), handler);
        return this;
    }

    @Override
    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit, options != null ? options.toJsonArray() : null}), handler);
        return this;
    }

    @Override
    public RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.CLIENT_REPLY, RedisClientImpl.toPayload(new Object[]{options}), handler);
        return this;
    }

    @Override
    public RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.HSTRLEN, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient touch(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.TOUCH, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(RedisCommand.TOUCH, keys, handler);
        return this;
    }

    @Override
    public RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisCommand.SCRIPT_DEBUG, RedisClientImpl.toPayload(new Object[]{scriptDebugOptions}), handler);
        return this;
    }

    @Override
    public RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BITFIELD, RedisClientImpl.toPayload(key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient bitfieldWithOverflow(String key, BitFieldOptions bitFieldOptions, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisCommand.BITFIELD, RedisClientImpl.toPayload(new Object[]{key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null, overflow}), handler);
        return this;
    }

    public class RedisTransactionImpl
    implements RedisTransaction {
        @Override
        public void close(Handler<AsyncResult<Void>> handler) {
            RedisClientImpl.this.close((Handler)handler);
        }

        @Override
        public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.APPEND, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.AUTH, RedisClientImpl.toPayload(new Object[]{password}), handler);
            return this;
        }

        @Override
        public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BGREWRITEAOF, null, handler);
            return this;
        }

        @Override
        public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BGSAVE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITCOUNT, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITCOUNT, RedisClientImpl.toPayload(new Object[]{key, start, end}), handler);
            return this;
        }

        @Override
        public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITOP, RedisClientImpl.toPayload(new Object[]{operation.name(), destkey, keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit}), handler);
            return this;
        }

        @Override
        public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit, start}), handler);
            return this;
        }

        @Override
        public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit, start, stop}), handler);
            return this;
        }

        @Override
        public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BLPOP, RedisClientImpl.toPayload(new Object[]{key, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BLPOP, RedisClientImpl.toPayload(new Object[]{keys, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BRPOP, RedisClientImpl.toPayload(new Object[]{key, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BRPOP, RedisClientImpl.toPayload(new Object[]{keys, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.BRPOPLPUSH, RedisClientImpl.toPayload(new Object[]{key, destkey, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLIENT_KILL, filter.toJsonArray().getList(), handler);
            return this;
        }

        @Override
        public RedisTransaction clientList(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLIENT_LIST, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLIENT_GETNAME, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLIENT_PAUSE, RedisClientImpl.toPayload(new Object[]{millis}), handler);
            return this;
        }

        @Override
        public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLIENT_SETNAME, RedisClientImpl.toPayload(new Object[]{name}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_ADDSLOTS, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_COUNT_FAILURE_REPORTS, RedisClientImpl.toPayload(new Object[]{nodeId}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_COUNTKEYSINSLOT, RedisClientImpl.toPayload(new Object[]{slot}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_DELSLOTS, RedisClientImpl.toPayload(new Object[]{slot}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_DELSLOTS, RedisClientImpl.toPayload(new Object[]{slots}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_FAILOVER, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_FAILOVER, RedisClientImpl.toPayload(new Object[]{options}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_FORGET, RedisClientImpl.toPayload(new Object[]{nodeId}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_GETKEYSINSLOT, RedisClientImpl.toPayload(new Object[]{slot, count}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_INFO, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_KEYSLOT, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_MEET, RedisClientImpl.toPayload(new Object[]{ip, port}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_NODES, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_REPLICATE, RedisClientImpl.toPayload(new Object[]{nodeId}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_RESET, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_RESET, RedisClientImpl.toPayload(new Object[]{options}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SAVECONFIG, null, handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SET_CONFIG_EPOCH, RedisClientImpl.toPayload(new Object[]{epoch}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SETSLOT, RedisClientImpl.toPayload(new Object[]{slot, subcommand}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SETSLOT, RedisClientImpl.toPayload(new Object[]{slot, subcommand, nodeId}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SLAVES, RedisClientImpl.toPayload(new Object[]{nodeId}), handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CLUSTER_SLOTS, null, handler);
            return this;
        }

        @Override
        public RedisTransaction command(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.COMMAND, null, handler);
            return this;
        }

        @Override
        public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.COMMAND_COUNT, null, handler);
            return this;
        }

        @Override
        public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.COMMAND_GETKEYS, null, handler);
            return this;
        }

        @Override
        public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.COMMAND_INFO, RedisClientImpl.toPayload(new Object[]{commands}), handler);
            return this;
        }

        @Override
        public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CONFIG_GET, RedisClientImpl.toPayload(new Object[]{parameter}), handler);
            return this;
        }

        @Override
        public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CONFIG_REWRITE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CONFIG_SET, RedisClientImpl.toPayload(new Object[]{parameter, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.CONFIG_RESETSTAT, null, handler);
            return this;
        }

        @Override
        public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DBSIZE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DEBUG_OBJECT, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DEBUG_SEGFAULT, null, handler);
            return this;
        }

        @Override
        public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DECR, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DECRBY, RedisClientImpl.toPayload(new Object[]{key, decrement}), handler);
            return this;
        }

        @Override
        public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DEL, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DEL, RedisClientImpl.toPayload(new Object[]{keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction discard(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.DISCARD, null, handler);
            return this;
        }

        @Override
        public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.send(RedisCommand.DUMP, RedisClientImpl.toPayload(new Object[]{key}), String.class, true, dump -> {
                if (dump.failed()) {
                    handler.handle(dump);
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)dump.result())));
                }
            });
            return this;
        }

        @Override
        public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ECHO, RedisClientImpl.toPayload(new Object[]{message}), handler);
            return this;
        }

        @Override
        public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientImpl.this.sendString(RedisCommand.EVAL, RedisClientImpl.toPayload(new Object[]{script, keys.size(), keys, args}), handler);
            return this;
        }

        @Override
        public RedisTransaction evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientImpl.this.sendString(RedisCommand.EVALSHA, RedisClientImpl.toPayload(new Object[]{sha1, keys.size(), keys, args}), handler);
            return this;
        }

        @Override
        public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) {
            RedisClientImpl.this.sendJsonArray(RedisCommand.EXEC, null, handler);
            return this;
        }

        @Override
        public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.EXISTS, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.EXPIRE, RedisClientImpl.toPayload(new Object[]{key, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.EXPIREAT, RedisClientImpl.toPayload(new Object[]{key, seconds}), handler);
            return this;
        }

        @Override
        public RedisTransaction flushall(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.FLUSHALL, null, handler);
            return this;
        }

        @Override
        public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.FLUSHDB, null, handler);
            return this;
        }

        @Override
        public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GET, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction getBinary(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.send(RedisCommand.GET, RedisClientImpl.toPayload(new Object[]{key}), String.class, true, handler);
            return this;
        }

        @Override
        public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GETBIT, RedisClientImpl.toPayload(new Object[]{key, offset}), handler);
            return this;
        }

        @Override
        public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GETRANGE, RedisClientImpl.toPayload(new Object[]{key, start, end}), handler);
            return this;
        }

        @Override
        public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GETSET, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HDEL, RedisClientImpl.toPayload(new Object[]{key, field}), handler);
            return this;
        }

        @Override
        public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HDEL, RedisClientImpl.toPayload(new Object[]{key, fields}), handler);
            return this;
        }

        @Override
        public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HEXISTS, RedisClientImpl.toPayload(new Object[]{key, field}), handler);
            return this;
        }

        @Override
        public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HGET, RedisClientImpl.toPayload(new Object[]{key, field}), handler);
            return this;
        }

        @Override
        public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HGETALL, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HINCRBY, RedisClientImpl.toPayload(new Object[]{key, field, increment}), handler);
            return this;
        }

        @Override
        public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HINCRBYFLOAT, RedisClientImpl.toPayload(new Object[]{key, field, increment}), handler);
            return this;
        }

        @Override
        public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HKEYS, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HLEN, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HMGET, RedisClientImpl.toPayload(new Object[]{key, fields}), handler);
            return this;
        }

        @Override
        public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HMSET, RedisClientImpl.toPayload(new Object[]{key, values}), handler);
            return this;
        }

        @Override
        public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HSET, RedisClientImpl.toPayload(new Object[]{key, field, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HSETNX, RedisClientImpl.toPayload(new Object[]{key, field, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HVALS, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.INCR, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.INCRBY, RedisClientImpl.toPayload(new Object[]{key, increment}), handler);
            return this;
        }

        @Override
        public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.INCRBYFLOAT, RedisClientImpl.toPayload(new Object[]{key, increment}), handler);
            return this;
        }

        @Override
        public RedisTransaction info(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.INFO, Collections.emptyList(), handler);
            return this;
        }

        @Override
        public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.INFO, RedisClientImpl.toPayload(new Object[]{section}), handler);
            return this;
        }

        @Override
        public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.KEYS, RedisClientImpl.toPayload(new Object[]{pattern}), handler);
            return this;
        }

        @Override
        public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LASTSAVE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LINDEX, RedisClientImpl.toPayload(new Object[]{key, index}), handler);
            return this;
        }

        @Override
        public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LINSERT, RedisClientImpl.toPayload(new Object[]{key, option.name(), pivot, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LLEN, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LPOP, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LPUSH, RedisClientImpl.toPayload(new Object[]{key, values}), handler);
            return this;
        }

        @Override
        public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LPUSH, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LPUSHX, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LRANGE, RedisClientImpl.toPayload(new Object[]{key, from, to}), handler);
            return this;
        }

        @Override
        public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LREM, RedisClientImpl.toPayload(new Object[]{key, count, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LSET, RedisClientImpl.toPayload(new Object[]{key, index, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.LTRIM, RedisClientImpl.toPayload(new Object[]{key, from, to}), handler);
            return this;
        }

        @Override
        public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MGET, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MGET, RedisClientImpl.toPayload(new Object[]{keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MIGRATE, RedisClientImpl.toPayload(new Object[]{host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction monitor(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MONITOR, null, handler);
            return this;
        }

        @Override
        public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MOVE, RedisClientImpl.toPayload(new Object[]{key, destdb}), handler);
            return this;
        }

        @Override
        public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MSET, RedisClientImpl.toPayload(new Object[]{keyvals}), handler);
            return this;
        }

        @Override
        public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MSETNX, RedisClientImpl.toPayload(new Object[]{keyvals}), handler);
            return this;
        }

        @Override
        public RedisTransaction multi(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.MULTI, null, handler);
            return this;
        }

        @Override
        public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.OBJECT, RedisClientImpl.toPayload(new Object[]{cmd.name(), key}), handler);
            return this;
        }

        @Override
        public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PERSIST, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PEXPIRE, RedisClientImpl.toPayload(new Object[]{key, millis}), handler);
            return this;
        }

        @Override
        public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PEXPIREAT, RedisClientImpl.toPayload(new Object[]{key, millis}), handler);
            return this;
        }

        @Override
        public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PFADD, RedisClientImpl.toPayload(new Object[]{key, element}), handler);
            return this;
        }

        @Override
        public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PFADD, RedisClientImpl.toPayload(new Object[]{key, elements}), handler);
            return this;
        }

        @Override
        public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PFCOUNT, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction pfcountMany(List<String> key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PFCOUNT, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PFMERGE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction ping(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PING, null, handler);
            return this;
        }

        @Override
        public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PSETEX, RedisClientImpl.toPayload(new Object[]{key, millis, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{pattern}), handler);
            return this;
        }

        @Override
        public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{patterns}), handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PUBSUB, RedisClientImpl.toPayload(new Object[]{"CHANNELS", pattern == null || "".equals(pattern) ? null : pattern}), handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PUBSUB, RedisClientImpl.toPayload(new Object[]{"NUMSUB", channels}), handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PUBSUB, RedisClientImpl.toPayload(new Object[]{"NUMPAT"}), handler);
            return this;
        }

        @Override
        public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PTTL, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PUBLISH, RedisClientImpl.toPayload(new Object[]{channel, message}), handler);
            return this;
        }

        @Override
        public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.PUNSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{patterns}), handler);
            return this;
        }

        @Override
        public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RANDOMKEY, null, handler);
            return this;
        }

        @Override
        public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RENAME, RedisClientImpl.toPayload(new Object[]{key, newkey}), handler);
            return this;
        }

        @Override
        public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RENAMENX, RedisClientImpl.toPayload(new Object[]{key, newkey}), handler);
            return this;
        }

        @Override
        public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.send(RedisCommand.RESTORE, RedisClientImpl.toPayload(new Object[]{key, millis, RedisEncoding.decode(serialized)}), String.class, true, handler);
            return this;
        }

        @Override
        public RedisTransaction role(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ROLE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RPOP, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RPOPLPUSH, RedisClientImpl.toPayload(new Object[]{key, destkey}), handler);
            return this;
        }

        @Override
        public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RPUSH, RedisClientImpl.toPayload(new Object[]{key, values}), handler);
            return this;
        }

        @Override
        public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RPUSH, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.RPUSHX, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SADD, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SADD, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction save(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SAVE, null, handler);
            return this;
        }

        @Override
        public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCARD, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCRIPT_EXISTS, RedisClientImpl.toPayload(new Object[]{script}), handler);
            return this;
        }

        @Override
        public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCRIPT_EXISTS, RedisClientImpl.toPayload(new Object[]{scripts}), handler);
            return this;
        }

        @Override
        public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCRIPT_FLUSH, null, handler);
            return this;
        }

        @Override
        public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCRIPT_KILL, null, handler);
            return this;
        }

        @Override
        public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCRIPT_LOAD, RedisClientImpl.toPayload(new Object[]{script}), handler);
            return this;
        }

        @Override
        public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SDIFF, RedisClientImpl.toPayload(new Object[]{key, cmpkeys}), handler);
            return this;
        }

        @Override
        public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SDIFFSTORE, RedisClientImpl.toPayload(new Object[]{destkey, key, cmpkeys}), handler);
            return this;
        }

        @Override
        public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SELECT, RedisClientImpl.toPayload(new Object[]{dbindex}), handler);
            return this;
        }

        @Override
        public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SET, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SET, RedisClientImpl.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.send(RedisCommand.SET, RedisClientImpl.toPayload(new Object[]{key, value}), String.class, true, handler);
            return this;
        }

        @Override
        public RedisTransaction setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.send(RedisCommand.SET, RedisClientImpl.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), String.class, true, handler);
            return this;
        }

        @Override
        public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SETBIT, RedisClientImpl.toPayload(new Object[]{key, offset, bit}), handler);
            return this;
        }

        @Override
        public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SETEX, RedisClientImpl.toPayload(new Object[]{key, seconds, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SETNX, RedisClientImpl.toPayload(new Object[]{key, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SETRANGE, RedisClientImpl.toPayload(new Object[]{key, offset, value}), handler);
            return this;
        }

        @Override
        public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SINTER, RedisClientImpl.toPayload(new Object[]{keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SISMEMBER, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SLAVEOF, RedisClientImpl.toPayload(new Object[]{host, port}), handler);
            return this;
        }

        @Override
        public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SLAVEOF, RedisClientImpl.toPayload(new Object[]{"NO", "ONE"}), handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"GET", limit < 0 ? null : Integer.valueOf(limit)}), handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"LEN"}), handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"RESET"}), handler);
            return this;
        }

        @Override
        public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
            RedisClientImpl.this.sendJsonArray(RedisCommand.SMEMBERS, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SMOVE, RedisClientImpl.toPayload(new Object[]{key, destkey, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SORT, RedisClientImpl.toPayload(new Object[]{key, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SPOP, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SPOP, RedisClientImpl.toPayload(new Object[]{key, count}), handler);
            return this;
        }

        @Override
        public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SRANDMEMBER, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SRANDMEMBER, RedisClientImpl.toPayload(new Object[]{key, count}), handler);
            return this;
        }

        @Override
        public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SREM, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SREM, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.STRLEN, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channel}), handler);
            return this;
        }

        @Override
        public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channels}), handler);
            return this;
        }

        @Override
        public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SUNION, RedisClientImpl.toPayload(new Object[]{keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction sync(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SYNC, null, handler);
            return this;
        }

        @Override
        public RedisTransaction time(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.TIME, null, handler);
            return this;
        }

        @Override
        public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.TTL, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.TYPE, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.UNSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channels}), handler);
            return this;
        }

        @Override
        public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.UNWATCH, null, handler);
            return this;
        }

        @Override
        public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.WAIT, RedisClientImpl.toPayload(new Object[]{numSlaves, timeout}), handler);
            return this;
        }

        @Override
        public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.WATCH, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.WATCH, RedisClientImpl.toPayload(new Object[]{keys}), handler);
            return this;
        }

        @Override
        public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZADD, RedisClientImpl.toPayload(new Object[]{key, score, member}), handler);
            return this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public RedisTransaction zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZCARD, RedisClientImpl.toPayload(new Object[]{key}), handler);
            return this;
        }

        @Override
        public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
            String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
            String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
            RedisClientImpl.this.sendString(RedisCommand.ZCOUNT, RedisClientImpl.toPayload(new Object[]{key, minVal, maxVal}), handler);
            return this;
        }

        @Override
        public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZINCRBY, RedisClientImpl.toPayload(new Object[]{key, increment, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZLEXCOUNT, RedisClientImpl.toPayload(new Object[]{key, min, max}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZRANK, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREM, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREM, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREMRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, min, max}), handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREMRANGEBYRANK, RedisClientImpl.toPayload(new Object[]{key, start, stop}), handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREMRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, min, max}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREVRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREVRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREVRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZREVRANK, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZSCORE, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SCAN, RedisClientImpl.toPayload(new Object[]{cursor, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.SSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.HSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.ZSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOADD, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOADD, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOHASH, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOHASH, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOPOS, RedisClientImpl.toPayload(new Object[]{key, member}), handler);
            return this;
        }

        @Override
        public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEOPOS, RedisClientImpl.toPayload(new Object[]{key, members}), handler);
            return this;
        }

        @Override
        public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2}), handler);
            return this;
        }

        @Override
        public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2, unit}), handler);
            return this;
        }

        @Override
        public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit}), handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit}), handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(RedisCommand.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit, options != null ? options.toJsonArray() : null}), handler);
            return this;
        }
    }
}

