/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.utils;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class RedisCommandUtils {
    public static List<?> toPayload(Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(el -> el != null).forEach(result::add);
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey());
                    result.add(pair.getValue());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        for (Object item : (Object[])e) {
                            result.add(item);
                        }
                    } else {
                        result.add(e);
                    }
                });
                continue;
            }
            if (param instanceof Buffer) {
                result.add(((Buffer)param).getBytes());
                continue;
            }
            if (param == null) continue;
            result.add(param);
        }
        return result;
    }
}

