/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.redis.RedisTransaction;
import io.vertx.rxjava.redis.Script;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.RedisClient.class)
public class RedisClient {
    public static final TypeArg<RedisClient> __TYPE_ARG = new TypeArg(obj -> new RedisClient((io.vertx.redis.RedisClient)obj), RedisClient::getDelegate);
    private final io.vertx.redis.RedisClient delegate;

    public RedisClient(io.vertx.redis.RedisClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.redis.RedisClient getDelegate() {
        return this.delegate;
    }

    public static RedisClient create(Vertx vertx) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create(vertx.getDelegate()));
        return ret;
    }

    public static RedisClient create(Vertx vertx, RedisOptions config) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create(vertx.getDelegate(), config));
        return ret;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.close((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> appendObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.append(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxAppend(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.append(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    @Deprecated
    public Observable<String> authObservable(String password) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.auth(password, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxAuth(String password) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.auth(password, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    @Deprecated
    public Observable<String> bgrewriteaofObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgrewriteaof((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBgrewriteaof() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bgrewriteaof((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    @Deprecated
    public Observable<String> bgsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgsave((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBgsave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bgsave((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcount(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitcount(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitcount(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitcountRangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcountRange(key, start, end, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitcountRange(String key, long start, long end) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitcountRange(key, start, end, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitopObservable(BitOperation operation, String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitop(operation, destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitop(BitOperation operation, String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitop(operation, destkey, keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitposObservable(String key, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitpos(key, bit, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitpos(String key, int bit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitpos(key, bit, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitposFromObservable(String key, int bit, int start) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposFrom(key, bit, start, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitposFrom(String key, int bit, int start) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitposFrom(key, bit, start, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> bitposRangeObservable(String key, int bit, int start, int stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxBitposRange(String key, int bit, int start, int stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> blpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBlpop(String key, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blpop(key, seconds, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> blpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBlpopMany(List<String> keys, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> brpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBrpop(String key, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpop(key, seconds, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> brpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBrpopMany(List<String> keys, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> brpoplpushObservable(String key, String destkey, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBrpoplpush(String key, String destkey, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> clientKillObservable(KillFilter filter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientKill(filter, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxClientKill(KillFilter filter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientKill(filter, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientListObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientList((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientList() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientList((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientGetnameObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientGetname((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientGetname() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientGetname((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientPauseObservable(long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientPause(millis, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientPause(long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientPause(millis, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientSetnameObservable(String name) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientSetname(name, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientSetname(String name) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientSetname(name, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterAddslotsObservable(List<Long> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterAddslots(slots, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterAddslots(List<Long> slots) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterAddslots(slots, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> clusterCountFailureReportsObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxClusterCountFailureReports(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> clusterCountkeysinslotObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountkeysinslot(slot, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxClusterCountkeysinslot(long slot) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterCountkeysinslot(slot, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterDelslotsObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslots(slot, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterDelslots(long slot) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterDelslots(slot, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterDelslotsManyObservable(List<Long> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslotsMany(slots, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterDelslotsMany(List<Long> slots) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterDelslotsMany(slots, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterFailoverObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailover((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterFailover() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterFailover((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterFailOverWithOptionsObservable(FailoverOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailOverWithOptions(options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterFailOverWithOptions(FailoverOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterFailOverWithOptions(options, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterForgetObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterForget(nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterForget(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterForget(nodeId, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> clusterGetkeysinslotObservable(long slot, long count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxClusterGetkeysinslot(long slot, long count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> clusterInfoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterInfo((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxClusterInfo() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterInfo((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> clusterKeyslotObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterKeyslot(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxClusterKeyslot(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterKeyslot(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterMeetObservable(String ip, long port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterMeet(ip, port, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterMeet(String ip, long port) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterMeet(ip, port, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> clusterNodesObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterNodes((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxClusterNodes() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterNodes((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterReplicateObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReplicate(nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterReplicate(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterReplicate(nodeId, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReset((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterReset() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterReset((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterResetWithOptionsObservable(ResetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterResetWithOptions(options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterResetWithOptions(ResetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterResetWithOptions(options, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterSaveconfigObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSaveconfig((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterSaveconfig() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSaveconfig((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterSetConfigEpochObservable(long epoch) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterSetConfigEpoch(long epoch) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterSetslotObservable(long slot, SlotCmd subcommand) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterSetslot(long slot, SlotCmd subcommand) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> clusterSetslotWithNodeObservable(long slot, SlotCmd subcommand, String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> clusterSlavesObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlaves(nodeId, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxClusterSlaves(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSlaves(nodeId, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> clusterSlotsObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlots((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxClusterSlots() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSlots((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.command(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> commandObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.command((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxCommand() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.command((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    @Deprecated
    public Observable<Long> commandCountObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandCount((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxCommandCount() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandCount((Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> commandGetkeysObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandGetkeys((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxCommandGetkeys() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandGetkeys((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> commandInfoObservable(List<String> commands) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandInfo(commands, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxCommandInfo(List<String> commands) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandInfo(commands, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> configGetObservable(String parameter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configGet(parameter, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxConfigGet(String parameter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configGet(parameter, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    @Deprecated
    public Observable<String> configRewriteObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configRewrite((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigRewrite() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configRewrite((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> configSetObservable(String parameter, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configSet(parameter, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigSet(String parameter, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configSet(parameter, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    @Deprecated
    public Observable<String> configResetstatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configResetstat((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigResetstat() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configResetstat((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    @Deprecated
    public Observable<Long> dbsizeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dbsize((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxDbsize() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dbsize((Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> debugObjectObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugObject(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDebugObject(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.debugObject(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    @Deprecated
    public Observable<String> debugSegfaultObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugSegfault((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDebugSegfault() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.debugSegfault((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> decrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decr(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxDecr(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.decr(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> decrbyObservable(String key, long decrement) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decrby(key, decrement, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxDecrby(String key, long decrement) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.decrby(key, decrement, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> delObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.del(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxDel(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.del(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> delManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.delMany(keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxDelMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delMany(keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> dumpObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dump(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDump(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dump(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    @Deprecated
    public Observable<String> echoObservable(String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.echo(message, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxEcho(String message) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.echo(message, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> evalObservable(String script, List<String> keys, List<String> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.eval(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxEval(String script, List<String> keys, List<String> args) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.eval(script, keys, args, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> evalshaObservable(String sha1, List<String> keys, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.evalsha(sha1, keys, values, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxEvalsha(String sha1, List<String> keys, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.evalsha(sha1, keys, values, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalScript(script.getDelegate(), keys, args, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> evalScriptObservable(Script script, List<String> keys, List<String> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.evalScript(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxEvalScript(Script script, List<String> keys, List<String> args) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.evalScript(script, keys, args, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> existsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.exists(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxExists(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exists(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> expireObservable(String key, long seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expire(key, seconds, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxExpire(String key, long seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.expire(key, seconds, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> expireatObservable(String key, long seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expireat(key, seconds, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxExpireat(String key, long seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.expireat(key, seconds, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    @Deprecated
    public Observable<String> flushallObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushall((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxFlushall() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.flushall((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    @Deprecated
    public Observable<String> flushdbObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushdb((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxFlushdb() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.flushdb((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.get(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGet(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.get(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient getBinary(String key, final Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>> handler) {
        this.delegate.getBinary(key, new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance((Buffer)((Buffer)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<io.vertx.rxjava.core.buffer.Buffer> getBinaryObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getBinary(key, (Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>>)handler.toHandler());
        return handler;
    }

    public Single<io.vertx.rxjava.core.buffer.Buffer> rxGetBinary(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getBinary(key, (Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>>)fut)));
    }

    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> getbitObservable(String key, long offset) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getbit(key, offset, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxGetbit(String key, long offset) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getbit(key, offset, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getrangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getrange(key, start, end, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetrange(String key, long start, long end) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getrange(key, start, end, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getsetObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getset(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetset(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getset(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hdelObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdel(key, field, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHdel(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hdel(key, field, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hdelManyObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdelMany(key, fields, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHdelMany(String key, List<String> fields) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hdelMany(key, fields, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hexistsObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hexists(key, field, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHexists(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hexists(key, field, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hgetObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hget(key, field, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHget(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hget(key, field, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> hgetallObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hgetall(key, (Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public Single<JsonObject> rxHgetall(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hgetall(key, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hincrbyObservable(String key, String field, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrby(key, field, increment, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHincrby(String key, String field, long increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hincrby(key, field, increment, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hincrbyfloatObservable(String key, String field, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHincrbyfloat(String key, String field, double increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> hkeysObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hkeys(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxHkeys(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hkeys(key, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hlen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hlen(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> hmgetObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmget(key, fields, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxHmget(String key, List<String> fields) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hmget(key, fields, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hmsetObservable(String key, JsonObject values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmset(key, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHmset(String key, JsonObject values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hmset(key, values, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hsetObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hset(key, field, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHset(String key, String field, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hset(key, field, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hsetnxObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hsetnx(key, field, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHsetnx(String key, String field, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hsetnx(key, field, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> hvalsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hvals(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxHvals(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hvals(key, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> incrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incr(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxIncr(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incr(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> incrbyObservable(String key, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrby(key, increment, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxIncrby(String key, long increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incrby(key, increment, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> incrbyfloatObservable(String key, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxIncrbyfloat(String key, double increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.info(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> infoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.info((Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public Single<JsonObject> rxInfo() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.info((Handler<AsyncResult<JsonObject>>)fut)));
    }

    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> infoSectionObservable(String section) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.infoSection(section, (Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public Single<JsonObject> rxInfoSection(String section) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.infoSection(section, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> keysObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.keys(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxKeys(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.keys(pattern, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    @Deprecated
    public Observable<Long> lastsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lastsave((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLastsave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lastsave((Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lindexObservable(String key, int index) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lindex(key, index, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLindex(String key, int index) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lindex(key, index, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> linsertObservable(String key, InsertOptions option, String pivot, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.linsert(key, option, pivot, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLinsert(String key, InsertOptions option, String pivot, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.linsert(key, option, pivot, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> llenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.llen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.llen(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> lpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushMany(key, values, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLpushMany(String key, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpushMany(key, values, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> lpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpush(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLpush(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpush(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> lpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLpushx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpushx(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> lrangeObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrange(key, from, to, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxLrange(String key, long from, long to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lrange(key, from, to, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> lremObservable(String key, long count, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrem(key, count, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxLrem(String key, long count, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lrem(key, count, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lsetObservable(String key, long index, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lset(key, index, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLset(String key, long index, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lset(key, index, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    @Deprecated
    public Observable<String> ltrimObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ltrim(key, from, to, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLtrim(String key, long from, long to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ltrim(key, from, to, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> mgetObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mget(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxMget(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mget(key, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> mgetManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mgetMany(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxMgetMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mgetMany(keys, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> migrateObservable(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> monitorObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.monitor((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxMonitor() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.monitor((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> moveObservable(String key, int destdb) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.move(key, destdb, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxMove(String key, int destdb) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.move(key, destdb, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    @Deprecated
    public Observable<String> msetObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mset(keyvals, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMset(JsonObject keyvals) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mset(keyvals, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> msetnxObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.msetnx(keyvals, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxMsetnx(JsonObject keyvals) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.msetnx(keyvals, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> objectObservable(String key, ObjectCmd cmd) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.object(key, cmd, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxObject(String key, ObjectCmd cmd) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.object(key, cmd, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> persistObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.persist(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPersist(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.persist(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pexpireObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpire(key, millis, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPexpire(String key, long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pexpire(key, millis, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pexpireatObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpireat(key, millis, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPexpireat(String key, long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pexpireat(key, millis, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pfaddObservable(String key, String element) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfadd(key, element, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPfadd(String key, String element) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfadd(key, element, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pfaddManyObservable(String key, List<String> elements) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfaddMany(key, elements, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPfaddMany(String key, List<String> elements) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfaddMany(key, elements, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pfcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcount(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPfcount(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfcount(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pfcountMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pfcountManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcountMany(keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPfcountMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfcountMany(keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfmergeObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfmerge(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    @Deprecated
    public Observable<String> pingObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ping((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPing() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ping((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> psetexObservable(String key, long millis, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psetex(key, millis, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPsetex(String key, long millis, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psetex(key, millis, value, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> psubscribeObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribe(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxPsubscribe(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psubscribe(pattern, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> psubscribeManyObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribeMany(patterns, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxPsubscribeMany(List<String> patterns) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psubscribeMany(patterns, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> pubsubChannelsObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubChannels(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxPubsubChannels(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubChannels(pattern, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> pubsubNumsubObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumsub(channels, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxPubsubNumsub(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubNumsub(channels, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pubsubNumpatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumpat((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPubsubNumpat() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubNumpat((Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> pttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pttl(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPttl(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pttl(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> publishObservable(String channel, String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.publish(channel, message, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxPublish(String channel, String message) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.publish(channel, message, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> punsubscribeObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.punsubscribe(patterns, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPunsubscribe(List<String> patterns) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.punsubscribe(patterns, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    @Deprecated
    public Observable<String> randomkeyObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.randomkey((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRandomkey() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.randomkey((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    @Deprecated
    public Observable<String> renameObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rename(key, newkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRename(String key, String newkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rename(key, newkey, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> renamenxObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.renamenx(key, newkey, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxRenamenx(String key, String newkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.renamenx(key, newkey, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    @Deprecated
    public Observable<String> restoreObservable(String key, long millis, String serialized) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRestore(String key, long millis, String serialized) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.role(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> roleObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.role((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxRole() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.role((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpoplpushObservable(String key, String destkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpoplpush(String key, String destkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> rpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushMany(key, values, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxRpushMany(String key, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpushMany(key, values, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> rpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpush(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxRpush(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpush(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> rpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxRpushx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpushx(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> saddObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sadd(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSadd(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sadd(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> saddManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.saddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSaddMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.saddMany(key, members, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    @Deprecated
    public Observable<String> saveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.save((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.save((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> scardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scard(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxScard(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scard(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> scriptExistsObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExists(script, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxScriptExists(String script) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptExists(script, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> scriptExistsManyObservable(List<String> scripts) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExistsMany(scripts, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxScriptExistsMany(List<String> scripts) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptExistsMany(scripts, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptFlushObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptFlush((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptFlush() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptFlush((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptKillObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptKill((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptKill() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptKill((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptLoadObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptLoad(script, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptLoad(String script) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptLoad(script, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> sdiffObservable(String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiff(key, cmpkeys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSdiff(String key, List<String> cmpkeys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sdiff(key, cmpkeys, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sdiffstoreObservable(String destkey, String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSdiffstore(String destkey, String key, List<String> cmpkeys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    @Deprecated
    public Observable<String> selectObservable(int dbindex) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.select(dbindex, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSelect(int dbindex) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.select(dbindex, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> setObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.set(key, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSet(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.set(key, value, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setWithOptionsObservable(String key, String value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetWithOptions(String key, String value, SetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient setBinary(String key, io.vertx.rxjava.core.buffer.Buffer value, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    @Deprecated
    public Observable<Void> setBinaryObservable(String key, io.vertx.rxjava.core.buffer.Buffer value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinary(key, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSetBinary(String key, io.vertx.rxjava.core.buffer.Buffer value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setBinary(key, value, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient setBinaryWithOptions(String key, io.vertx.rxjava.core.buffer.Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> setBinaryWithOptionsObservable(String key, io.vertx.rxjava.core.buffer.Buffer value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSetBinaryWithOptions(String key, io.vertx.rxjava.core.buffer.Buffer value, SetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> setbitObservable(String key, long offset, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setbit(key, offset, bit, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSetbit(String key, long offset, int bit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setbit(key, offset, bit, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setexObservable(String key, long seconds, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setex(key, seconds, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetex(String key, long seconds, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setex(key, seconds, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> setnxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setnx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSetnx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setnx(key, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> setrangeObservable(String key, int offset, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setrange(key, offset, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSetrange(String key, int offset, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setrange(key, offset, value, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> sinterObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinter(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSinter(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sinter(keys, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sinterstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinterstore(destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSinterstore(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sinterstore(destkey, keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sismemberObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sismember(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSismember(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sismember(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    @Deprecated
    public Observable<String> slaveofObservable(String host, int port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveof(host, port, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlaveof(String host, int port) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slaveof(host, port, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    @Deprecated
    public Observable<String> slaveofNooneObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveofNoone((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlaveofNoone() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slaveofNoone((Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> slowlogGetObservable(int limit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogGet(limit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSlowlogGet(int limit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogGet(limit, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    @Deprecated
    public Observable<Long> slowlogLenObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogLen((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSlowlogLen() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogLen((Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> slowlogResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogReset((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSlowlogReset() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogReset((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> smembersObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smembers(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSmembers(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.smembers(key, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> smoveObservable(String key, String destkey, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smove(key, destkey, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSmove(String key, String destkey, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.smove(key, destkey, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> sortObservable(String key, SortOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sort(key, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSort(String key, SortOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sort(key, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> spopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.spop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> spopManyObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spopMany(key, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSpopMany(String key, int count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.spopMany(key, count, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> srandmemberObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmember(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSrandmember(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srandmember(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> srandmemberCountObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmemberCount(key, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSrandmemberCount(String key, int count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srandmemberCount(key, count, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srem(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSrem(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srem(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sremMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSremMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sremMany(key, members, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> strlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.strlen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxStrlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.strlen(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> subscribeObservable(String channel) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribe(channel, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSubscribe(String channel) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribe(channel, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> subscribeManyObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribeMany(channels, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSubscribeMany(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribeMany(channels, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> sunionObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunion(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSunion(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sunion(keys, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> sunionstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunionstore(destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxSunionstore(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sunionstore(destkey, keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> syncObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sync((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxSync() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sync((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.time(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> timeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.time((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxTime() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.time((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisTransaction transaction() {
        RedisTransaction ret = RedisTransaction.newInstance(this.delegate.transaction());
        return ret;
    }

    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> ttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ttl(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxTtl(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ttl(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> typeObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.type(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxType(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.type(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> unsubscribeObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.unsubscribe(channels, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxUnsubscribe(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unsubscribe(channels, (Handler<AsyncResult<Void>>)fut)));
    }

    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    @Deprecated
    public Observable<String> waitObservable(long numSlaves, long timeout) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxWait(long numSlaves, long timeout) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zaddObservable(String key, double score, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zadd(key, score, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZadd(String key, double score, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zadd(key, score, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zaddManyObservable(String key, Map<String, Double> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zaddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZaddMany(String key, Map<String, Double> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zaddMany(key, members, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zcardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcard(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZcard(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zcard(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zcountObservable(String key, double min, double max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcount(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZcount(String key, double min, double max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zcount(key, min, max, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zincrbyObservable(String key, double increment, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZincrby(String key, double increment, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zinterstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zinterstore(destkey, sets, options, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zinterstoreWeighedObservable(String destkey, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zlexcountObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zlexcount(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZlexcount(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zlexcount(key, min, max, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrangeObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrange(key, start, stop, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrange(String key, long start, long stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrange(key, start, stop, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrangeWithOptionsObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrangebylexObservable(String key, String min, String max, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebylex(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrangebylex(String key, String min, String max, LimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangebylex(key, min, max, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrangebyscoreObservable(String key, String min, String max, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrank(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZrank(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrank(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrem(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZrem(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrem(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZremMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremMany(key, members, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zremrangebylexObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebylex(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZremrangebylex(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebylex(key, min, max, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zremrangebyrankObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZremrangebyrank(String key, long start, long stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zremrangebyscoreObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyscore(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZremrangebyscore(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebyscore(key, min, max, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrevrangeObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrange(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrevrange(String key, long start, long stop, RangeOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrange(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrevrangebylexObservable(String key, String max, String min, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrevrangebylex(String key, String max, String min, LimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zrevrangebyscoreObservable(String key, String max, String min, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zrevrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrank(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZrevrank(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrank(key, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zscoreObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscore(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZscore(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zscore(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zunionstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zunionstore(destkey, sets, options, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> zunionstoreWeighedObservable(String key, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxZunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> scanObservable(String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scan(cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxScan(String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scan(cursor, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> sscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> hscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxHscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> zscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxZscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> geoaddObservable(String key, double longitude, double latitude, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxGeoadd(String key, double longitude, double latitude, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> geoaddManyObservable(String key, List<GeoMember> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoaddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxGeoaddMany(String key, List<GeoMember> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoaddMany(key, members, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> geohashObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohash(key, member, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeohash(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geohash(key, member, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> geohashManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohashMany(key, members, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeohashMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geohashMany(key, members, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> geoposObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geopos(key, member, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeopos(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geopos(key, member, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> geoposManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoposMany(key, members, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeoposMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoposMany(key, members, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geodistObservable(String key, String member1, String member2) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeodist(String key, String member1, String member2) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geodistWithUnitObservable(String key, String member1, String member2, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> georadiusObservable(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> georadiusWithOptionsObservable(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> georadiusbymemberObservable(String key, String member, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> georadiusbymemberWithOptionsObservable(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clientReply(options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientReplyObservable(ClientReplyOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientReply(options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientReply(ClientReplyOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientReply(options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hstrlen(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> hstrlenObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hstrlen(key, field, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxHstrlen(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hstrlen(key, field, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient touch(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.touch(key, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> touchObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.touch(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxTouch(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.touch(key, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.touchMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<Long> touchManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.touchMany(keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public Single<Long> rxTouchMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.touchMany(keys, (Handler<AsyncResult<Long>>)fut)));
    }

    public RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptDebug(scriptDebugOptions, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptDebugObservable(ScriptDebugOptions scriptDebugOptions) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptDebug(scriptDebugOptions, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptDebug(ScriptDebugOptions scriptDebugOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptDebug(scriptDebugOptions, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfield(key, bitFieldOptions, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> bitfieldObservable(String key, BitFieldOptions bitFieldOptions) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitfield(key, bitFieldOptions, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBitfield(String key, BitFieldOptions bitFieldOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitfield(key, bitFieldOptions, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisClient bitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.bitfieldWithOverflow(key, commands, overflow, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> bitfieldWithOverflowObservable(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitfieldWithOverflow(key, commands, overflow, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxBitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitfieldWithOverflow(key, commands, overflow, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public static RedisClient newInstance(io.vertx.redis.RedisClient arg) {
        return arg != null ? new RedisClient(arg) : null;
    }
}

