/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.RedisTransaction.class)
public class RedisTransaction {
    public static final TypeArg<RedisTransaction> __TYPE_ARG = new TypeArg(obj -> new RedisTransaction((io.vertx.redis.RedisTransaction)obj), RedisTransaction::getDelegate);
    private final io.vertx.redis.RedisTransaction delegate;

    public RedisTransaction(io.vertx.redis.RedisTransaction delegate) {
        this.delegate = delegate;
    }

    public io.vertx.redis.RedisTransaction getDelegate() {
        return this.delegate;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.close((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> appendObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.append(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxAppend(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.append(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    @Deprecated
    public Observable<String> authObservable(String password) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.auth(password, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxAuth(String password) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.auth(password, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    @Deprecated
    public Observable<String> bgrewriteaofObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgrewriteaof((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBgrewriteaof() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bgrewriteaof((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    @Deprecated
    public Observable<String> bgsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgsave((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBgsave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bgsave((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcount(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitcount(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitcount(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitcountRangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcountRange(key, start, end, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitcountRange(String key, long start, long end) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitcountRange(key, start, end, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitopObservable(BitOperation operation, String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitop(operation, destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitop(BitOperation operation, String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitop(operation, destkey, keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitposObservable(String key, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitpos(key, bit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitpos(String key, int bit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitpos(key, bit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitposFromObservable(String key, int bit, int start) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposFrom(key, bit, start, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitposFrom(String key, int bit, int start) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitposFrom(key, bit, start, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<String> bitposRangeObservable(String key, int bit, int start, int stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBitposRange(String key, int bit, int start, int stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> blpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpop(key, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBlpop(String key, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blpop(key, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> blpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBlpopMany(List<String> keys, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blpopMany(keys, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> brpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpop(key, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBrpop(String key, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpop(key, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> brpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBrpopMany(List<String> keys, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpopMany(keys, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> brpoplpushObservable(String key, String destkey, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxBrpoplpush(String key, String destkey, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientKillObservable(KillFilter filter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientKill(filter, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientKill(KillFilter filter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientKill(filter, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientListObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientList((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientList() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientList((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientGetnameObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientGetname((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientGetname() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientGetname((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientPauseObservable(long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientPause(millis, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientPause(long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientPause(millis, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clientSetnameObservable(String name) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientSetname(name, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClientSetname(String name) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clientSetname(name, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterAddslotsObservable(List<String> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterAddslots(slots, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterAddslots(List<String> slots) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterAddslots(slots, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterCountFailureReportsObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterCountFailureReports(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterCountkeysinslotObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountkeysinslot(slot, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterCountkeysinslot(long slot) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterCountkeysinslot(slot, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterDelslotsObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslots(slot, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterDelslots(long slot) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterDelslots(slot, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterDelslotsManyObservable(List<String> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslotsMany(slots, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterDelslotsMany(List<String> slots) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterDelslotsMany(slots, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterFailoverObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailover((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterFailover() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterFailover((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterFailOverWithOptionsObservable(FailoverOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailOverWithOptions(options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterFailOverWithOptions(FailoverOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterFailOverWithOptions(options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterForgetObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterForget(nodeId, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterForget(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterForget(nodeId, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterGetkeysinslotObservable(long slot, long count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterGetkeysinslot(long slot, long count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterInfoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterInfo((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterInfo() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterInfo((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterKeyslotObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterKeyslot(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterKeyslot(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterKeyslot(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterMeetObservable(String ip, long port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterMeet(ip, port, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterMeet(String ip, long port) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterMeet(ip, port, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterNodesObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterNodes((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterNodes() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterNodes((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterReplicateObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReplicate(nodeId, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterReplicate(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterReplicate(nodeId, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReset((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterReset() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterReset((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterResetWithOptionsObservable(ResetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterResetWithOptions(options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterResetWithOptions(ResetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterResetWithOptions(options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSaveconfigObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSaveconfig((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSaveconfig() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSaveconfig((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSetConfigEpochObservable(long epoch) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSetConfigEpoch(long epoch) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSetslotObservable(long slot, SlotCmd subcommand) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSetslot(long slot, SlotCmd subcommand) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSetslotWithNodeObservable(long slot, SlotCmd subcommand, String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSlavesObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlaves(nodeId, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSlaves(String nodeId) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSlaves(nodeId, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    @Deprecated
    public Observable<String> clusterSlotsObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlots((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxClusterSlots() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clusterSlots((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction command(Handler<AsyncResult<String>> handler) {
        this.delegate.command(handler);
        return this;
    }

    @Deprecated
    public Observable<String> commandObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.command((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxCommand() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.command((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    @Deprecated
    public Observable<String> commandCountObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandCount((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxCommandCount() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandCount((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    @Deprecated
    public Observable<String> commandGetkeysObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandGetkeys((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxCommandGetkeys() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandGetkeys((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    @Deprecated
    public Observable<String> commandInfoObservable(List<String> commands) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandInfo(commands, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxCommandInfo(List<String> commands) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.commandInfo(commands, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    @Deprecated
    public Observable<String> configGetObservable(String parameter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configGet(parameter, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigGet(String parameter) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configGet(parameter, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    @Deprecated
    public Observable<String> configRewriteObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configRewrite((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigRewrite() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configRewrite((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> configSetObservable(String parameter, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configSet(parameter, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigSet(String parameter, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configSet(parameter, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    @Deprecated
    public Observable<String> configResetstatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configResetstat((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxConfigResetstat() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.configResetstat((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    @Deprecated
    public Observable<String> dbsizeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dbsize((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDbsize() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dbsize((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> debugObjectObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugObject(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDebugObject(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.debugObject(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    @Deprecated
    public Observable<String> debugSegfaultObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugSegfault((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDebugSegfault() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.debugSegfault((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> decrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decr(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDecr(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.decr(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    @Deprecated
    public Observable<String> decrbyObservable(String key, long decrement) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decrby(key, decrement, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDecrby(String key, long decrement) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.decrby(key, decrement, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> delObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.del(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDel(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.del(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> delManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.delMany(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDelMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delMany(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction discard(Handler<AsyncResult<String>> handler) {
        this.delegate.discard(handler);
        return this;
    }

    @Deprecated
    public Observable<String> discardObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.discard((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDiscard() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.discard((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> dumpObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dump(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxDump(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.dump(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    @Deprecated
    public Observable<String> echoObservable(String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.echo(message, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxEcho(String message) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.echo(message, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    @Deprecated
    public Observable<String> evalObservable(String script, List<String> keys, List<String> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.eval(script, keys, args, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxEval(String script, List<String> keys, List<String> args) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.eval(script, keys, args, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    @Deprecated
    public Observable<String> evalshaObservable(String sha1, List<String> keys, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.evalsha(sha1, keys, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxEvalsha(String sha1, List<String> keys, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.evalsha(sha1, keys, values, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.exec(handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> execObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.exec((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxExec() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exec((Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> existsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.exists(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxExists(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exists(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> expireObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expire(key, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxExpire(String key, int seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.expire(key, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    @Deprecated
    public Observable<String> expireatObservable(String key, long seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expireat(key, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxExpireat(String key, long seconds) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.expireat(key, seconds, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    @Deprecated
    public Observable<String> flushallObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushall((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxFlushall() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.flushall((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    @Deprecated
    public Observable<String> flushdbObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushdb((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxFlushdb() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.flushdb((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.get(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGet(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.get(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction getBinary(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.getBinary(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getBinaryObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getBinary(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetBinary(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getBinary(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getbitObservable(String key, long offset) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getbit(key, offset, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetbit(String key, long offset) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getbit(key, offset, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getrangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getrange(key, start, end, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetrange(String key, long start, long end) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getrange(key, start, end, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> getsetObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getset(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGetset(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getset(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hdelObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdel(key, field, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHdel(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hdel(key, field, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hdelManyObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdelMany(key, fields, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHdelMany(String key, List<String> fields) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hdelMany(key, fields, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hexistsObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hexists(key, field, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHexists(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hexists(key, field, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hgetObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hget(key, field, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHget(String key, String field) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hget(key, field, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hgetallObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hgetall(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHgetall(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hgetall(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hincrbyObservable(String key, String field, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrby(key, field, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHincrby(String key, String field, long increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hincrby(key, field, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hincrbyfloatObservable(String key, String field, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHincrbyfloat(String key, String field, double increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hkeysObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hkeys(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHkeys(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hkeys(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hlen(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hlen(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hmgetObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmget(key, fields, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHmget(String key, List<String> fields) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hmget(key, fields, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hmsetObservable(String key, JsonObject values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmset(key, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHmset(String key, JsonObject values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hmset(key, values, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hsetObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hset(key, field, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHset(String key, String field, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hset(key, field, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hsetnxObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hsetnx(key, field, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHsetnx(String key, String field, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hsetnx(key, field, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hvalsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hvals(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHvals(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hvals(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> incrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incr(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxIncr(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incr(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> incrbyObservable(String key, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrby(key, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxIncrby(String key, long increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incrby(key, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    @Deprecated
    public Observable<String> incrbyfloatObservable(String key, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxIncrbyfloat(String key, double increment) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction info(Handler<AsyncResult<String>> handler) {
        this.delegate.info(handler);
        return this;
    }

    @Deprecated
    public Observable<String> infoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.info((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxInfo() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.info((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    @Deprecated
    public Observable<String> infoSectionObservable(String section) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.infoSection(section, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxInfoSection(String section) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.infoSection(section, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<String> keysObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.keys(pattern, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxKeys(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.keys(pattern, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    @Deprecated
    public Observable<String> lastsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lastsave((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLastsave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lastsave((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lindexObservable(String key, int index) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lindex(key, index, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLindex(String key, int index) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lindex(key, index, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> linsertObservable(String key, InsertOptions option, String pivot, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.linsert(key, option, pivot, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLinsert(String key, InsertOptions option, String pivot, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.linsert(key, option, pivot, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> llenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.llen(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.llen(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushMany(key, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLpushMany(String key, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpushMany(key, values, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpush(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLpush(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpush(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushx(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLpushx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lpushx(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lrangeObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrange(key, from, to, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLrange(String key, long from, long to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lrange(key, from, to, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lremObservable(String key, long count, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrem(key, count, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLrem(String key, long count, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lrem(key, count, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lsetObservable(String key, long index, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lset(key, index, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLset(String key, long index, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.lset(key, index, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    @Deprecated
    public Observable<String> ltrimObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ltrim(key, from, to, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxLtrim(String key, long from, long to) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ltrim(key, from, to, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> mgetObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mget(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMget(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mget(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> mgetManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mgetMany(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMgetMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mgetMany(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> migrateObservable(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction monitor(Handler<AsyncResult<String>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    @Deprecated
    public Observable<String> monitorObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.monitor((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMonitor() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.monitor((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    @Deprecated
    public Observable<String> moveObservable(String key, int destdb) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.move(key, destdb, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMove(String key, int destdb) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.move(key, destdb, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    @Deprecated
    public Observable<String> msetObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mset(keyvals, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMset(JsonObject keyvals) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.mset(keyvals, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    @Deprecated
    public Observable<String> msetnxObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.msetnx(keyvals, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMsetnx(JsonObject keyvals) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.msetnx(keyvals, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction multi(Handler<AsyncResult<String>> handler) {
        this.delegate.multi(handler);
        return this;
    }

    @Deprecated
    public Observable<String> multiObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.multi((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxMulti() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.multi((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    @Deprecated
    public Observable<String> objectObservable(String key, ObjectCmd cmd) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.object(key, cmd, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxObject(String key, ObjectCmd cmd) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.object(key, cmd, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> persistObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.persist(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPersist(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.persist(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pexpireObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpire(key, millis, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPexpire(String key, long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pexpire(key, millis, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pexpireatObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpireat(key, millis, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPexpireat(String key, long millis) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pexpireat(key, millis, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfaddObservable(String key, String element) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfadd(key, element, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfadd(String key, String element) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfadd(key, element, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfaddManyObservable(String key, List<String> elements) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfaddMany(key, elements, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfaddMany(String key, List<String> elements) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfaddMany(key, elements, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcount(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfcount(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfcount(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pfcountMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfcountManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcountMany(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfcountMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfcountMany(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pfmergeObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPfmerge(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    @Deprecated
    public Observable<String> pingObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ping((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPing() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ping((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> psetexObservable(String key, long millis, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psetex(key, millis, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPsetex(String key, long millis, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psetex(key, millis, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<String> psubscribeObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribe(pattern, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPsubscribe(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psubscribe(pattern, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    @Deprecated
    public Observable<String> psubscribeManyObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribeMany(patterns, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPsubscribeMany(List<String> patterns) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.psubscribeMany(patterns, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pubsubChannelsObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubChannels(pattern, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPubsubChannels(String pattern) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubChannels(pattern, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pubsubNumsubObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumsub(channels, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPubsubNumsub(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubNumsub(channels, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    @Deprecated
    public Observable<String> pubsubNumpatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumpat((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPubsubNumpat() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pubsubNumpat((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> pttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pttl(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPttl(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pttl(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    @Deprecated
    public Observable<String> publishObservable(String channel, String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.publish(channel, message, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPublish(String channel, String message) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.publish(channel, message, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    @Deprecated
    public Observable<String> punsubscribeObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.punsubscribe(patterns, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxPunsubscribe(List<String> patterns) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.punsubscribe(patterns, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    @Deprecated
    public Observable<String> randomkeyObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.randomkey((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRandomkey() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.randomkey((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    @Deprecated
    public Observable<String> renameObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rename(key, newkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRename(String key, String newkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rename(key, newkey, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    @Deprecated
    public Observable<String> renamenxObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.renamenx(key, newkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRenamenx(String key, String newkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.renamenx(key, newkey, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    @Deprecated
    public Observable<String> restoreObservable(String key, long millis, String serialized) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRestore(String key, long millis, String serialized) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction role(Handler<AsyncResult<String>> handler) {
        this.delegate.role(handler);
        return this;
    }

    @Deprecated
    public Observable<String> roleObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.role((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRole() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.role((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpoplpushObservable(String key, String destkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpoplpush(String key, String destkey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushMany(key, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpushMany(String key, List<String> values) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpushMany(key, values, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpush(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpush(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpush(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> rpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushx(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxRpushx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.rpushx(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> saddObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sadd(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSadd(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sadd(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> saddManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.saddMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSaddMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.saddMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    @Deprecated
    public Observable<String> saveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.save((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSave() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.save((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scard(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScard(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scard(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptExistsObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExists(script, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptExists(String script) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptExists(script, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptExistsManyObservable(List<String> scripts) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExistsMany(scripts, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptExistsMany(List<String> scripts) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptExistsMany(scripts, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptFlushObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptFlush((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptFlush() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptFlush((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptKillObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptKill((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptKill() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptKill((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scriptLoadObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptLoad(script, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScriptLoad(String script) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scriptLoad(script, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sdiffObservable(String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiff(key, cmpkeys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSdiff(String key, List<String> cmpkeys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sdiff(key, cmpkeys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sdiffstoreObservable(String destkey, String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSdiffstore(String destkey, String key, List<String> cmpkeys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    @Deprecated
    public Observable<String> selectObservable(int dbindex) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.select(dbindex, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSelect(int dbindex) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.select(dbindex, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.set(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSet(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.set(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setWithOptionsObservable(String key, String value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetWithOptions(String key, String value, SetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    @Deprecated
    public Observable<String> setBinaryObservable(String key, Buffer value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinary(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetBinary(String key, Buffer value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setBinary(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setBinaryWithOptionsObservable(String key, Buffer value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetBinaryWithOptions(String key, Buffer value, SetOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setbitObservable(String key, long offset, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setbit(key, offset, bit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetbit(String key, long offset, int bit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setbit(key, offset, bit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setexObservable(String key, long seconds, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setex(key, seconds, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetex(String key, long seconds, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setex(key, seconds, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setnxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setnx(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetnx(String key, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setnx(key, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    @Deprecated
    public Observable<String> setrangeObservable(String key, int offset, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setrange(key, offset, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSetrange(String key, int offset, String value) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.setrange(key, offset, value, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sinterObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinter(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSinter(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sinter(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sinterstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinterstore(destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSinterstore(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sinterstore(destkey, keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sismemberObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sismember(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSismember(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sismember(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    @Deprecated
    public Observable<String> slaveofObservable(String host, int port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveof(host, port, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlaveof(String host, int port) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slaveof(host, port, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    @Deprecated
    public Observable<String> slaveofNooneObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveofNoone((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlaveofNoone() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slaveofNoone((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> slowlogGetObservable(int limit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogGet(limit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlowlogGet(int limit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogGet(limit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    @Deprecated
    public Observable<String> slowlogLenObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogLen((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlowlogLen() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogLen((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    @Deprecated
    public Observable<String> slowlogResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogReset((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSlowlogReset() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.slowlogReset((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> smembersObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smembers(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public Single<JsonArray> rxSmembers(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.smembers(key, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> smoveObservable(String key, String destkey, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smove(key, destkey, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSmove(String key, String destkey, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.smove(key, destkey, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sortObservable(String key, SortOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sort(key, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSort(String key, SortOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sort(key, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> spopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSpop(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.spop(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    @Deprecated
    public Observable<String> spopManyObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spopMany(key, count, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSpopMany(String key, int count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.spopMany(key, count, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> srandmemberObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmember(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSrandmember(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srandmember(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    @Deprecated
    public Observable<String> srandmemberCountObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmemberCount(key, count, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSrandmemberCount(String key, int count) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srandmemberCount(key, count, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srem(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSrem(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.srem(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sremMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSremMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sremMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> strlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.strlen(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxStrlen(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.strlen(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    @Deprecated
    public Observable<String> subscribeObservable(String channel) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribe(channel, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSubscribe(String channel) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribe(channel, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<String> subscribeManyObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribeMany(channels, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSubscribeMany(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.subscribeMany(channels, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sunionObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunion(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSunion(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sunion(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sunionstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunionstore(destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSunionstore(String destkey, List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sunionstore(destkey, keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sync(Handler<AsyncResult<String>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    @Deprecated
    public Observable<String> syncObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sync((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSync() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sync((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction time(Handler<AsyncResult<String>> handler) {
        this.delegate.time(handler);
        return this;
    }

    @Deprecated
    public Observable<String> timeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.time((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxTime() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.time((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> ttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ttl(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxTtl(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ttl(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> typeObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.type(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxType(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.type(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    @Deprecated
    public Observable<String> unsubscribeObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.unsubscribe(channels, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxUnsubscribe(List<String> channels) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unsubscribe(channels, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) {
        this.delegate.unwatch(handler);
        return this;
    }

    @Deprecated
    public Observable<String> unwatchObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.unwatch((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxUnwatch() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unwatch((Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    @Deprecated
    public Observable<String> waitObservable(long numSlaves, long timeout) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxWait(long numSlaves, long timeout) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.watch(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> watchObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.watch(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxWatch(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.watch(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.watchMany(keys, handler);
        return this;
    }

    @Deprecated
    public Observable<String> watchManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.watchMany(keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxWatchMany(List<String> keys) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.watchMany(keys, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zaddObservable(String key, double score, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zadd(key, score, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZadd(String key, double score, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zadd(key, score, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zaddManyObservable(String key, Map<String, Double> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zaddMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZaddMany(String key, Map<String, Double> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zaddMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zcardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcard(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZcard(String key) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zcard(key, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zcountObservable(String key, double min, double max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcount(key, min, max, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZcount(String key, double min, double max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zcount(key, min, max, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zincrbyObservable(String key, double increment, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZincrby(String key, double increment, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zinterstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zinterstore(destkey, sets, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zinterstoreWeighedObservable(String destkey, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zlexcountObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zlexcount(key, min, max, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZlexcount(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zlexcount(key, min, max, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrangeObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrange(key, start, stop, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrange(String key, long start, long stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrange(key, start, stop, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrangeWithOptionsObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrangebylexObservable(String key, String min, String max, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebylex(key, min, max, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrangebylex(String key, String min, String max, LimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangebylex(key, min, max, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrangebyscoreObservable(String key, String min, String max, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrank(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrank(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrank(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrem(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrem(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrem(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZremMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zremrangebylexObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebylex(key, min, max, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZremrangebylex(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebylex(key, min, max, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zremrangebyrankObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZremrangebyrank(String key, long start, long stop) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zremrangebyscoreObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyscore(key, min, max, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZremrangebyscore(String key, String min, String max) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zremrangebyscore(key, min, max, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrevrangeObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrange(key, start, stop, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrevrange(String key, long start, long stop, RangeOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrange(key, start, stop, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrevrangebylexObservable(String key, String max, String min, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrevrangebylex(String key, String max, String min, LimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrevrangebyscoreObservable(String key, String max, String min, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zrevrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrank(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZrevrank(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zrevrank(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zscoreObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscore(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZscore(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zscore(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zunionstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zunionstore(destkey, sets, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zunionstoreWeighedObservable(String key, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> scanObservable(String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scan(cursor, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxScan(String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.scan(cursor, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> sscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sscan(key, cursor, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxSscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sscan(key, cursor, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> hscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hscan(key, cursor, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxHscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.hscan(key, cursor, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> zscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscan(key, cursor, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxZscan(String key, String cursor, ScanOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.zscan(key, cursor, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geoaddObservable(String key, double longitude, double latitude, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoadd(String key, double longitude, double latitude, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geoaddManyObservable(String key, List<GeoMember> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoaddMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoaddMany(String key, List<GeoMember> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoaddMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geohashObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohash(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeohash(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geohash(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geohashManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohashMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeohashMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geohashMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geoposObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geopos(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeopos(String key, String member) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geopos(key, member, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geoposManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoposMany(key, members, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoposMany(String key, List<String> members) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geoposMany(key, members, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geodistObservable(String key, String member1, String member2) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeodist(String key, String member1, String member2) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> geodistWithUnitObservable(String key, String member1, String member2, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> georadiusObservable(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> georadiusWithOptionsObservable(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    @Deprecated
    public Observable<String> georadiusbymemberObservable(String key, String member, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<String>>)fut)));
    }

    public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    @Deprecated
    public Observable<String> georadiusbymemberWithOptionsObservable(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public Single<String> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<String>>)fut)));
    }

    public static RedisTransaction newInstance(io.vertx.redis.RedisTransaction arg) {
        return arg != null ? new RedisTransaction(arg) : null;
    }
}

