/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.sentinel.RedisSentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class RedisMasterResolver {
    private static final Logger log = LoggerFactory.getLogger(RedisMasterResolver.class);
    private static final int MAX_WAIT_FOR_MASTER_IN_MILLIS = 3000;
    private List<RedisSentinel> sentinels = new ArrayList<RedisSentinel>();
    private String masterName;
    private Vertx vertx;

    RedisMasterResolver(Vertx vertx, RedisOptions redisOptions) {
        this.vertx = vertx;
        this.masterName = redisOptions.getMasterName();
        redisOptions.getSentinels().forEach(s -> {
            String[] hostAndPort = s.split(":");
            if (hostAndPort.length == 2) {
                this.sentinels.add(RedisSentinel.create(vertx, this.getSentinelOptions(redisOptions, hostAndPort[0], Integer.valueOf(hostAndPort[1]))));
            } else {
                this.sentinels.add(RedisSentinel.create(vertx, this.getSentinelOptions(redisOptions, hostAndPort[0], 6379)));
            }
        });
    }

    void getMasterAddressByName(Handler<AsyncResult<JsonObject>> handler) {
        log.debug((Object)"Attempting to resolving master address");
        try {
            AtomicInteger count = new AtomicInteger(this.sentinels.size());
            AtomicBoolean foundMaster = new AtomicBoolean(false);
            for (RedisSentinel sentinelClient : this.sentinels) {
                Handler asyncResultHandler = jsonObjectAsyncResult -> {
                    count.decrementAndGet();
                    if (jsonObjectAsyncResult.succeeded()) {
                        JsonArray masterArray = (JsonArray)jsonObjectAsyncResult.result();
                        if (masterArray != null && masterArray.size() == 2) {
                            JsonObject redisMaster = new JsonObject().put("host", masterArray.getString(0)).put("port", Integer.valueOf(masterArray.getString(1)));
                            if (!foundMaster.get()) {
                                log.info((Object)String.format("Sentinel resolved address for master '%s' to %s:%d", this.masterName, masterArray.getString(0), Integer.valueOf(masterArray.getString(1))));
                                foundMaster.set(true);
                                handler.handle((Object)Future.factory.succeededFuture((Object)redisMaster));
                            }
                        } else {
                            handler.handle((Object)Future.failedFuture((String)String.format("Sentinel failed to resolve address for master '%s'", this.masterName)));
                        }
                    } else {
                        handler.handle((Object)Future.failedFuture((String)String.format("Sentinel unreachable. %s", jsonObjectAsyncResult.cause().getMessage())));
                    }
                    if (count.get() == 0 && !foundMaster.get()) {
                        handler.handle((Object)Future.failedFuture((String)"Failed to resolve master address"));
                    }
                };
                long timerId = this.vertx.setTimer(3000L, t -> asyncResultHandler.handle((Object)Future.failedFuture((String)"Timeout on response from Sentinel")));
                sentinelClient.getMasterAddrByName(this.masterName, (Handler<AsyncResult<JsonArray>>)((Handler)res -> {
                    if (this.vertx.cancelTimer(timerId)) {
                        asyncResultHandler.handle(res);
                    }
                }));
            }
        }
        catch (Exception ex) {
            handler.handle((Object)Future.factory.failedFuture((Throwable)ex));
        }
    }

    private RedisOptions getSentinelOptions(RedisOptions redisOptions, String host, int port) {
        RedisOptions options = new RedisOptions(redisOptions);
        options.setHost(host);
        options.setPort(port);
        return options;
    }

    void close() {
        for (RedisSentinel sentinel : this.sentinels) {
            sentinel.close((Handler<AsyncResult<Void>>)((Handler)h -> {}));
        }
    }
}

