/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.AbstractRedisSentinelClient;
import io.vertx.redis.impl.RedisSentinelCommand;
import io.vertx.redis.sentinel.RedisSentinel;
import io.vertx.redis.utils.RedisCommandUtils;

public class RedisSentinelClientImpl
extends AbstractRedisSentinelClient {
    public RedisSentinelClientImpl(Vertx vertx, RedisOptions config) {
        super(vertx, config);
    }

    @Override
    public RedisSentinel masters(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisSentinelCommand.MASTERS, null, handler);
        return this;
    }

    @Override
    public RedisSentinel master(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisSentinelCommand.MASTER, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel slaves(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisSentinelCommand.SLAVES, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel sentinels(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisSentinelCommand.SENTINELS, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel getMasterAddrByName(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(RedisSentinelCommand.GET_MASTER_ADDR_BY_NAME, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel reset(String pattern, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisSentinelCommand.RESET, RedisCommandUtils.toPayload(pattern), handler);
        return this;
    }

    @Override
    public RedisSentinel failover(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisSentinelCommand.FAILOVER, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel ckquorum(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(RedisSentinelCommand.CKQUORUM, RedisCommandUtils.toPayload(name), handler);
        return this;
    }

    @Override
    public RedisSentinel flushConfig(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(RedisSentinelCommand.FLUSHCONFIG, null, handler);
        return this;
    }
}

