/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.RedisClusterClient;
import io.vertx.redis.client.impl.RedisSentinelClient;
import java.util.List;

@VertxGen
public interface Redis
extends ReadStream<Response> {
    public static Redis createClient(Vertx vertx, SocketAddress address) {
        return Redis.createClient(vertx, new RedisOptions().setEndpoint(address));
    }

    public static Redis createClient(Vertx vertx, RedisOptions options) {
        switch (options.getType()) {
            case STANDALONE: {
                return RedisClient.create(vertx, options);
            }
            case SENTINEL: {
                return RedisSentinelClient.create(vertx, options);
            }
            case CLUSTER: {
                return RedisClusterClient.create(vertx, options);
            }
        }
        throw new IllegalStateException("Unknown Redis Client type: " + (Object)((Object)options.getType()));
    }

    @Fluent
    public Redis connect(Handler<AsyncResult<Redis>> var1);

    @Fluent
    public Redis exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public Redis handler(Handler<Response> var1);

    @Fluent
    public Redis pause();

    @Fluent
    public Redis resume();

    @Fluent
    public Redis fetch(long var1);

    @Fluent
    public Redis endHandler(@Nullable Handler<Void> var1);

    @Fluent
    public Redis send(Request var1, Handler<AsyncResult<@Nullable Response>> var2);

    @Fluent
    public Redis batch(List<Request> var1, Handler<AsyncResult<List<@Nullable Response>>> var2);

    public SocketAddress socketAddress();

    public void close();
}

