/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisAPIImpl;
import java.util.List;

@VertxGen
public interface RedisAPI {
    public static RedisAPI api(Redis client) {
        return new RedisAPIImpl(client);
    }

    @Fluent
    default public RedisAPI append(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.APPEND, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI asking(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ASKING, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI auth(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.AUTH, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bgrewriteaof(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BGREWRITEAOF, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bgsave(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BGSAVE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bitcount(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITCOUNT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bitfield(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITFIELD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bitop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITOP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bitpos(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BITPOS, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI blpop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BLPOP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI brpop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BRPOP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI brpoplpush(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BRPOPLPUSH, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bzpopmax(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BZPOPMAX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI bzpopmin(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.BZPOPMIN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI client(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CLIENT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI cluster(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CLUSTER, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI command(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.COMMAND, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI config(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.CONFIG, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI dbsize(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DBSIZE, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI debug(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DEBUG, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI decr(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DECR, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI decrby(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DECRBY, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI del(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DEL, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI discard(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DISCARD, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI dump(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.DUMP, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI echo(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ECHO, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI eval(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EVAL, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI evalsha(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EVALSHA, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI exec(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXEC, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI exists(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXISTS, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI expire(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXPIRE, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI expireat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.EXPIREAT, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI flushall(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.FLUSHALL, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI flushdb(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.FLUSHDB, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI geoadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOADD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI geodist(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEODIST, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI geohash(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOHASH, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI geopos(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEOPOS, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI georadius(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUS, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI georadiusRo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUS_RO, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI georadiusbymember(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUSBYMEMBER, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI georadiusbymemberRo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GEORADIUSBYMEMBER_RO, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI get(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GET, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI getbit(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETBIT, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI getrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETRANGE, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI getset(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.GETSET, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hdel(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HDEL, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hexists(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HEXISTS, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hget(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HGET, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hgetall(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HGETALL, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HINCRBY, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hincrbyfloat(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HINCRBYFLOAT, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hkeys(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HKEYS, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HLEN, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hmget(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HMGET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hmset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HMSET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI host(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HOST, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSCAN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hsetnx(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSETNX, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hstrlen(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HSTRLEN, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI hvals(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.HVALS, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI incr(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCR, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI incrby(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCRBY, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI incrbyfloat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INCRBYFLOAT, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI info(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.INFO, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI keys(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.KEYS, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lastsave(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LASTSAVE, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI latency(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LATENCY, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lindex(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LINDEX, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI linsert(String arg0, String arg1, String arg2, String arg3, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LINSERT, arg0, arg1, arg2, arg3).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI llen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LLEN, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lolwut(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LOLWUT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lpop(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPOP, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lpush(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPUSH, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lpushx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LPUSHX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LRANGE, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lrem(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LREM, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI lset(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LSET, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI ltrim(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.LTRIM, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI memory(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MEMORY, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI mget(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MGET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI migrate(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MIGRATE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI module(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MODULE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI monitor(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MONITOR, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI move(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MOVE, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI mset(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MSET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI msetnx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MSETNX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI multi(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.MULTI, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI object(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.OBJECT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI persist(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PERSIST, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pexpire(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PEXPIRE, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pexpireat(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PEXPIREAT, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pfadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFADD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pfcount(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFCOUNT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pfdebug(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFDEBUG, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pfmerge(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFMERGE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pfselftest(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PFSELFTEST, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI ping(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PING, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI post(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.POST, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI psetex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSETEX, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI psubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSUBSCRIBE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI psync(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PSYNC, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pttl(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PTTL, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI publish(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUBLISH, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI pubsub(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUBSUB, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI punsubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.PUNSUBSCRIBE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI randomkey(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RANDOMKEY, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI readonly(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.READONLY, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI readwrite(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.READWRITE, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI rename(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RENAME, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI renamenx(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RENAMENX, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI replconf(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.REPLCONF, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI replicaof(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.REPLICAOF, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI restore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RESTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI restoreAsking(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RESTORE_ASKING, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI role(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ROLE, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI rpop(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPOP, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI rpoplpush(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPOPLPUSH, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI rpush(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPUSH, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI rpushx(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.RPUSHX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SADD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI save(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SAVE, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI scan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCAN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI scard(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCARD, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI script(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SCRIPT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sdiff(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SDIFF, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sdiffstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SDIFFSTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI select(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SELECT, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI set(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SET, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI setbit(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETBIT, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI setex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETEX, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI setnx(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETNX, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI setrange(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SETRANGE, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI shutdown(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SHUTDOWN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sinter(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SINTER, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sinterstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SINTERSTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sismember(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SISMEMBER, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI slaveof(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SLAVEOF, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI slowlog(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SLOWLOG, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI smembers(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SMEMBERS, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI smove(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SMOVE, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sort(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SORT, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI spop(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SPOP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI srandmember(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SRANDMEMBER, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI srem(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SREM, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SSCAN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI strlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.STRLEN, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI subscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUBSCRIBE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI substr(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUBSTR, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sunion(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUNION, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sunionstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SUNIONSTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI swapdb(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SWAPDB, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI sync(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.SYNC, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI time(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TIME, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI touch(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TOUCH, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI ttl(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TTL, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI type(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.TYPE, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI unlink(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNLINK, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI unsubscribe(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNSUBSCRIBE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI unwatch(Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.UNWATCH, new Object[0]).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI wait(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.WAIT, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI watch(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.WATCH, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xack(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XACK, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XADD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xclaim(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XCLAIM, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xdel(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XDEL, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xgroup(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XGROUP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xinfo(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XINFO, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xlen(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XLEN, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xpending(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XPENDING, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XRANGE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xread(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREAD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xreadgroup(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREADGROUP, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xrevrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XREVRANGE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xsetid(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XSETID, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI xtrim(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.XTRIM, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zadd(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZADD, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zcard(String arg0, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZCARD, arg0).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zcount(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZCOUNT, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZINCRBY, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zinterstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZINTERSTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zlexcount(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZLEXCOUNT, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zpopmax(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZPOPMAX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zpopmin(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZPOPMIN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrangebylex(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGEBYLEX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrangebyscore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANGEBYSCORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrank(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZRANK, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrem(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREM, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zremrangebylex(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYLEX, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zremrangebyrank(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYRANK, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zremrangebyscore(String arg0, String arg1, String arg2, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREMRANGEBYSCORE, arg0, arg1, arg2).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrevrange(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrevrangebylex(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGEBYLEX, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrevrangebyscore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANGEBYSCORE, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zrevrank(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZREVRANK, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zscan(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZSCAN, args.toArray()).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zscore(String arg0, String arg1, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZSCORE, arg0, arg1).setHandler(handler);
        return this;
    }

    @Fluent
    default public RedisAPI zunionstore(List<String> args, Handler<AsyncResult<@Nullable Response>> handler) {
        this.send(Command.ZUNIONSTORE, args.toArray()).setHandler(handler);
        return this;
    }

    @GenIgnore
    public Future<Response> send(Command var1, Object ... var2);
}

