/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

public final class RedisException
extends RuntimeException {
    public RedisException(String message) {
        super(message, null, false, false);
    }

    public boolean is(String type) {
        String message = this.getMessage();
        if (message == null) {
            return false;
        }
        int len = type.length();
        if (message.length() < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (message.charAt(i) == type.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String slice(char sep, int index) {
        String message = this.getMessage();
        if (message == null) {
            return null;
        }
        int start = 0;
        int count = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) != sep) continue;
            if (++count > index) {
                return message.substring(start, i);
            }
            start = i + 1;
        }
        if (count == index) {
            return message.substring(start);
        }
        return null;
    }
}

