/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptionsConverter;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSlaves;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RedisOptions {
    private RedisClientType type;
    private NetClientOptions netClientOptions;
    private List<SocketAddress> endpoints;
    private int maxWaitingHandlers;
    private int maxNestedArrays;
    private String masterName;
    private RedisRole role;
    private RedisSlaves slaves;
    private String password;
    private Integer select;

    private void init() {
        this.netClientOptions = new NetClientOptions().setTcpKeepAlive(true).setTcpNoDelay(true);
        this.maxWaitingHandlers = 2048;
        this.maxNestedArrays = 32;
        this.masterName = "mymaster";
        this.role = RedisRole.MASTER;
        this.slaves = RedisSlaves.NEVER;
        this.type = RedisClientType.STANDALONE;
    }

    public RedisOptions() {
        this.init();
    }

    public RedisOptions(RedisOptions other) {
        this.type = other.type;
        this.netClientOptions = other.netClientOptions;
        this.endpoints = other.endpoints;
        this.maxWaitingHandlers = other.maxWaitingHandlers;
        this.maxNestedArrays = other.maxNestedArrays;
        this.masterName = other.masterName;
        this.role = other.role;
        this.slaves = other.slaves;
        this.password = other.password;
        this.select = other.select;
    }

    public RedisOptions(JsonObject json) {
        this.init();
        RedisOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisClientType getType() {
        return this.type;
    }

    public RedisOptions setType(RedisClientType type) {
        this.type = type;
        return this;
    }

    public NetClientOptions getNetClientOptions() {
        return this.netClientOptions;
    }

    public RedisOptions setNetClientOptions(NetClientOptions netClientOptions) {
        this.netClientOptions = netClientOptions;
        return this;
    }

    public List<SocketAddress> getEndpoints() {
        return this.endpoints;
    }

    public SocketAddress getEndpoint() {
        if (this.endpoints == null || this.endpoints.size() == 0) {
            return SocketAddress.inetSocketAddress((int)6379, (String)"localhost");
        }
        return this.endpoints.get(0);
    }

    public RedisOptions setEndpoints(List<SocketAddress> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public RedisOptions addEndpoint(SocketAddress endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<SocketAddress>();
        }
        this.endpoints.add(endpoint);
        return this;
    }

    public RedisOptions setEndpoint(SocketAddress endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<SocketAddress>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(endpoint);
        return this;
    }

    public int getMaxWaitingHandlers() {
        return this.maxWaitingHandlers;
    }

    public RedisOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        this.maxWaitingHandlers = maxWaitingHandlers;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisRole getRole() {
        return this.role;
    }

    public RedisOptions setRole(RedisRole role) {
        this.role = role;
        return this;
    }

    public RedisSlaves getUseSlave() {
        return this.slaves;
    }

    public RedisOptions setUseSlave(RedisSlaves slaves) {
        this.slaves = slaves;
        return this;
    }

    public int getMaxNestedArrays() {
        return this.maxNestedArrays;
    }

    public RedisOptions setMaxNestedArrays(int maxNestedArrays) {
        this.maxNestedArrays = maxNestedArrays;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RedisOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public Integer getSelect() {
        return this.select;
    }

    public RedisOptions setSelect(Integer select) {
        this.select = select;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisOptionsConverter.toJson(this, json);
        return json;
    }
}

