/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.ResponseType;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;

@VertxGen
public interface Response
extends Iterable<Response> {
    public ResponseType type();

    public String toString();

    default public Long toLong() {
        String msg = this.toString();
        if (msg != null) {
            return Long.parseLong(msg);
        }
        return null;
    }

    default public Integer toInteger() {
        String msg = this.toString();
        if (msg != null) {
            return Integer.parseInt(msg);
        }
        return null;
    }

    default public Short toShort() {
        String msg = this.toString();
        if (msg != null) {
            return Short.parseShort(msg);
        }
        return null;
    }

    default public Byte toByte() {
        String msg = this.toString();
        if (msg != null) {
            return Byte.parseByte(msg);
        }
        return null;
    }

    default public Boolean toBoolean() {
        String msg = this.toString();
        if (msg != null) {
            return 1L == Long.parseLong(msg);
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public String toString(Charset encoding) {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    default public Buffer toBuffer() {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    @GenIgnore(value={"permitted-type"})
    default public byte[] toBytes() {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    default public Response get(int index) {
        throw new UnsupportedOperationException("This type doesn't hold an Array type");
    }

    default public Response get(String key) {
        throw new UnsupportedOperationException("This type doesn't hold an Array type");
    }

    default public Set<String> getKeys() {
        throw new UnsupportedOperationException("This type doesn't hold an Array type");
    }

    default public int size() {
        throw new UnsupportedOperationException("This type doesn't hold an Array type");
    }

    @Override
    @GenIgnore
    default public Iterator<Response> iterator() {
        throw new UnsupportedOperationException("This type doesn't hold a Array type");
    }
}

