/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisSlaves;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.RequestImpl;
import io.vertx.redis.client.impl.ZModem;
import io.vertx.redis.client.impl.types.ErrorType;
import io.vertx.redis.client.impl.types.IntegerType;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RedisClusterClient
implements Redis {
    private static final int RETRIES = 16;
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterClient.class);
    private static final Random RANDOM = new Random();
    private static final Map<Command, Function<List<Response>, Response>> REDUCERS = new HashMap<Command, Function<List<Response>, Response>>();
    private static final Map<Command, String> UNSUPPORTEDCOMMANDS = new HashMap<Command, String>();
    private final Vertx vertx;
    private final RedisSlaves slaves;
    private final RedisOptions options;
    private final Map<SocketAddress, Redis> connections = new HashMap<SocketAddress, Redis>();
    private final Redis[][] slots = new Redis[16384][];
    private Handler<Throwable> onException = t -> LOG.error((Object)"Unhandled Error", t);
    private Handler<Void> onEnd;
    private Handler<Response> onMessage;
    private int slotNumber;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        REDUCERS.put(command, fn);
    }

    public static void addUnSupportedCommand(Command command, String error) {
        if (error == null || error.isEmpty()) {
            UNSUPPORTEDCOMMANDS.put(command, "RedisClusterClient does not handle command " + new String(command.getBytes(), StandardCharsets.ISO_8859_1).split("\r\n")[1] + ", use non cluster client on the right node.");
        } else {
            UNSUPPORTEDCOMMANDS.put(command, error);
        }
    }

    public static Redis create(Vertx vertx, RedisOptions options) {
        return new RedisClusterClient(vertx, options);
    }

    private RedisClusterClient(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.slaves = options.getUseSlave();
        this.options = options;
    }

    @Override
    public Redis connect(Handler<AsyncResult<Redis>> onCreate) {
        List<SocketAddress> endpoints = this.options.getEndpoints();
        AtomicInteger counter = new AtomicInteger(endpoints.size());
        for (SocketAddress endpoint : endpoints) {
            this.getClient(endpoint, this.options, (Handler<AsyncResult<Redis>>)((Handler)ar -> {
                int total = counter.decrementAndGet();
                if (ar.failed()) {
                    LOG.warn((Object)("Failed to connect to: " + endpoint));
                }
                if (total == 0) {
                    this.getSlots(this.options, (Handler<AsyncResult<Void>>)((Handler)getSlots -> {
                        if (getSlots.failed()) {
                            onCreate.handle((Object)Future.failedFuture((Throwable)getSlots.cause()));
                        } else {
                            onCreate.handle((Object)Future.succeededFuture((Object)this));
                        }
                    }));
                }
            }));
        }
        return this;
    }

    @Override
    public void close() {
        this.connections.entrySet().removeIf(kv -> {
            if (kv.getValue() != null) {
                ((Redis)kv.getValue()).close();
            }
            return true;
        });
    }

    @Override
    public Redis exceptionHandler(Handler<Throwable> handler) {
        this.onException = handler;
        return this;
    }

    @Override
    public Redis endHandler(Handler<Void> handler) {
        this.onEnd = handler;
        return this;
    }

    @Override
    public Redis handler(Handler<Response> handler) {
        this.onMessage = handler;
        return this;
    }

    @Override
    public Redis pause() {
        this.connections.values().forEach(conn -> {
            if (conn != null) {
                conn.pause();
            }
        });
        return this;
    }

    @Override
    public Redis resume() {
        this.connections.values().forEach(conn -> {
            if (conn != null) {
                conn.resume();
            }
        });
        return null;
    }

    @Override
    public Redis send(Request request, Handler<AsyncResult<Response>> handler) {
        RequestImpl req = (RequestImpl)request;
        Command cmd = req.command();
        if (UNSUPPORTEDCOMMANDS.containsKey(cmd)) {
            try {
                handler.handle((Object)Future.failedFuture((String)UNSUPPORTEDCOMMANDS.get(cmd)));
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
            return this;
        }
        if (cmd.isMovable()) {
            try {
                handler.handle((Object)Future.failedFuture((String)"RedisClusterClient does not handle movable keys commands, use non cluster client on the right node."));
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
            return this;
        }
        if (cmd.isKeyless() && REDUCERS.containsKey(cmd)) {
            ArrayList<Future> responses = new ArrayList<Future>(this.slotNumber);
            for (int i = 1; i <= this.slotNumber; ++i) {
                Redis[] clients = this.slots[(this.slots.length / this.slotNumber - 1) * i];
                Future f = Future.future();
                this.send(this.selectMasterOrSlave(req.command().isReadOnly(), clients), this.options, 16, req, (Handler<AsyncResult<Response>>)f);
                responses.add(f);
            }
            CompositeFuture.all(responses).setHandler(composite -> {
                if (composite.failed()) {
                    try {
                        handler.handle((Object)Future.failedFuture((Throwable)composite.cause()));
                    }
                    catch (RuntimeException e) {
                        this.onException.handle((Object)e);
                    }
                } else {
                    try {
                        handler.handle((Object)Future.succeededFuture((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list())));
                    }
                    catch (RuntimeException e) {
                        this.onException.handle((Object)e);
                    }
                }
            });
            return this;
        }
        if (cmd.isKeyless()) {
            this.send(this.selectClient(-1, cmd.isReadOnly()), this.options, 16, req, handler);
            return this;
        }
        List<byte[]> args = req.getArgs();
        if (cmd.isMultiKey()) {
            int currentSlot = -1;
            int start = cmd.getFirstKey() - 1;
            int end = cmd.getLastKey();
            if (end > 0) {
                --end;
            }
            if (end < 0) {
                end = args.size() + (end + 1);
            }
            int step = cmd.getInterval();
            for (int i = start; i < end; i += step) {
                int slot = ZModem.generate(args.get(i));
                if (currentSlot == -1) {
                    currentSlot = slot;
                    continue;
                }
                if (currentSlot == slot) continue;
                if (!REDUCERS.containsKey(cmd)) {
                    try {
                        handler.handle((Object)Future.failedFuture((String)("No Reducer available for: " + cmd)));
                    }
                    catch (RuntimeException e) {
                        this.onException.handle((Object)e);
                    }
                    return this;
                }
                Map<Integer, Request> requests = this.splitRequest(cmd, args, start, end, step);
                ArrayList<Future> responses = new ArrayList<Future>(requests.size());
                for (Map.Entry<Integer, Request> kv : requests.entrySet()) {
                    Promise p = Promise.promise();
                    this.send(this.selectClient(kv.getKey(), cmd.isReadOnly()), this.options, 16, kv.getValue(), (Handler<AsyncResult<Response>>)p);
                    responses.add(p.future());
                }
                CompositeFuture.all(responses).setHandler(composite -> {
                    if (composite.failed()) {
                        try {
                            handler.handle((Object)Future.failedFuture((Throwable)composite.cause()));
                        }
                        catch (RuntimeException e) {
                            this.onException.handle((Object)e);
                        }
                    } else {
                        try {
                            handler.handle((Object)Future.succeededFuture((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list())));
                        }
                        catch (RuntimeException e) {
                            this.onException.handle((Object)e);
                        }
                    }
                });
                return this;
            }
            this.send(this.selectClient(currentSlot, cmd.isReadOnly()), this.options, 16, req, handler);
            return this;
        }
        int start = cmd.getFirstKey() - 1;
        this.send(this.selectClient(ZModem.generate(args.get(start)), cmd.isReadOnly()), this.options, 16, req, handler);
        return this;
    }

    private Map<Integer, Request> splitRequest(Command cmd, List<byte[]> args, int start, int end, int step) {
        IdentityHashMap<Integer, Request> map = new IdentityHashMap<Integer, Request>();
        for (int i = start; i < end; i += step) {
            int j;
            int slot = ZModem.generate(args.get(i));
            Request request = (Request)map.get(slot);
            if (request == null) {
                request = Request.cmd(cmd);
                for (j = 0; j < start; ++j) {
                    request.arg(args.get(j));
                }
                map.put(slot, request);
            }
            request.arg(args.get(i));
            for (j = i + 1; j < i + step; ++j) {
                request.arg(args.get(j));
            }
        }
        Collection col = map.values();
        col.forEach(req -> {
            for (int j = end; j < args.size(); ++j) {
                req.arg((byte[])args.get(j));
            }
        });
        return map;
    }

    @Override
    public Redis batch(List<Request> requests, Handler<AsyncResult<List<Response>>> handler) {
        int currentSlot = -1;
        boolean readOnly = false;
        for (int i = 0; i < requests.size(); ++i) {
            int start;
            RequestImpl req = (RequestImpl)requests.get(i);
            Command cmd = req.command();
            if (UNSUPPORTEDCOMMANDS.containsKey(cmd)) {
                try {
                    handler.handle((Object)Future.failedFuture((String)UNSUPPORTEDCOMMANDS.get(cmd)));
                }
                catch (RuntimeException e) {
                    this.onException.handle((Object)e);
                }
                return this;
            }
            readOnly |= cmd.isReadOnly();
            if (cmd.isKeyless()) continue;
            if (cmd.isMovable()) {
                handler.handle((Object)Future.failedFuture((String)"RedisClusterClient does not handle movable keys commands, use non cluster client on the right node."));
                return this;
            }
            List<byte[]> args = req.getArgs();
            if (cmd.isMultiKey()) {
                start = cmd.getFirstKey() - 1;
                int end = cmd.getLastKey();
                if (end > 0) {
                    --end;
                }
                if (end < 0) {
                    end = args.size() + (end + 1);
                }
                int step = cmd.getInterval();
                for (int j = start; j < end; j += step) {
                    int slot = ZModem.generate(args.get(j));
                    if (currentSlot == -1) {
                        currentSlot = slot;
                        continue;
                    }
                    if (currentSlot == slot) continue;
                    handler.handle((Object)Future.failedFuture((String)"RedisClusterClient does not handle batching commands with keys across different slots. TODO: Split the command into slots and then batch."));
                    return this;
                }
                continue;
            }
            start = cmd.getFirstKey() - 1;
            int slot = ZModem.generate(args.get(start));
            if (currentSlot == -1) {
                currentSlot = slot;
                continue;
            }
            if (currentSlot == slot) continue;
            handler.handle((Object)Future.failedFuture((String)"RedisClusterClient does not handle batching commands with keys across different slots. TODO: Split the command into slots and then batch."));
            return this;
        }
        this.batch(this.selectClient(currentSlot, readOnly), this.options, 16, requests, handler);
        return this;
    }

    @Override
    public SocketAddress socketAddress() {
        throw new UnsupportedOperationException("Cluster Connection is not bound to a socket");
    }

    @Override
    public Redis fetch(long amount) {
        this.connections.values().forEach(conn -> {
            if (conn != null) {
                conn.fetch(amount);
            }
        });
        return this;
    }

    private void getClient(SocketAddress address, RedisOptions options, Handler<AsyncResult<Redis>> onClient) {
        Redis cli = this.connections.get(address);
        if (cli != null) {
            onClient.handle((Object)Future.succeededFuture((Object)cli));
            return;
        }
        RedisClient.create(this.vertx, options, address).connect((Handler<AsyncResult<Redis>>)((Handler)create -> {
            if (create.failed()) {
                onClient.handle(create);
                return;
            }
            Redis conn = (Redis)create.result();
            conn.exceptionHandler(t -> {
                this.connections.remove(address);
                if (this.onException != null) {
                    this.onException.handle(t);
                }
                this.getSlots(options, (Handler<AsyncResult<Void>>)((Handler)ar -> {
                    if (ar.failed() && this.onException != null) {
                        this.onException.handle((Object)ar.cause());
                    }
                }));
            });
            conn.endHandler(v -> {
                this.connections.remove(address);
                if (this.connections.size() == 0 && this.onEnd != null) {
                    this.onEnd.handle(null);
                }
            });
            conn.handler(r -> {
                if (this.onMessage != null) {
                    this.onMessage.handle(r);
                }
            });
            this.connections.put(address, conn);
            onClient.handle((Object)Future.succeededFuture((Object)conn));
        }));
    }

    private void getSlots(final RedisOptions options, final Handler<AsyncResult<Void>> handler) {
        final HashSet exclude = new HashSet();
        final AtomicReference cause = new AtomicReference();
        Runnable tryClient = new Runnable(){

            @Override
            public void run() {
                Redis conn = RedisClusterClient.this.getRandomConnection(exclude);
                if (conn == null) {
                    handler.handle((Object)Future.failedFuture((Throwable)ErrorType.create("SLOTS No client's available.")));
                    return;
                }
                conn.send(Request.cmd(Command.CLUSTER).arg("SLOTS"), (Handler<AsyncResult<Response>>)((Handler)send -> {
                    if (send.failed()) {
                        exclude.add(conn.socketAddress());
                        cause.set(send.cause());
                        this.run();
                        return;
                    }
                    Response reply = (Response)send.result();
                    if (reply.size() == 0) {
                        exclude.add(conn.socketAddress());
                        cause.set(ErrorType.create("SLOTS No slots available in the cluster."));
                        this.run();
                        return;
                    }
                    HashSet<SocketAddress> seenClients = new HashSet<SocketAddress>();
                    AtomicInteger slotCounter = new AtomicInteger(reply.size());
                    RedisClusterClient.this.slotNumber = reply.size();
                    for (int i = 0; i < reply.size(); ++i) {
                        Response s = reply.get(i);
                        int start = s.get(0).toInteger();
                        int end = s.get(1).toInteger();
                        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
                        for (int index = 2; index < s.size(); ++index) {
                            Response c = s.get(index);
                            SocketAddress address = SocketAddress.inetSocketAddress((int)c.get(1).toInteger(), (String)c.get(0).toString());
                            addresses.add(address);
                            seenClients.add(address);
                        }
                        RedisClusterClient.this.loadSlot(start, end, addresses, options, (Handler<Void>)onLoad -> {
                            if (slotCounter.decrementAndGet() == 0) {
                                RedisClusterClient.this.connections.entrySet().removeIf(kv -> {
                                    if (kv.getValue() == null) {
                                        return true;
                                    }
                                    if (!seenClients.contains(kv.getKey())) {
                                        ((Redis)kv.getValue()).close();
                                        kv.setValue(null);
                                        return true;
                                    }
                                    return false;
                                });
                                handler.handle((Object)Future.succeededFuture());
                            }
                        });
                    }
                }));
            }
        };
        tryClient.run();
    }

    private Redis getRandomConnection(Set<SocketAddress> exclude) {
        List available = this.connections.entrySet().stream().filter(kv -> !exclude.contains(kv.getKey()) && kv.getValue() != null).map(Map.Entry::getValue).collect(Collectors.toList());
        if (available.size() == 0) {
            return null;
        }
        return (Redis)available.get(RANDOM.nextInt(available.size()));
    }

    private void loadSlot(int start, int end, List<SocketAddress> addresses, RedisOptions options, Handler<Void> onLoad) {
        Redis[] connections = new Redis[addresses.size()];
        AtomicInteger counter = new AtomicInteger(addresses.size());
        int i = 0;
        while (i < addresses.size()) {
            int idx = i++;
            SocketAddress address = addresses.get(idx);
            Future getClientFuture = Future.future();
            this.getClient(address, options, (Handler<AsyncResult<Redis>>)getClientFuture);
            getClientFuture.compose(getClient -> {
                if (RedisSlaves.NEVER != options.getUseSlave()) {
                    Future readOnlyFuture = Future.future();
                    getClient.send(Request.cmd(Command.READONLY), (Handler<AsyncResult<Response>>)readOnlyFuture);
                    return readOnlyFuture.map(getClient);
                }
                return Future.succeededFuture((Object)getClient);
            }).setHandler(getClient -> {
                if (getClient.failed()) {
                    LOG.warn((Object)("Could not get a connection to node [" + address + "]"));
                } else {
                    connections[idx] = (Redis)getClient.result();
                }
                if (counter.decrementAndGet() == 0) {
                    for (int j = start; j <= end; ++j) {
                        this.slots[j] = connections;
                    }
                    onLoad.handle(null);
                }
            });
        }
    }

    private void send(Redis client, RedisOptions options, int retries, Request command, Handler<AsyncResult<Response>> handler) {
        if (client == null) {
            try {
                handler.handle((Object)Future.failedFuture((String)"No connection available."));
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
            return;
        }
        client.send(command, (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                boolean moved;
                ErrorType cause = (ErrorType)send.cause();
                boolean ask = cause.is("ASK");
                boolean bl = moved = !ask && cause.is("MOVED");
                if (moved || ask) {
                    Runnable andThen = () -> {
                        String addr = cause.slice(' ', 2);
                        if (addr == null) {
                            try {
                                handler.handle((Object)Future.failedFuture((Throwable)cause));
                            }
                            catch (RuntimeException e) {
                                this.onException.handle((Object)e);
                            }
                            return;
                        }
                        int sep = addr.lastIndexOf(58);
                        SocketAddress socketAddress = sep != -1 ? SocketAddress.inetSocketAddress((int)Integer.parseInt(addr.substring(sep + 1)), (String)addr.substring(0, sep)) : SocketAddress.domainSocketAddress((String)addr);
                        this.getClient(socketAddress, options, (Handler<AsyncResult<Redis>>)((Handler)getClient -> {
                            if (getClient.failed()) {
                                try {
                                    handler.handle((Object)Future.failedFuture((Throwable)getClient.cause()));
                                }
                                catch (RuntimeException e) {
                                    this.onException.handle((Object)e);
                                }
                                return;
                            }
                            this.send((Redis)getClient.result(), options, retries - 1, command, handler);
                        }));
                    };
                    if (moved) {
                        this.getSlots(options, (Handler<AsyncResult<Void>>)((Handler)getSlots -> andThen.run()));
                    } else {
                        andThen.run();
                    }
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.send(client, options, retries - 1, command, handler));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
        }));
    }

    private void batch(Redis client, RedisOptions options, int retries, List<Request> commands, Handler<AsyncResult<List<Response>>> handler) {
        if (client == null) {
            try {
                handler.handle((Object)Future.failedFuture((String)"No connection available."));
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
            return;
        }
        client.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                boolean moved;
                ErrorType cause = (ErrorType)send.cause();
                boolean ask = cause.is("ASK");
                boolean bl = moved = !ask && cause.is("MOVED");
                if (moved || ask) {
                    Runnable andThen = () -> {
                        String addr = cause.slice(' ', 2);
                        if (addr == null) {
                            try {
                                handler.handle((Object)Future.failedFuture((Throwable)cause));
                            }
                            catch (RuntimeException e) {
                                this.onException.handle((Object)e);
                            }
                            return;
                        }
                        int sep = addr.lastIndexOf(58);
                        SocketAddress socketAddress = sep != -1 ? SocketAddress.inetSocketAddress((int)Integer.parseInt(addr.substring(sep + 1)), (String)addr.substring(0, sep)) : SocketAddress.domainSocketAddress((String)addr);
                        this.getClient(socketAddress, options, (Handler<AsyncResult<Redis>>)((Handler)getClient -> {
                            if (getClient.failed()) {
                                try {
                                    handler.handle((Object)Future.failedFuture((Throwable)getClient.cause()));
                                }
                                catch (RuntimeException e) {
                                    this.onException.handle((Object)e);
                                }
                                return;
                            }
                            this.batch((Redis)getClient.result(), options, retries - 1, commands, handler);
                        }));
                    };
                    if (moved) {
                        this.getSlots(options, (Handler<AsyncResult<Void>>)((Handler)getSlots -> andThen.run()));
                    } else {
                        andThen.run();
                    }
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.batch(client, options, retries - 1, commands, handler));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                this.onException.handle((Object)e);
            }
        }));
    }

    private Redis selectClient(int keySlot, boolean readOnly) {
        if (keySlot == -1) {
            return this.getRandomConnection(Collections.emptySet());
        }
        Redis[] clients = this.slots[keySlot];
        if (clients == null || clients.length == 0) {
            return this.getRandomConnection(Collections.emptySet());
        }
        return this.selectMasterOrSlave(readOnly, clients);
    }

    private Redis selectMasterOrSlave(boolean readOnly, Redis[] clients) {
        int index = 0;
        if (readOnly && this.slaves != RedisSlaves.NEVER && clients.length > 1) {
            if (this.slaves == RedisSlaves.ALWAYS) {
                index = RANDOM.nextInt(clients.length - 1) + 1;
            }
            if (this.slaves == RedisSlaves.SHARE) {
                index = RANDOM.nextInt(clients.length);
            }
        }
        return clients[index];
    }

    static {
        RedisClusterClient.addReducer(Command.MSET, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DEL, list -> IntegerType.create(list.stream().mapToLong(Response::toLong).sum()));
        RedisClusterClient.addReducer(Command.MGET, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.KEYS, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.FLUSHDB, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DBSIZE, list -> IntegerType.create(list.stream().mapToLong(Response::toLong).sum()));
        Arrays.asList(Command.ASKING, Command.AUTH, Command.BGREWRITEAOF, Command.BGSAVE, Command.CLIENT, Command.CLUSTER, Command.COMMAND, Command.CONFIG, Command.DEBUG, Command.DISCARD, Command.HOST, Command.INFO, Command.LASTSAVE, Command.LATENCY, Command.LOLWUT, Command.MEMORY, Command.MODULE, Command.MONITOR, Command.PFDEBUG, Command.PFSELFTEST, Command.PING, Command.READONLY, Command.READWRITE, Command.REPLCONF, Command.REPLICAOF, Command.ROLE, Command.SAVE, Command.SCAN, Command.SCRIPT, Command.SELECT, Command.SHUTDOWN, Command.SLAVEOF, Command.SLOWLOG, Command.SWAPDB, Command.SYNC, Command.SENTINEL).forEach(command -> RedisClusterClient.addUnSupportedCommand(command, null));
        RedisClusterClient.addUnSupportedCommand(Command.FLUSHALL, "RedisClusterClient does not handle command FLUSHALL, use FLUSHDB");
    }
}

