/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.sentinel;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.RedisSentinelClientImpl;

@VertxGen
public interface RedisSentinel {
    public static RedisSentinel create(Vertx vertx) {
        return RedisSentinel.create(vertx, new RedisOptions());
    }

    public static RedisSentinel create(Vertx vertx, JsonObject config) {
        return RedisSentinel.create(vertx, new RedisOptions(config));
    }

    @GenIgnore
    public static RedisSentinel create(Vertx vertx, RedisOptions options) {
        return new RedisSentinelClientImpl(vertx, options);
    }

    public void close(Handler<AsyncResult<Void>> var1);

    @Fluent
    public RedisSentinel masters(Handler<AsyncResult<JsonArray>> var1);

    @Fluent
    public RedisSentinel master(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisSentinel slaves(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisSentinel sentinels(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisSentinel getMasterAddrByName(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public RedisSentinel reset(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public RedisSentinel failover(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisSentinel ckquorum(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public RedisSentinel flushConfig(Handler<AsyncResult<Void>> var1);
}

