/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.sentinel.RedisSentinel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@Deprecated
public class RedisSentinelClientImpl
implements RedisSentinel {
    private final Vertx vertx;
    private final RedisOptions options;
    private final AtomicReference<CompletableFuture<Redis>> redis = new AtomicReference();
    private final String connectionString;

    public RedisSentinelClientImpl(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
        String connString = "";
        if (options.isDomainSocket()) {
            connString = connString + "unix://" + options.getDomainSocketAddress() + "?";
        } else {
            connString = connString + "redis";
            if (options.isSsl()) {
                connString = connString + "s";
            }
            connString = connString + "://" + options.getHost() + ":" + options.getPort() + "/?";
        }
        if (options.getAuth() != null) {
            connString = connString + "password=" + options.getAuth() + "&";
        }
        if (options.getSelect() != null) {
            connString = connString + "db=" + options.getSelect();
        }
        this.connectionString = connString;
    }

    private static List<?> toPayload(Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(Objects::nonNull).forEach(result::add);
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey());
                    result.add(pair.getValue());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        Collections.addAll(result, (Object[])e);
                    } else {
                        result.add(e);
                    }
                });
                continue;
            }
            if (param instanceof Buffer) {
                result.add(((Buffer)param).getBytes());
                continue;
            }
            if (param == null) continue;
            result.add(param);
        }
        return result;
    }

    private void send(Command command, List arguments, Handler<AsyncResult<Response>> handler) {
        CompletableFuture<Redis> fut;
        Request req = Request.cmd(command);
        if (arguments != null) {
            for (Object o : arguments) {
                if (o == null) {
                    req.nullArg();
                    continue;
                }
                req.arg(o.toString());
            }
        }
        if ((fut = this.redis.get()) == null) {
            CompletableFuture f = new CompletableFuture();
            if (this.redis.compareAndSet(null, f)) {
                fut = f;
                Redis.createClient(this.vertx, new io.vertx.redis.client.RedisOptions().setNetClientOptions(this.options).setConnectionString(this.connectionString)).connect((Handler<AsyncResult<RedisConnection>>)((Handler)onReady -> {
                    if (onReady.succeeded()) {
                        f.complete(onReady.result());
                    } else {
                        f.completeExceptionally(onReady.cause());
                    }
                }));
            } else {
                fut = this.redis.get();
            }
        }
        fut.whenComplete((client, err) -> {
            if (err == null) {
                client.send(req, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)err));
            }
        });
    }

    private void sendString(Command command, List arguments, Handler<AsyncResult<String>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Response)ar.result()).toString()));
            }
        }));
    }

    private static JsonArray toJsonArray(Response response) {
        JsonArray json = new JsonArray();
        for (Response r : response) {
            switch (r.type()) {
                case INTEGER: {
                    json.add(r.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.add(r.toString());
                    break;
                }
                case MULTI: {
                    json.add(RedisSentinelClientImpl.toJsonArray(r));
                }
            }
        }
        return json;
    }

    private void sendJsonArray(Command command, List arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)RedisSentinelClientImpl.toJsonArray((Response)ar.result())));
            }
        }));
    }

    private void sendVoid(Command command, List arguments, Handler<AsyncResult<Void>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        }));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        CompletableFuture prev = this.redis.getAndSet(null);
        if (prev != null) {
            prev.whenComplete((client, err) -> {
                if (err == null) {
                    client.close();
                    if (handler != null) {
                        handler.handle((Object)Future.succeededFuture());
                    }
                } else if (handler != null) {
                    handler.handle((Object)Future.failedFuture((Throwable)err.getCause()));
                }
            });
        }
    }

    @Override
    public RedisSentinel masters(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SENTINEL, RedisSentinelClientImpl.toPayload("MASTERS"), handler);
        return this;
    }

    @Override
    public RedisSentinel master(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SENTINEL, RedisSentinelClientImpl.toPayload("MASTER", name), handler);
        return this;
    }

    @Override
    public RedisSentinel slaves(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SENTINEL, RedisSentinelClientImpl.toPayload("SLAVES", name), handler);
        return this;
    }

    @Override
    public RedisSentinel sentinels(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SENTINEL, RedisSentinelClientImpl.toPayload("SENTINELS", name), handler);
        return this;
    }

    @Override
    public RedisSentinel getMasterAddrByName(String name, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SENTINEL, RedisSentinelClientImpl.toPayload("GET-MASTER-ADDR-BY-NAME", name), handler);
        return this;
    }

    @Override
    public RedisSentinel reset(String pattern, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SENTINEL, RedisSentinelClientImpl.toPayload("RESET", pattern), handler);
        return this;
    }

    @Override
    public RedisSentinel failover(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SENTINEL, RedisSentinelClientImpl.toPayload("FAILOVER", name), handler);
        return this;
    }

    @Override
    public RedisSentinel ckquorum(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SENTINEL, RedisSentinelClientImpl.toPayload("CKQUORUM", name), handler);
        return this;
    }

    @Override
    public RedisSentinel flushConfig(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SENTINEL, RedisSentinelClientImpl.toPayload("FLUSHCONFIG"), handler);
        return this;
    }
}

