/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.RedisClusterClient;
import io.vertx.redis.client.impl.RedisSentinelClient;
import java.util.List;

@VertxGen
public interface Redis {
    public static Redis createClient(Vertx vertx) {
        return Redis.createClient(vertx, new RedisOptions());
    }

    public static Redis createClient(Vertx vertx, String connectionString) {
        return Redis.createClient(vertx, new RedisOptions().setConnectionString(connectionString));
    }

    public static Redis createClient(Vertx vertx, RedisOptions options) {
        switch (options.getType()) {
            case STANDALONE: {
                return new RedisClient(vertx, options);
            }
            case SENTINEL: {
                return new RedisSentinelClient(vertx, options);
            }
            case CLUSTER: {
                return new RedisClusterClient(vertx, options);
            }
        }
        throw new IllegalStateException("Unknown Redis Client type: " + (Object)((Object)options.getType()));
    }

    @Fluent
    public Redis connect(Handler<AsyncResult<RedisConnection>> var1);

    public void close();

    @Fluent
    default public Redis send(Request command, Handler<AsyncResult<@Nullable Response>> onSend) {
        this.connect((Handler<AsyncResult<RedisConnection>>)((Handler)connect -> {
            if (connect.failed()) {
                onSend.handle((Object)Future.failedFuture((Throwable)connect.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)connect.result();
            conn.send(command, (Handler<AsyncResult<Response>>)((Handler)send -> {
                try {
                    onSend.handle(send);
                }
                finally {
                    conn.close();
                }
            }));
        }));
        return this;
    }

    @Fluent
    default public Redis batch(List<Request> commands, Handler<AsyncResult<List<@Nullable Response>>> onSend) {
        this.connect((Handler<AsyncResult<RedisConnection>>)((Handler)connect -> {
            if (connect.failed()) {
                onSend.handle((Object)Future.failedFuture((Throwable)connect.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)connect.result();
            conn.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)batch -> {
                try {
                    onSend.handle(batch);
                }
                finally {
                    conn.close();
                }
            }));
        }));
        return this;
    }
}

