/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.pool.ConnectResult;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.RedisConnectionImpl;
import io.vertx.redis.client.impl.RedisURI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManager.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> LOG.error((Object)"Unhandled Error", t);
    private final Vertx vertx;
    private final NetClient netClient;
    private final RedisOptions options;
    private final Map<String, RedisConnection> connectionMap = new ConcurrentHashMap<String, RedisConnection>();
    private final Map<String, Pool<RedisConnection>> endpointMap = new ConcurrentHashMap<String, Pool<RedisConnection>>();
    private long timerID;

    ConnectionManager(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.netClient = vertx.createNetClient(options.getNetClientOptions());
    }

    synchronized void start() {
        long period = this.options.getPoolCleanerInterval();
        this.timerID = period > 0L ? this.vertx.setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private synchronized void checkExpired(long period) {
        this.endpointMap.values().forEach(Pool::closeIdle);
        this.timerID = this.vertx.setTimer(period, id -> this.checkExpired(period));
    }

    public void getConnection(Context userContext, String connectionString, Request setup, Handler<AsyncResult<RedisConnection>> handler) {
        Pool endpoint;
        RedisConnectionProvider connectionProvider = new RedisConnectionProvider(connectionString, setup);
        while (!(endpoint = this.endpointMap.computeIfAbsent(connectionString, targetAddress -> new Pool(userContext, connectionProvider, this.options.getMaxPoolWaiting(), (long)this.options.getMaxPoolSize(), (long)(this.options.getMaxPoolSize() * this.options.getMaxPoolSize()), v -> this.endpointMap.remove(connectionString), conn -> this.connectionMap.put(connectionString, (RedisConnection)conn), conn -> this.connectionMap.remove(connectionString, conn), false))).getConnection(handler)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.endpointMap.clear();
        for (RedisConnection conn : this.connectionMap.values()) {
            ((RedisConnectionImpl)conn).forceClose();
        }
        this.netClient.close();
    }

    class RedisConnectionProvider
    implements ConnectionProvider<RedisConnection> {
        private final RedisURI redisURI;
        private final Request setup;

        public RedisConnectionProvider(String connectionString, Request setup) {
            this.redisURI = new RedisURI(connectionString);
            this.setup = setup;
        }

        public boolean isValid(RedisConnection conn) {
            return ((RedisConnectionImpl)conn).isValid();
        }

        public void connect(ConnectionListener<RedisConnection> connectionListener, ContextInternal ctx, Handler<AsyncResult<ConnectResult<RedisConnection>>> onConnect) {
            ConnectionManager.this.netClient.connect(this.redisURI.socketAddress(), clientConnect -> {
                if (clientConnect.failed()) {
                    ctx.runOnContext(v -> onConnect.handle((Object)Future.failedFuture((Throwable)clientConnect.cause())));
                    return;
                }
                NetSocket netSocket = (NetSocket)clientConnect.result();
                RedisConnectionImpl connection = new RedisConnectionImpl(ConnectionManager.this.vertx, ctx, connectionListener, netSocket, ConnectionManager.this.options);
                netSocket.handler((Handler)new RESPParser(connection, ConnectionManager.this.options.getMaxNestedArrays())).closeHandler(connection::end).exceptionHandler(connection::fatal);
                this.authenticate(connection, this.redisURI.user(), this.redisURI.password(), (Handler<AsyncResult<Void>>)((Handler)authenticate -> {
                    if (authenticate.failed()) {
                        ctx.runOnContext(v -> onConnect.handle((Object)Future.failedFuture((Throwable)authenticate.cause())));
                        return;
                    }
                    this.select(connection, this.redisURI.select(), (Handler<AsyncResult<Void>>)((Handler)select -> {
                        if (select.failed()) {
                            ctx.runOnContext(v -> onConnect.handle((Object)Future.failedFuture((Throwable)select.cause())));
                            return;
                        }
                        this.setup(connection, this.setup, (Handler<AsyncResult<Void>>)((Handler)setupResult -> {
                            if (setupResult.failed()) {
                                ctx.runOnContext(v -> onConnect.handle((Object)Future.failedFuture((Throwable)setupResult.cause())));
                                return;
                            }
                            connection.handler((Handler)null);
                            connection.endHandler((Handler)null);
                            connection.exceptionHandler(DEFAULT_EXCEPTION_HANDLER);
                            ctx.runOnContext(v -> onConnect.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)connection, 1L, (long)ConnectionManager.this.options.getMaxPoolSize()))));
                        }));
                    }));
                }));
            });
        }

        private void authenticate(RedisConnection connection, String user, String password, Handler<AsyncResult<Void>> handler) {
            if (password == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            Request request = Request.cmd(Command.AUTH);
            if (user != null) {
                request.arg(user);
            }
            request.arg(password);
            connection.send(request, (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        private void select(RedisConnection connection, Integer select, Handler<AsyncResult<Void>> handler) {
            if (select == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            connection.send(Request.cmd(Command.SELECT).arg(select), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        private void setup(RedisConnection connection, Request setup, Handler<AsyncResult<Void>> handler) {
            if (setup == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            connection.send(setup, (Handler<AsyncResult<Response>>)((Handler)req -> {
                if (req.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)req.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        public void close(RedisConnection connection) {
            connection.handler((Handler)null);
            connection.endHandler((Handler)null);
            connection.exceptionHandler((Handler)null);
            ((RedisConnectionImpl)connection).forceClose();
        }
    }
}

