/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class MultiType
implements Response {
    public static final MultiType EMPTY = new MultiType(new Response[0]);
    private final Response[] replies;
    private int count;

    public static MultiType create(int length) {
        return new MultiType(length);
    }

    public static MultiType create(Response[] replies) {
        return new MultiType(replies);
    }

    private MultiType(int length) {
        this.replies = new Response[length];
        this.count = 0;
    }

    private MultiType(Response[] replies) {
        this.replies = replies;
        this.count = replies.length;
    }

    @Override
    public ResponseType type() {
        return ResponseType.MULTI;
    }

    public void add(Response reply) {
        this.replies[this.count++] = reply;
    }

    public boolean complete() {
        return this.count == this.replies.length;
    }

    @Override
    public Response get(int index) {
        return this.replies[index];
    }

    @Override
    public Response get(String key) {
        if (this.replies.length % 2 == 0) {
            for (int i = 0; i < this.replies.length; i += 2) {
                if (!key.equals(this.replies[i].toString())) continue;
                return this.replies[i + 1];
            }
        }
        throw new RuntimeException("Number of key is not even");
    }

    @Override
    public Set<String> getKeys() {
        if (this.replies.length % 2 == 0) {
            HashSet<String> keys = new HashSet<String>();
            for (int i = 0; i < this.replies.length; i += 2) {
                keys.add(this.replies[i].toString());
            }
            return keys;
        }
        throw new RuntimeException("Number of key is not even");
    }

    @Override
    public int size() {
        return this.replies.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean more = false;
        for (Response r : this.replies) {
            if (more) {
                sb.append(", ");
            }
            if (r == null) {
                sb.append("null");
            } else {
                sb.append(r.toString());
            }
            more = true;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Response> iterator() {
        return new Iterator<Response>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < MultiType.this.replies.length;
            }

            @Override
            public Response next() {
                return MultiType.this.replies[this.idx++];
            }
        };
    }
}

