/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.clientconnection.ConnectResult;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.net.impl.clientconnection.ConnectionManager;
import io.vertx.core.net.impl.clientconnection.ConnectionProvider;
import io.vertx.core.net.impl.clientconnection.Endpoint;
import io.vertx.core.net.impl.clientconnection.Pool;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.RedisStandaloneConnection;
import io.vertx.redis.client.impl.RedisURI;
import java.util.Objects;

class RedisConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnectionManager.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> LOG.error((Object)"Unhandled Error", t);
    private final VertxInternal vertx;
    private final NetClient netClient;
    private final RedisOptions options;
    private final ConnectionManager<ConnectionKey, RedisConnection> pooledConnectionManager;
    private long timerID;

    RedisConnectionManager(VertxInternal vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.netClient = vertx.createNetClient(options.getNetClientOptions());
        this.pooledConnectionManager = new ConnectionManager(this::connectionEndpointProvider);
    }

    private Endpoint<RedisConnection> connectionEndpointProvider(ConnectionKey key, ContextInternal ctx, Runnable dispose) {
        return new RedisEndpoint(dispose, ctx, key);
    }

    synchronized void start() {
        long period = this.options.getPoolCleanerInterval();
        this.timerID = period > 0L ? this.vertx.setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private void checkExpired(long period) {
        this.pooledConnectionManager.forEach(e -> ((RedisEndpoint)e).pool.closeIdle());
        this.timerID = this.vertx.setTimer(period, id -> this.checkExpired(period));
    }

    public Future<RedisConnection> getConnection(String connectionString, Request setup) {
        PromiseInternal promise = this.vertx.promise();
        ContextInternal ctx = promise.context();
        EventLoopContext eventLoopContext = ctx instanceof EventLoopContext ? (EventLoopContext)ctx : this.vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        this.pooledConnectionManager.getConnection(eventLoopContext, (Object)new ConnectionKey(connectionString, setup), (Handler)promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RedisConnectionManager redisConnectionManager = this;
        synchronized (redisConnectionManager) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.pooledConnectionManager.close();
        this.netClient.close();
    }

    private class RedisEndpoint
    extends Endpoint<RedisConnection> {
        final Pool<RedisConnection> pool;

        public RedisEndpoint(Runnable dispose, ContextInternal ctx, ConnectionKey key) {
            super(dispose);
            RedisConnectionProvider connectionProvider = new RedisConnectionProvider(key.string, key.setup);
            this.pool = new Pool((Context)ctx, (ConnectionProvider)connectionProvider, RedisConnectionManager.this.options.getMaxPoolWaiting(), 1L, (long)RedisConnectionManager.this.options.getMaxPoolSize(), arg_0 -> ((RedisEndpoint)this).connectionAdded(arg_0), arg_0 -> ((RedisEndpoint)this).connectionRemoved(arg_0), false);
        }

        public void requestConnection(ContextInternal ctx, Handler<AsyncResult<RedisConnection>> handler) {
            this.pool.getConnection(handler);
        }

        protected void close(RedisConnection conn) {
            ((RedisStandaloneConnection)conn).forceClose();
        }
    }

    class RedisConnectionProvider
    implements ConnectionProvider<RedisConnection> {
        private final RedisURI redisURI;
        private final Request setup;

        public RedisConnectionProvider(String connectionString, Request setup) {
            this.redisURI = new RedisURI(connectionString);
            this.setup = setup;
        }

        public boolean isValid(RedisConnection conn) {
            return ((RedisStandaloneConnection)conn).isValid();
        }

        public void init(RedisConnection conn) {
        }

        public void connect(ConnectionListener<RedisConnection> connectionListener, ContextInternal ctx, Handler<AsyncResult<ConnectResult<RedisConnection>>> onConnect) {
            boolean netClientSsl = RedisConnectionManager.this.options.getNetClientOptions().isSsl();
            boolean connectionStringSsl = this.redisURI.ssl();
            boolean connectionStringInetSocket = this.redisURI.socketAddress().isInetSocket();
            if (connectionStringInetSocket && netClientSsl && !connectionStringSsl) {
                onConnect.handle((Object)Future.failedFuture((String)"Pool initialized with SSL but connection requested plain socket"));
                return;
            }
            RedisConnectionManager.this.netClient.connect(this.redisURI.socketAddress(), clientConnect -> {
                if (clientConnect.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)clientConnect.cause()), onConnect);
                    return;
                }
                NetSocket netSocket = (NetSocket)clientConnect.result();
                Handler completeConnection = v -> {
                    RedisStandaloneConnection connection = new RedisStandaloneConnection((Vertx)RedisConnectionManager.this.vertx, ctx, connectionListener, netSocket, RedisConnectionManager.this.options);
                    netSocket.handler((Handler)new RESPParser(connection, RedisConnectionManager.this.options.getMaxNestedArrays())).closeHandler(connection::end).exceptionHandler(connection::fatal);
                    this.hello(connection, this.redisURI, (Handler<AsyncResult<Void>>)((Handler)hello -> {
                        if (hello.failed()) {
                            ctx.execute((Object)Future.failedFuture((Throwable)hello.cause()), onConnect);
                            return;
                        }
                        this.select(connection, this.redisURI.select(), (Handler<AsyncResult<Void>>)((Handler)select -> {
                            if (select.failed()) {
                                ctx.execute((Object)Future.failedFuture((Throwable)select.cause()), onConnect);
                                return;
                            }
                            this.setup(connection, this.setup, (Handler<AsyncResult<Void>>)((Handler)setupResult -> {
                                if (setupResult.failed()) {
                                    ctx.execute((Object)Future.failedFuture((Throwable)setupResult.cause()), onConnect);
                                    return;
                                }
                                connection.handler((Handler)null);
                                connection.endHandler((Handler)null);
                                connection.exceptionHandler(DEFAULT_EXCEPTION_HANDLER);
                                ctx.execute((Object)Future.succeededFuture((Object)new ConnectResult((Object)connection, 1L, 1L)), onConnect);
                            }));
                        }));
                    }));
                };
                if (connectionStringInetSocket && !netClientSsl && connectionStringSsl) {
                    netSocket.upgradeToSsl(upgradeToSsl -> {
                        if (upgradeToSsl.failed()) {
                            onConnect.handle((Object)Future.failedFuture((Throwable)upgradeToSsl.cause()));
                        } else {
                            completeConnection.handle(null);
                        }
                    });
                } else {
                    completeConnection.handle(null);
                }
            });
        }

        private void hello(RedisConnection connection, RedisURI redisURI, Handler<AsyncResult<Void>> handler) {
            String client;
            String password;
            Request hello = Request.cmd(Command.HELLO).arg("3");
            String string = password = redisURI.password() != null ? redisURI.password() : RedisConnectionManager.this.options.getPassword();
            if (password != null) {
                String user = redisURI.user();
                hello.arg("AUTH").arg(user == null ? "default" : user).arg(password);
            }
            if ((client = redisURI.param("client")) != null) {
                hello.arg("SETNAME").arg(client);
            }
            connection.send(hello, (Handler<AsyncResult<Response>>)((Handler)onSend -> {
                if (onSend.succeeded()) {
                    LOG.debug(onSend.result());
                    handler.handle((Object)Future.succeededFuture());
                    return;
                }
                Throwable err = onSend.cause();
                if (err != null && err.getMessage() != null && err.getMessage().startsWith("ERR unknown command")) {
                    this.authenticate(connection, password, handler);
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)err));
                }
            }));
        }

        private void authenticate(RedisConnection connection, String password, Handler<AsyncResult<Void>> handler) {
            if (password == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            connection.send(Request.cmd(Command.AUTH).arg(password), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        private void select(RedisConnection connection, Integer select, Handler<AsyncResult<Void>> handler) {
            if (select == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            connection.send(Request.cmd(Command.SELECT).arg(select), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        private void setup(RedisConnection connection, Request setup, Handler<AsyncResult<Void>> handler) {
            if (setup == null) {
                handler.handle((Object)Future.succeededFuture());
                return;
            }
            connection.send(setup, (Handler<AsyncResult<Response>>)((Handler)req -> {
                if (req.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)req.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture());
                }
            }));
        }

        public void close(RedisConnection connection) {
            connection.handler((Handler)null);
            connection.endHandler((Handler)null);
            connection.exceptionHandler((Handler)null);
            ((RedisStandaloneConnection)connection).forceClose();
        }
    }

    private static class ConnectionKey {
        private final String string;
        private final Request setup;

        ConnectionKey(String string, Request setup) {
            this.string = string;
            this.setup = setup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            return Objects.equals(this.string, that.string);
        }

        public int hashCode() {
            return Objects.hash(this.string);
        }
    }
}

