/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.RESPEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RequestImpl
implements Request {
    private static final byte[] EMPTY_BULK = "$0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] NULL_BULK = "$-1\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EOL = "\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRUE = new byte[]{116};
    private static final byte[] FALSE = new byte[]{102};
    private final Command cmd;
    private final List<byte[]> args;

    public RequestImpl(Command cmd) {
        this.cmd = cmd;
        this.args = cmd.getArity() != 0 ? new ArrayList<byte[]>(Math.abs(cmd.getArity())) : Collections.emptyList();
    }

    @Override
    public Command command() {
        return this.cmd;
    }

    @Override
    public Request arg(long arg) {
        this.args.add(RESPEncoder.numToBytes(arg));
        return this;
    }

    @Override
    public Request arg(boolean arg) {
        this.arg(arg ? TRUE : FALSE);
        return this;
    }

    @Override
    public Request nullArg() {
        this.args.add(null);
        return this;
    }

    @Override
    public Request arg(byte[] arg) {
        if (arg == null) {
            return this.nullArg();
        }
        this.args.add(arg);
        return this;
    }

    @Override
    public Request arg(Buffer arg) {
        if (arg == null) {
            return this.nullArg();
        }
        if (arg.length() == 0) {
            this.args.add(EMPTY_BYTES);
            return this;
        }
        this.args.add(arg.getBytes());
        return this;
    }

    Buffer encode() {
        return this.encode(Buffer.buffer());
    }

    Buffer encode(Buffer buffer) {
        buffer.appendByte((byte)42).appendBytes(RESPEncoder.numToBytes(this.args.size() + 1)).appendBytes(EOL).appendBytes(this.cmd.getBytes());
        for (byte[] arg : this.args) {
            if (arg == null) {
                buffer.appendBytes(NULL_BULK);
                continue;
            }
            if (arg.length == 0) {
                buffer.appendBytes(EMPTY_BULK);
                continue;
            }
            buffer.appendByte((byte)36).appendBytes(RESPEncoder.numToBytes(arg.length)).appendBytes(EOL).appendBytes(arg).appendBytes(EOL);
        }
        return buffer;
    }

    List<byte[]> getArgs() {
        return this.args;
    }

    public String toString() {
        return this.encode().toString();
    }
}

