/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptionsConverter;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.impl.RedisURI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RedisOptions {
    public static final String DEFAULT_ENDPOINT = "redis://localhost:6379";
    private RedisClientType type;
    private NetClientOptions netClientOptions;
    private List<String> endpoints;
    private int maxWaitingHandlers;
    private int maxNestedArrays;
    private String masterName;
    private RedisRole role;
    private RedisReplicas useReplicas;
    private volatile String password;
    private int poolCleanerInterval;
    private int maxPoolSize;
    private int maxPoolWaiting;
    private int poolRecycleTimeout;

    private void init() {
        this.netClientOptions = new NetClientOptions().setTcpKeepAlive(true).setTcpNoDelay(true);
        this.maxWaitingHandlers = 2048;
        this.maxNestedArrays = 32;
        this.masterName = "mymaster";
        this.role = RedisRole.MASTER;
        this.useReplicas = RedisReplicas.NEVER;
        this.type = RedisClientType.STANDALONE;
        this.poolCleanerInterval = -1;
        this.maxPoolSize = 6;
        this.maxPoolWaiting = 24;
        this.poolRecycleTimeout = 15000;
    }

    public RedisOptions() {
        this.init();
    }

    public RedisOptions(RedisOptions other) {
        this.type = other.type;
        this.netClientOptions = other.netClientOptions;
        this.endpoints = other.endpoints;
        this.maxWaitingHandlers = other.maxWaitingHandlers;
        this.maxNestedArrays = other.maxNestedArrays;
        this.masterName = other.masterName;
        this.role = other.role;
        this.useReplicas = other.useReplicas;
        this.poolCleanerInterval = other.poolCleanerInterval;
        this.maxPoolSize = other.maxPoolSize;
        this.maxPoolWaiting = other.maxPoolWaiting;
        this.poolRecycleTimeout = other.poolRecycleTimeout;
        this.password = other.password;
    }

    public RedisOptions(JsonObject json) {
        this.init();
        RedisOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisClientType getType() {
        return this.type;
    }

    public RedisOptions setType(RedisClientType type) {
        this.type = type;
        return this;
    }

    public NetClientOptions getNetClientOptions() {
        return this.netClientOptions;
    }

    public RedisOptions setNetClientOptions(NetClientOptions netClientOptions) {
        this.netClientOptions = netClientOptions;
        return this;
    }

    public List<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
            this.endpoints.add(DEFAULT_ENDPOINT);
        }
        return this.endpoints;
    }

    public String getEndpoint() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            return DEFAULT_ENDPOINT;
        }
        return this.endpoints.get(0);
    }

    public RedisOptions setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Deprecated
    public RedisOptions addEndpoint(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    @Deprecated
    public RedisOptions setEndpoint(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public RedisOptions addConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public RedisOptions setConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public int getMaxWaitingHandlers() {
        return this.maxWaitingHandlers;
    }

    public RedisOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        this.maxWaitingHandlers = maxWaitingHandlers;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisRole getRole() {
        return this.role;
    }

    public RedisOptions setRole(RedisRole role) {
        this.role = role;
        return this;
    }

    public RedisReplicas getUseReplicas() {
        return this.useReplicas;
    }

    public RedisOptions setUseReplicas(RedisReplicas useReplicas) {
        this.useReplicas = useReplicas;
        return this;
    }

    public int getMaxNestedArrays() {
        return this.maxNestedArrays;
    }

    public RedisOptions setMaxNestedArrays(int maxNestedArrays) {
        this.maxNestedArrays = maxNestedArrays;
        return this;
    }

    public int getPoolCleanerInterval() {
        return this.poolCleanerInterval;
    }

    public RedisOptions setPoolCleanerInterval(int poolCleanerInterval) {
        this.poolCleanerInterval = poolCleanerInterval;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public RedisOptions setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getMaxPoolWaiting() {
        return this.maxPoolWaiting;
    }

    public RedisOptions setMaxPoolWaiting(int maxPoolWaiting) {
        this.maxPoolWaiting = maxPoolWaiting;
        return this;
    }

    public int getPoolRecycleTimeout() {
        return this.poolRecycleTimeout;
    }

    public RedisOptions setPoolRecycleTimeout(int poolRecycleTimeout) {
        this.poolRecycleTimeout = poolRecycleTimeout;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        if (this.password == null) {
            RedisOptions redisOptions = this;
            synchronized (redisOptions) {
                if (this.password == null) {
                    RedisURI uri = new RedisURI(this.getEndpoint());
                    this.password = uri.password();
                }
            }
        }
        return this.password;
    }

    public synchronized RedisOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisOptionsConverter.toJson(this, json);
        return json;
    }
}

