/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;

public final class ErrorType
extends Throwable
implements Response {
    private final String kind;

    public static ErrorType create(String message) {
        return new ErrorType(message);
    }

    private ErrorType(String message) {
        super(message, null, false, false);
        if (message != null) {
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != ' ') continue;
                this.kind = message.substring(0, i);
                return;
            }
        }
        this.kind = null;
    }

    @Override
    public ResponseType type() {
        return ResponseType.ERROR;
    }

    public boolean is(String kind) {
        if (this.kind == null) {
            return kind == null;
        }
        return this.kind.equalsIgnoreCase(kind);
    }

    public String getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String slice(char sep, int index) {
        String message = this.getMessage();
        if (message == null) {
            return null;
        }
        int start = 0;
        int count = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) != sep) continue;
            if (++count > index) {
                return message.substring(start, i);
            }
            start = i + 1;
        }
        if (count == index) {
            return message.substring(start);
        }
        return null;
    }
}

