/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.List;

public class PooledRedisConnection
implements RedisConnection {
    private final Lease<RedisConnection> lease;
    private final RedisConnection connection;
    private final PoolMetrics metrics;
    private final Object metric;

    public PooledRedisConnection(Lease<RedisConnection> lease, PoolMetrics<?> poolMetrics, Object metric) {
        this.lease = lease;
        this.connection = (RedisConnection)lease.get();
        this.metrics = poolMetrics;
        this.metric = metric;
    }

    public RedisConnection actual() {
        return this.connection;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.connection.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.connection.handler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.connection.resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.connection.fetch(amount);
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
        this.connection.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        return this.connection.send(command);
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        return this.connection.batch(commands);
    }

    @Override
    public void close() {
        this.lease.recycle();
        if (this.metrics != null) {
            this.metrics.end(this.metric, true);
        }
    }

    @Override
    public boolean pendingQueueFull() {
        return this.connection.pendingQueueFull();
    }
}

