/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.redis.client.impl.CommandImpl;

@VertxGen
public interface Command {
    public static final Command ACL = Command.create("acl", -2, 0, 0, 0, false, false, false, false);
    public static final Command APPEND = Command.create("append", 3, 1, 1, 1, true, false, false, false);
    public static final Command ASKING = Command.create("asking", 1, 0, 0, 0, false, false, false, false);
    public static final Command AUTH = Command.create("auth", -2, 0, 0, 0, false, false, false, false);
    public static final Command BGREWRITEAOF = Command.create("bgrewriteaof", 1, 0, 0, 0, false, false, false, false);
    public static final Command BGSAVE = Command.create("bgsave", -1, 0, 0, 0, false, false, false, false);
    public static final Command BITCOUNT = Command.create("bitcount", -2, 1, 1, 1, false, true, false, false);
    public static final Command BITFIELD = Command.create("bitfield", -2, 1, 1, 1, true, false, false, false);
    public static final Command BITFIELD_RO = Command.create("bitfield_ro", -2, 1, 1, 1, false, true, false, false);
    public static final Command BITOP = Command.create("bitop", -4, 2, -1, 1, true, false, false, false);
    public static final Command BITPOS = Command.create("bitpos", -3, 1, 1, 1, false, true, false, false);
    public static final Command BLPOP = Command.create("blpop", -3, 1, -2, 1, true, false, false, false);
    public static final Command BRPOP = Command.create("brpop", -3, 1, -2, 1, true, false, false, false);
    public static final Command BRPOPLPUSH = Command.create("brpoplpush", 4, 1, 2, 1, true, false, false, false);
    public static final Command BZPOPMAX = Command.create("bzpopmax", -3, 1, -2, 1, true, false, false, false);
    public static final Command BZPOPMIN = Command.create("bzpopmin", -3, 1, -2, 1, true, false, false, false);
    public static final Command CLIENT = Command.create("client", -2, 0, 0, 0, false, false, false, false);
    public static final Command CLUSTER = Command.create("cluster", -2, 0, 0, 0, false, false, false, false);
    public static final Command COMMAND = Command.create("command", -1, 0, 0, 0, false, false, false, false);
    public static final Command CONFIG = Command.create("config", -2, 0, 0, 0, false, false, false, false);
    public static final Command DBSIZE = Command.create("dbsize", 1, 0, 0, 0, false, true, false, false);
    public static final Command DEBUG = Command.create("debug", -2, 0, 0, 0, false, false, false, false);
    public static final Command DECR = Command.create("decr", 2, 1, 1, 1, true, false, false, false);
    public static final Command DECRBY = Command.create("decrby", 3, 1, 1, 1, true, false, false, false);
    public static final Command DEL = Command.create("del", -2, 1, -1, 1, true, false, false, false);
    public static final Command DISCARD = Command.create("discard", 1, 0, 0, 0, false, false, false, false);
    public static final Command DUMP = Command.create("dump", 2, 1, 1, 1, false, true, false, false);
    public static final Command ECHO = Command.create("echo", 2, 0, 0, 0, false, true, false, false);
    public static final Command EVAL = Command.create("eval", -3, 0, 0, 0, false, false, true, false);
    public static final Command EVALSHA = Command.create("evalsha", -3, 0, 0, 0, false, false, true, false);
    public static final Command EXEC = Command.create("exec", 1, 0, 0, 0, false, false, false, false);
    public static final Command EXISTS = Command.create("exists", -2, 1, -1, 1, false, true, false, false);
    public static final Command EXPIRE = Command.create("expire", 3, 1, 1, 1, true, false, false, false);
    public static final Command EXPIREAT = Command.create("expireat", 3, 1, 1, 1, true, false, false, false);
    public static final Command FLUSHALL = Command.create("flushall", -1, 0, 0, 0, true, false, false, false);
    public static final Command FLUSHDB = Command.create("flushdb", -1, 0, 0, 0, true, false, false, false);
    public static final Command GEOADD = Command.create("geoadd", -5, 1, 1, 1, true, false, false, false);
    public static final Command GEODIST = Command.create("geodist", -4, 1, 1, 1, false, true, false, false);
    public static final Command GEOHASH = Command.create("geohash", -2, 1, 1, 1, false, true, false, false);
    public static final Command GEOPOS = Command.create("geopos", -2, 1, 1, 1, false, true, false, false);
    public static final Command GEORADIUS = Command.create("georadius", -6, 1, 1, 1, true, false, true, false);
    public static final Command GEORADIUS_RO = Command.create("georadius_ro", -6, 1, 1, 1, false, true, true, false);
    public static final Command GEORADIUSBYMEMBER = Command.create("georadiusbymember", -5, 1, 1, 1, true, false, true, false);
    public static final Command GEORADIUSBYMEMBER_RO = Command.create("georadiusbymember_ro", -5, 1, 1, 1, false, true, true, false);
    public static final Command GET = Command.create("get", 2, 1, 1, 1, false, true, false, false);
    public static final Command GETBIT = Command.create("getbit", 3, 1, 1, 1, false, true, false, false);
    public static final Command GETRANGE = Command.create("getrange", 4, 1, 1, 1, false, true, false, false);
    public static final Command GETSET = Command.create("getset", 3, 1, 1, 1, true, false, false, false);
    public static final Command HDEL = Command.create("hdel", -3, 1, 1, 1, true, false, false, false);
    public static final Command HELLO = Command.create("hello", -2, 0, 0, 0, false, false, false, false);
    public static final Command HEXISTS = Command.create("hexists", 3, 1, 1, 1, false, true, false, false);
    public static final Command HGET = Command.create("hget", 3, 1, 1, 1, false, true, false, false);
    public static final Command HGETALL = Command.create("hgetall", 2, 1, 1, 1, false, true, false, false);
    public static final Command HINCRBY = Command.create("hincrby", 4, 1, 1, 1, true, false, false, false);
    public static final Command HINCRBYFLOAT = Command.create("hincrbyfloat", 4, 1, 1, 1, true, false, false, false);
    public static final Command HKEYS = Command.create("hkeys", 2, 1, 1, 1, false, true, false, false);
    public static final Command HLEN = Command.create("hlen", 2, 1, 1, 1, false, true, false, false);
    public static final Command HMGET = Command.create("hmget", -3, 1, 1, 1, false, true, false, false);
    public static final Command HMSET = Command.create("hmset", -4, 1, 1, 1, true, false, false, false);
    public static final Command HOST = Command.create("host:", -1, 0, 0, 0, false, true, false, false);
    public static final Command HSCAN = Command.create("hscan", -3, 1, 1, 1, false, true, false, false);
    public static final Command HSET = Command.create("hset", -4, 1, 1, 1, true, false, false, false);
    public static final Command HSETNX = Command.create("hsetnx", 4, 1, 1, 1, true, false, false, false);
    public static final Command HSTRLEN = Command.create("hstrlen", 3, 1, 1, 1, false, true, false, false);
    public static final Command HVALS = Command.create("hvals", 2, 1, 1, 1, false, true, false, false);
    public static final Command INCR = Command.create("incr", 2, 1, 1, 1, true, false, false, false);
    public static final Command INCRBY = Command.create("incrby", 3, 1, 1, 1, true, false, false, false);
    public static final Command INCRBYFLOAT = Command.create("incrbyfloat", 3, 1, 1, 1, true, false, false, false);
    public static final Command INFO = Command.create("info", -1, 0, 0, 0, false, false, false, false);
    public static final Command KEYS = Command.create("keys", 2, 0, 0, 0, false, true, false, false);
    public static final Command LASTSAVE = Command.create("lastsave", 1, 0, 0, 0, false, true, false, false);
    public static final Command LATENCY = Command.create("latency", -2, 0, 0, 0, false, false, false, false);
    public static final Command LINDEX = Command.create("lindex", 3, 1, 1, 1, false, true, false, false);
    public static final Command LINSERT = Command.create("linsert", 5, 1, 1, 1, true, false, false, false);
    public static final Command LLEN = Command.create("llen", 2, 1, 1, 1, false, true, false, false);
    public static final Command LOLWUT = Command.create("lolwut", -1, 0, 0, 0, false, true, false, false);
    public static final Command LPOP = Command.create("lpop", 2, 1, 1, 1, true, false, false, false);
    public static final Command LPUSH = Command.create("lpush", -3, 1, 1, 1, true, false, false, false);
    public static final Command LPUSHX = Command.create("lpushx", -3, 1, 1, 1, true, false, false, false);
    public static final Command LRANGE = Command.create("lrange", 4, 1, 1, 1, false, true, false, false);
    public static final Command LREM = Command.create("lrem", 4, 1, 1, 1, true, false, false, false);
    public static final Command LSET = Command.create("lset", 4, 1, 1, 1, true, false, false, false);
    public static final Command LTRIM = Command.create("ltrim", 4, 1, 1, 1, true, false, false, false);
    public static final Command MEMORY = Command.create("memory", -2, 0, 0, 0, false, true, true, false);
    public static final Command MGET = Command.create("mget", -2, 1, -1, 1, false, true, false, false);
    public static final Command MIGRATE = Command.create("migrate", -6, 0, 0, 0, true, false, true, false);
    public static final Command MODULE = Command.create("module", -2, 0, 0, 0, false, false, false, false);
    public static final Command MONITOR = Command.create("monitor", 1, 0, 0, 0, false, false, false, false);
    public static final Command MOVE = Command.create("move", 3, 1, 1, 1, true, false, false, false);
    public static final Command MSET = Command.create("mset", -3, 1, -1, 2, true, false, false, false);
    public static final Command MSETNX = Command.create("msetnx", -3, 1, -1, 2, true, false, false, false);
    public static final Command MULTI = Command.create("multi", 1, 0, 0, 0, false, false, false, false);
    public static final Command OBJECT = Command.create("object", -2, 2, 2, 1, false, true, false, false);
    public static final Command PERSIST = Command.create("persist", 2, 1, 1, 1, true, false, false, false);
    public static final Command PEXPIRE = Command.create("pexpire", 3, 1, 1, 1, true, false, false, false);
    public static final Command PEXPIREAT = Command.create("pexpireat", 3, 1, 1, 1, true, false, false, false);
    public static final Command PFADD = Command.create("pfadd", -2, 1, 1, 1, true, false, false, false);
    public static final Command PFCOUNT = Command.create("pfcount", -2, 1, -1, 1, false, true, false, false);
    public static final Command PFDEBUG = Command.create("pfdebug", -3, 0, 0, 0, true, false, false, false);
    public static final Command PFMERGE = Command.create("pfmerge", -2, 1, -1, 1, true, false, false, false);
    public static final Command PFSELFTEST = Command.create("pfselftest", 1, 0, 0, 0, false, false, false, false);
    public static final Command PING = Command.create("ping", -1, 0, 0, 0, false, false, false, false);
    public static final Command POST = Command.create("post", -1, 0, 0, 0, false, true, false, false);
    public static final Command PSETEX = Command.create("psetex", 4, 1, 1, 1, true, false, false, false);
    public static final Command PSUBSCRIBE = Command.create("psubscribe", -2, 0, 0, 0, false, false, false, true);
    public static final Command PSYNC = Command.create("psync", 3, 0, 0, 0, false, false, false, false);
    public static final Command PTTL = Command.create("pttl", 2, 1, 1, 1, false, true, false, false);
    public static final Command PUBLISH = Command.create("publish", 3, 0, 0, 0, false, false, false, false);
    public static final Command PUBSUB = Command.create("pubsub", -2, 0, 0, 0, false, false, false, false);
    public static final Command PUNSUBSCRIBE = Command.create("punsubscribe", -1, 0, 0, 0, false, false, false, true);
    public static final Command RANDOMKEY = Command.create("randomkey", 1, 0, 0, 0, false, true, false, false);
    public static final Command READONLY = Command.create("readonly", 1, 0, 0, 0, false, false, false, false);
    public static final Command READWRITE = Command.create("readwrite", 1, 0, 0, 0, false, false, false, false);
    public static final Command RENAME = Command.create("rename", 3, 1, 2, 1, true, false, false, false);
    public static final Command RENAMENX = Command.create("renamenx", 3, 1, 2, 1, true, false, false, false);
    public static final Command REPLCONF = Command.create("replconf", -1, 0, 0, 0, false, false, false, false);
    public static final Command REPLICAOF = Command.create("replicaof", 3, 0, 0, 0, false, false, false, false);
    public static final Command RESTORE = Command.create("restore", -4, 1, 1, 1, true, false, false, false);
    public static final Command RESTORE_ASKING = Command.create("restore-asking", -4, 1, 1, 1, true, false, false, false);
    public static final Command ROLE = Command.create("role", 1, 0, 0, 0, false, true, false, false);
    public static final Command RPOP = Command.create("rpop", 2, 1, 1, 1, true, false, false, false);
    public static final Command RPOPLPUSH = Command.create("rpoplpush", 3, 1, 2, 1, true, false, false, false);
    public static final Command RPUSH = Command.create("rpush", -3, 1, 1, 1, true, false, false, false);
    public static final Command RPUSHX = Command.create("rpushx", -3, 1, 1, 1, true, false, false, false);
    public static final Command SADD = Command.create("sadd", -3, 1, 1, 1, true, false, false, false);
    public static final Command SAVE = Command.create("save", 1, 0, 0, 0, false, false, false, false);
    public static final Command SCAN = Command.create("scan", -2, 0, 0, 0, false, true, false, false);
    public static final Command SCARD = Command.create("scard", 2, 1, 1, 1, false, true, false, false);
    public static final Command SCRIPT = Command.create("script", -2, 0, 0, 0, false, false, false, false);
    public static final Command SDIFF = Command.create("sdiff", -2, 1, -1, 1, false, true, false, false);
    public static final Command SDIFFSTORE = Command.create("sdiffstore", -3, 1, -1, 1, true, false, false, false);
    public static final Command SELECT = Command.create("select", 2, 0, 0, 0, false, false, false, false);
    public static final Command SET = Command.create("set", -3, 1, 1, 1, true, false, false, false);
    public static final Command SETBIT = Command.create("setbit", 4, 1, 1, 1, true, false, false, false);
    public static final Command SETEX = Command.create("setex", 4, 1, 1, 1, true, false, false, false);
    public static final Command SETNX = Command.create("setnx", 3, 1, 1, 1, true, false, false, false);
    public static final Command SETRANGE = Command.create("setrange", 4, 1, 1, 1, true, false, false, false);
    public static final Command SHUTDOWN = Command.create("shutdown", -1, 0, 0, 0, false, false, false, false);
    public static final Command SINTER = Command.create("sinter", -2, 1, -1, 1, false, true, false, false);
    public static final Command SINTERSTORE = Command.create("sinterstore", -3, 1, -1, 1, true, false, false, false);
    public static final Command SISMEMBER = Command.create("sismember", 3, 1, 1, 1, false, true, false, false);
    public static final Command SLAVEOF = Command.create("slaveof", 3, 0, 0, 0, false, false, false, false);
    public static final Command SLOWLOG = Command.create("slowlog", -2, 0, 0, 0, false, false, false, false);
    public static final Command SMEMBERS = Command.create("smembers", 2, 1, 1, 1, false, true, false, false);
    public static final Command SMOVE = Command.create("smove", 4, 1, 2, 1, true, false, false, false);
    public static final Command SORT = Command.create("sort", -2, 1, 1, 1, true, false, true, false);
    public static final Command SPOP = Command.create("spop", -2, 1, 1, 1, true, false, false, false);
    public static final Command SRANDMEMBER = Command.create("srandmember", -2, 1, 1, 1, false, true, false, false);
    public static final Command SREM = Command.create("srem", -3, 1, 1, 1, true, false, false, false);
    public static final Command SSCAN = Command.create("sscan", -3, 1, 1, 1, false, true, false, false);
    public static final Command STRALGO = Command.create("stralgo", -2, 0, 0, 0, false, true, true, false);
    public static final Command STRLEN = Command.create("strlen", 2, 1, 1, 1, false, true, false, false);
    public static final Command SUBSCRIBE = Command.create("subscribe", -2, 0, 0, 0, false, false, false, true);
    public static final Command SUBSTR = Command.create("substr", 4, 1, 1, 1, false, true, false, false);
    public static final Command SUNION = Command.create("sunion", -2, 1, -1, 1, false, true, false, false);
    public static final Command SUNIONSTORE = Command.create("sunionstore", -3, 1, -1, 1, true, false, false, false);
    public static final Command SWAPDB = Command.create("swapdb", 3, 0, 0, 0, true, false, false, false);
    public static final Command SYNC = Command.create("sync", 1, 0, 0, 0, false, false, false, false);
    public static final Command TIME = Command.create("time", 1, 0, 0, 0, false, true, false, false);
    public static final Command TOUCH = Command.create("touch", -2, 1, -1, 1, false, true, false, false);
    public static final Command TTL = Command.create("ttl", 2, 1, 1, 1, false, true, false, false);
    public static final Command TYPE = Command.create("type", 2, 1, 1, 1, false, true, false, false);
    public static final Command UNLINK = Command.create("unlink", -2, 1, -1, 1, true, false, false, false);
    public static final Command UNSUBSCRIBE = Command.create("unsubscribe", -1, 0, 0, 0, false, false, false, true);
    public static final Command UNWATCH = Command.create("unwatch", 1, 0, 0, 0, false, false, false, false);
    public static final Command WAIT = Command.create("wait", 3, 0, 0, 0, false, false, false, false);
    public static final Command WATCH = Command.create("watch", -2, 1, -1, 1, false, false, false, false);
    public static final Command XACK = Command.create("xack", -4, 1, 1, 1, true, false, false, false);
    public static final Command XADD = Command.create("xadd", -5, 1, 1, 1, true, false, false, false);
    public static final Command XCLAIM = Command.create("xclaim", -6, 1, 1, 1, true, false, false, false);
    public static final Command XDEL = Command.create("xdel", -3, 1, 1, 1, true, false, false, false);
    public static final Command XGROUP = Command.create("xgroup", -2, 2, 2, 1, true, false, false, false);
    public static final Command XINFO = Command.create("xinfo", -2, 2, 2, 1, false, true, false, false);
    public static final Command XLEN = Command.create("xlen", 2, 1, 1, 1, false, true, false, false);
    public static final Command XPENDING = Command.create("xpending", -3, 1, 1, 1, false, true, false, false);
    public static final Command XRANGE = Command.create("xrange", -4, 1, 1, 1, false, true, false, false);
    public static final Command XREAD = Command.create("xread", -4, 1, 1, 1, false, true, true, false);
    public static final Command XREADGROUP = Command.create("xreadgroup", -7, 1, 1, 1, true, false, true, false);
    public static final Command XREVRANGE = Command.create("xrevrange", -4, 1, 1, 1, false, true, false, false);
    public static final Command XSETID = Command.create("xsetid", 3, 1, 1, 1, true, false, false, false);
    public static final Command XTRIM = Command.create("xtrim", -2, 1, 1, 1, true, false, false, false);
    public static final Command ZADD = Command.create("zadd", -4, 1, 1, 1, true, false, false, false);
    public static final Command ZCARD = Command.create("zcard", 2, 1, 1, 1, false, true, false, false);
    public static final Command ZCOUNT = Command.create("zcount", 4, 1, 1, 1, false, true, false, false);
    public static final Command ZINCRBY = Command.create("zincrby", 4, 1, 1, 1, true, false, false, false);
    public static final Command ZINTERSTORE = Command.create("zinterstore", -4, 0, 0, 0, true, false, true, false);
    public static final Command ZLEXCOUNT = Command.create("zlexcount", 4, 1, 1, 1, false, true, false, false);
    public static final Command ZPOPMAX = Command.create("zpopmax", -2, 1, 1, 1, true, false, false, false);
    public static final Command ZPOPMIN = Command.create("zpopmin", -2, 1, 1, 1, true, false, false, false);
    public static final Command ZRANGE = Command.create("zrange", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZRANGEBYLEX = Command.create("zrangebylex", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZRANGEBYSCORE = Command.create("zrangebyscore", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZRANK = Command.create("zrank", 3, 1, 1, 1, false, true, false, false);
    public static final Command ZREM = Command.create("zrem", -3, 1, 1, 1, true, false, false, false);
    public static final Command ZREMRANGEBYLEX = Command.create("zremrangebylex", 4, 1, 1, 1, true, false, false, false);
    public static final Command ZREMRANGEBYRANK = Command.create("zremrangebyrank", 4, 1, 1, 1, true, false, false, false);
    public static final Command ZREMRANGEBYSCORE = Command.create("zremrangebyscore", 4, 1, 1, 1, true, false, false, false);
    public static final Command ZREVRANGE = Command.create("zrevrange", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZREVRANGEBYLEX = Command.create("zrevrangebylex", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZREVRANGEBYSCORE = Command.create("zrevrangebyscore", -4, 1, 1, 1, false, true, false, false);
    public static final Command ZREVRANK = Command.create("zrevrank", 3, 1, 1, 1, false, true, false, false);
    public static final Command ZSCAN = Command.create("zscan", -3, 1, 1, 1, false, true, false, false);
    public static final Command ZSCORE = Command.create("zscore", 3, 1, 1, 1, false, true, false, false);
    public static final Command ZUNIONSTORE = Command.create("zunionstore", -4, 0, 0, 0, true, false, true, false);
    public static final Command SENTINEL = Command.create("sentinel");

    public static Command create(String command, int arity, int firstKey, int lastKey, int interval, boolean write, boolean readOnly, boolean movable, boolean pubsub) {
        return new CommandImpl(command, arity, firstKey, lastKey, interval, write, readOnly, movable, pubsub);
    }

    public static Command create(String command) {
        return new CommandImpl(command, -1, 0, 0, 0, false, false, false, false);
    }

    @GenIgnore(value={"permitted-type"})
    public byte[] getBytes();

    public int getArity();

    public boolean isMultiKey();

    public int getFirstKey();

    public int getLastKey();

    public int getInterval();

    public boolean isKeyless();

    public boolean isWrite();

    public boolean isReadOnly();

    public boolean isMovable();

    public boolean isVoid();

    public boolean isPubSub();
}

