/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisConnectionManager;
import java.util.Collections;
import java.util.List;

public abstract class BaseRedisClient
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRedisClient.class);
    protected final VertxInternal vertx;
    protected final RedisConnectionManager connectionManager;

    public BaseRedisClient(Vertx vertx, RedisOptions options) {
        this.vertx = (VertxInternal)vertx;
        this.connectionManager = new RedisConnectionManager(this.vertx, options);
        this.connectionManager.start();
    }

    @Override
    public void close() {
        this.connectionManager.close();
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        PromiseInternal promise = this.vertx.promise();
        if (command.command().isPubSub()) {
            promise.fail("PubSub command in connection-less mode not allowed");
            return promise.future();
        }
        this.connect().onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(arg_0 -> BaseRedisClient.lambda$send$1(command, (Promise)promise, arg_0));
        return promise.future();
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        PromiseInternal promise = this.vertx.promise();
        if (commands.isEmpty()) {
            LOG.debug((Object)"Empty batch");
            promise.complete(Collections.emptyList());
        } else {
            for (Request req : commands) {
                if (!req.command().isPubSub()) continue;
                promise.fail("PubSub command in connection-less batch not allowed");
                return promise.future();
            }
            this.connect().onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(arg_0 -> BaseRedisClient.lambda$batch$4(commands, (Promise)promise, arg_0));
        }
        return promise.future();
    }

    private static /* synthetic */ void lambda$batch$4(List commands, Promise promise, RedisConnection conn) {
        conn.batch(commands).onSuccess(responses -> {
            try {
                promise.complete(responses);
            }
            finally {
                conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            }
        }).onFailure(err -> {
            try {
                promise.fail(err);
            }
            finally {
                conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            }
        });
    }

    private static /* synthetic */ void lambda$send$1(Request command, Promise promise, RedisConnection conn) {
        conn.send(command).onComplete(send -> {
            try {
                promise.handle(send);
            }
            finally {
                conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            }
        });
    }
}

