/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;

final class ArrayQueue {
    private int cur;
    private int front;
    private int back;
    private final Object[] queue;

    ArrayQueue(int capacity) {
        this.queue = new Object[capacity];
        this.back = -1;
        this.front = 0;
    }

    boolean isEmpty() {
        return this.cur == 0;
    }

    <T> void offer(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.isFull()) {
            throw new IndexOutOfBoundsException();
        }
        ++this.back;
        if (this.back == Integer.MAX_VALUE) {
            this.back %= this.queue.length;
        }
        this.queue[this.back % this.queue.length] = value;
        ++this.cur;
    }

    <T> @Nullable T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.queue[this.front % this.queue.length];
    }

    <T> @Nullable T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T e = this.peek();
        this.queue[this.front % this.queue.length] = null;
        ++this.front;
        if (this.front == Integer.MAX_VALUE) {
            this.front %= this.queue.length;
        }
        --this.cur;
        return e;
    }

    int freeSlots() {
        return this.queue.length - this.cur;
    }

    boolean isFull() {
        return this.cur == this.queue.length;
    }
}

