/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionManager;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import io.vertx.redis.client.impl.RedisStandaloneConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.List;
import java.util.Objects;

class RedisConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnectionManager.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> LOG.error((Object)"Unhandled Error", t);
    private final VertxInternal vertx;
    private final NetClient netClient;
    private final PoolMetrics metrics;
    private final RedisOptions options;
    private final ConnectionManager<ConnectionKey, Lease<RedisConnectionInternal>> pooledConnectionManager;
    private long timerID;

    RedisConnectionManager(VertxInternal vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
        VertxMetrics metricsSPI = this.vertx.metricsSPI();
        this.metrics = metricsSPI != null ? metricsSPI.createPoolMetrics("redis", options.getPoolName(), options.getMaxPoolSize()) : null;
        this.netClient = vertx.createNetClient(options.getNetClientOptions());
        this.pooledConnectionManager = new ConnectionManager(this::connectionEndpointProvider);
    }

    private Endpoint<Lease<RedisConnectionInternal>> connectionEndpointProvider(ConnectionKey key, ContextInternal ctx, Runnable dispose) {
        return new RedisEndpoint(this.vertx, this.netClient, this.options, dispose, key);
    }

    synchronized void start() {
        long period = this.options.getPoolCleanerInterval();
        this.timerID = period > 0L ? this.vertx.setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private void checkExpired(long period) {
        this.pooledConnectionManager.forEach(e -> ((RedisEndpoint)e).pool.evict(conn -> !conn.isValid(), ar -> {
            if (ar.succeeded()) {
                for (RedisConnectionInternal conn : (List)ar.result()) {
                    conn.handler((Handler)null);
                    conn.endHandler((Handler)null);
                    conn.exceptionHandler((Handler)null);
                    conn.forceClose();
                }
            }
        }));
        this.timerID = this.vertx.setTimer(period, id -> this.checkExpired(period));
    }

    public Future<RedisConnection> getConnection(String connectionString, Request setup) {
        PromiseInternal promise = this.vertx.promise();
        ContextInternal ctx = promise.context();
        EventLoopContext eventLoopContext = ctx instanceof EventLoopContext ? (EventLoopContext)ctx : this.vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        boolean metricsEnabled = this.metrics != null;
        Object queueMetric = metricsEnabled ? this.metrics.submitted() : null;
        this.pooledConnectionManager.getConnection((ContextInternal)eventLoopContext, (Object)new ConnectionKey(connectionString, setup), (Handler)promise);
        return promise.future().onFailure(err -> {
            if (metricsEnabled) {
                this.metrics.rejected(queueMetric);
            }
        }).map(lease -> new PooledRedisConnection((Lease<RedisConnectionInternal>)lease, this.metrics, metricsEnabled ? this.metrics.begin(queueMetric) : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RedisConnectionManager redisConnectionManager = this;
        synchronized (redisConnectionManager) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.pooledConnectionManager.close();
        this.netClient.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    static class RedisEndpoint
    extends Endpoint<Lease<RedisConnectionInternal>> {
        final ConnectionPool<RedisConnectionInternal> pool;

        public RedisEndpoint(VertxInternal vertx, NetClient netClient, RedisOptions options, Runnable dispose, ConnectionKey key) {
            super(dispose);
            RedisConnectionProvider connector = new RedisConnectionProvider(vertx, netClient, options, key.string, key.setup);
            this.pool = ConnectionPool.pool((PoolConnector)connector, (int[])new int[]{options.getMaxPoolSize()}, (int)options.getMaxPoolWaiting());
        }

        public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Lease<RedisConnectionInternal>>> handler) {
            this.pool.acquire(ctx, 0, ar -> {
                if (ar.succeeded()) {
                    this.incRefCount();
                    ((RedisStandaloneConnection)((Lease)ar.result()).get()).evictHandler(() -> ((RedisEndpoint)this).decRefCount());
                }
                handler.handle(ar);
            });
        }
    }

    static class RedisConnectionProvider
    implements PoolConnector<RedisConnectionInternal> {
        private final VertxInternal vertx;
        private final NetClient netClient;
        private final RedisURI redisURI;
        private final Request setup;
        private final RedisOptions options;

        public RedisConnectionProvider(VertxInternal vertx, NetClient netClient, RedisOptions options, String connectionString, Request setup) {
            this.vertx = vertx;
            this.netClient = netClient;
            this.options = options;
            this.redisURI = new RedisURI(connectionString);
            this.setup = setup;
        }

        public boolean isValid(RedisConnectionInternal conn) {
            return conn.isValid();
        }

        public void connect(EventLoopContext ctx, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<RedisConnectionInternal>>> onConnect) {
            boolean netClientSsl = this.options.getNetClientOptions().isSsl();
            boolean connectionStringSsl = this.redisURI.ssl();
            boolean connectionStringInetSocket = this.redisURI.socketAddress().isInetSocket();
            if (connectionStringInetSocket && netClientSsl && !connectionStringSsl) {
                ctx.execute((Object)Future.failedFuture((String)"Pool initialized with SSL but connection requested plain socket"), onConnect);
                return;
            }
            this.netClient.connect(this.redisURI.socketAddress(), clientConnect -> {
                if (clientConnect.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)clientConnect.cause()), onConnect);
                    return;
                }
                NetSocket netSocket = (NetSocket)clientConnect.result();
                if (connectionStringInetSocket && !netClientSsl && connectionStringSsl) {
                    netSocket.upgradeToSsl(upgradeToSsl -> {
                        if (upgradeToSsl.failed()) {
                            ctx.execute((Object)Future.failedFuture((Throwable)upgradeToSsl.cause()), onConnect);
                        } else {
                            this.init((ContextInternal)ctx, netSocket, listener, onConnect);
                        }
                    });
                } else {
                    this.init((ContextInternal)ctx, netSocket, listener, onConnect);
                }
            });
        }

        private void init(ContextInternal ctx, NetSocket netSocket, PoolConnector.Listener connectionListener, Handler<AsyncResult<ConnectResult<RedisConnectionInternal>>> onConnect) {
            RedisStandaloneConnection connection = new RedisStandaloneConnection((Vertx)this.vertx, ctx, connectionListener, netSocket, this.options);
            connection.exceptionHandler(DEFAULT_EXCEPTION_HANDLER);
            netSocket.handler((Handler)new RESPParser(connection, this.options.getMaxNestedArrays())).closeHandler(connection::end).exceptionHandler(connection::fatal);
            this.hello(ctx, connection, this.redisURI, (Handler<AsyncResult<Void>>)((Handler)hello -> {
                if (hello.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)hello.cause()), onConnect);
                    return;
                }
                this.select(ctx, connection, this.redisURI.select(), (Handler<AsyncResult<Void>>)((Handler)select -> {
                    if (select.failed()) {
                        ctx.execute((Object)Future.failedFuture((Throwable)select.cause()), onConnect);
                        return;
                    }
                    this.setup(ctx, connection, this.setup, (Handler<AsyncResult<Void>>)((Handler)setupResult -> {
                        if (setupResult.failed()) {
                            ctx.execute((Object)Future.failedFuture((Throwable)setupResult.cause()), onConnect);
                            return;
                        }
                        connection.setValid();
                        ctx.execute((Object)Future.succeededFuture((Object)new ConnectResult((Object)connection, 1L, 0L)), onConnect);
                    }));
                }));
            }));
        }

        private void hello(ContextInternal ctx, RedisConnection connection, RedisURI redisURI, Handler<AsyncResult<Void>> handler) {
            if (!this.options.isProtocolNegotiation()) {
                this.ping(ctx, connection, handler);
            } else {
                String client;
                String password;
                Request hello = Request.cmd(Command.HELLO).arg("3");
                String string = password = redisURI.password() != null ? redisURI.password() : this.options.getPassword();
                if (password != null) {
                    String user = redisURI.user();
                    hello.arg("AUTH").arg(user == null ? "default" : user).arg(password);
                }
                if ((client = redisURI.param("client")) != null) {
                    hello.arg("SETNAME").arg(client);
                }
                connection.send(hello, (Handler<AsyncResult<Response>>)((Handler)onSend -> {
                    if (onSend.succeeded()) {
                        LOG.debug(onSend.result());
                        ctx.execute((Object)Future.succeededFuture(), handler);
                        return;
                    }
                    Throwable err = onSend.cause();
                    if (err != null && err instanceof ErrorType) {
                        ErrorType redisErr = (ErrorType)err;
                        if (redisErr.is("NOAUTH")) {
                            this.authenticate(ctx, connection, password, handler);
                            return;
                        }
                        if (redisErr.is("ERR")) {
                            String msg = redisErr.getMessage();
                            if (msg.startsWith("ERR unknown command") || msg.startsWith("ERR unknown or unsupported command")) {
                                this.ping(ctx, connection, handler);
                            }
                            return;
                        }
                    }
                    ctx.execute((Object)Future.failedFuture((Throwable)err), handler);
                }));
            }
        }

        private void ping(ContextInternal ctx, RedisConnection connection, Handler<AsyncResult<Void>> handler) {
            Request ping = Request.cmd(Command.PING);
            connection.send(ping, (Handler<AsyncResult<Response>>)((Handler)onSend -> {
                if (onSend.succeeded()) {
                    LOG.debug(onSend.result());
                    ctx.execute((Object)Future.succeededFuture(), handler);
                    return;
                }
                Throwable err = onSend.cause();
                if (err != null && err instanceof ErrorType && ((ErrorType)err).is("NOAUTH")) {
                    String password = this.redisURI.password() != null ? this.redisURI.password() : this.options.getPassword();
                    this.authenticate(ctx, connection, password, handler);
                    return;
                }
                ctx.execute((Object)Future.failedFuture((Throwable)err), handler);
            }));
        }

        private void authenticate(ContextInternal ctx, RedisConnection connection, String password, Handler<AsyncResult<Void>> handler) {
            if (password == null) {
                ctx.execute((Object)Future.succeededFuture(), handler);
                return;
            }
            connection.send(Request.cmd(Command.AUTH).arg(password), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)auth.cause()), handler);
                } else {
                    ctx.execute((Object)Future.succeededFuture(), handler);
                }
            }));
        }

        private void select(ContextInternal ctx, RedisConnection connection, Integer select, Handler<AsyncResult<Void>> handler) {
            if (select == null) {
                ctx.execute((Object)Future.succeededFuture(), handler);
                return;
            }
            connection.send(Request.cmd(Command.SELECT).arg(select), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                if (auth.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)auth.cause()), handler);
                } else {
                    ctx.execute((Object)Future.succeededFuture(), handler);
                }
            }));
        }

        private void setup(ContextInternal ctx, RedisConnection connection, Request setup, Handler<AsyncResult<Void>> handler) {
            if (setup == null) {
                ctx.execute((Object)Future.succeededFuture(), handler);
                return;
            }
            connection.send(setup, (Handler<AsyncResult<Response>>)((Handler)req -> {
                if (req.failed()) {
                    ctx.execute((Object)Future.failedFuture((Throwable)req.cause()), handler);
                } else {
                    ctx.execute((Object)Future.succeededFuture(), handler);
                }
            }));
        }
    }

    static class ConnectionKey {
        private final String string;
        private final Request setup;

        ConnectionKey(String string, Request setup) {
            this.string = string;
            this.setup = setup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            return Objects.equals(this.string, that.string) && Objects.equals(this.setup, that.setup);
        }

        public int hashCode() {
            return Objects.hash(this.string, this.setup);
        }
    }
}

