/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.ResponseType;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@VertxGen
public interface Response
extends Iterable<Response> {
    public ResponseType type();

    default public Map<String, Response> attributes() {
        return Collections.emptyMap();
    }

    public String toString();

    default public @Nullable String format() {
        throw new UnsupportedOperationException("This type doesn't hold a Verbatim Bulk type");
    }

    @GenIgnore(value={"permitted-type"})
    default public Number toNumber() {
        throw new UnsupportedOperationException("This type doesn't hold a Numeric type");
    }

    default public @Nullable Double toDouble() {
        String msg = this.toString();
        if (msg != null) {
            return Double.parseDouble(msg);
        }
        return null;
    }

    default public @Nullable Float toFloat() {
        String msg = this.toString();
        if (msg != null) {
            return Float.valueOf(Float.parseFloat(msg));
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public @Nullable BigInteger toBigInteger() {
        String msg = this.toString();
        if (msg != null) {
            return new BigInteger(msg);
        }
        return null;
    }

    default public @Nullable Long toLong() {
        String msg = this.toString();
        if (msg != null) {
            return Long.parseLong(msg);
        }
        return null;
    }

    default public @Nullable Integer toInteger() {
        String msg = this.toString();
        if (msg != null) {
            return Integer.parseInt(msg);
        }
        return null;
    }

    default public @Nullable Short toShort() {
        String msg = this.toString();
        if (msg != null) {
            return Short.parseShort(msg);
        }
        return null;
    }

    default public @Nullable Byte toByte() {
        String msg = this.toString();
        if (msg != null) {
            return Byte.parseByte(msg);
        }
        return null;
    }

    default public @Nullable Boolean toBoolean() {
        String msg = this.toString();
        if (msg != null) {
            return msg.length() == 1 && msg.charAt(0) == 't';
        }
        return null;
    }

    @GenIgnore(value={"permitted-type"})
    default public String toString(Charset encoding) {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    default public Buffer toBuffer() {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    @GenIgnore(value={"permitted-type"})
    default public byte[] toBytes() {
        throw new UnsupportedOperationException("This type doesn't hold a Bulk type");
    }

    default public Response get(int index) {
        throw new UnsupportedOperationException("This type doesn't hold an Array type");
    }

    default public Response get(String key) {
        throw new UnsupportedOperationException("This type doesn't hold a Map type");
    }

    default public boolean containsKey(String key) {
        throw new UnsupportedOperationException("This type doesn't hold a Map type");
    }

    default public Set<String> getKeys() {
        throw new UnsupportedOperationException("This type doesn't hold a Map type");
    }

    default public int size() {
        throw new UnsupportedOperationException("This type doesn't hold an Array/Map type");
    }

    @Override
    @GenIgnore
    default public Iterator<Response> iterator() {
        throw new UnsupportedOperationException("This type doesn't hold a Array type");
    }

    @GenIgnore
    default public Stream<Response> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

