/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.CommandImpl;
import io.vertx.redis.client.impl.RESPEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RequestImpl
implements Request {
    private static final byte[] EMPTY_BULK = "$0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] NULL_BULK = "$4\r\nnull\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] EOL = "\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRUE = new byte[]{116};
    private static final byte[] FALSE = new byte[]{102};
    private final CommandImpl cmd;
    private final List<byte[]> args;

    public RequestImpl(Command cmd) {
        this.cmd = (CommandImpl)cmd;
        this.args = this.cmd.getArity() != 0 ? new ArrayList<byte[]>(Math.abs(this.cmd.getArity())) : Collections.emptyList();
    }

    public RequestImpl(Command cmd, Object[] args) {
        int len;
        this.cmd = (CommandImpl)cmd;
        if (args != null && (len = args.length) > 0) {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o == null) continue;
                if (o instanceof Number) {
                    args[i] = o.toString().getBytes(StandardCharsets.US_ASCII);
                    continue;
                }
                if (o instanceof Boolean) {
                    args[i] = (Boolean)o != false ? TRUE : FALSE;
                    continue;
                }
                if (o instanceof String) {
                    args[i] = ((String)o).getBytes(StandardCharsets.UTF_8);
                    continue;
                }
                if (o instanceof byte[]) continue;
                if (o instanceof Buffer) {
                    args[i] = ((Buffer)o).getBytes();
                    continue;
                }
                throw new IllegalArgumentException("Unsupported argument type: " + o.getClass());
            }
            this.args = Arrays.asList(args);
            return;
        }
        this.args = Collections.emptyList();
    }

    @Override
    public Command command() {
        return this.cmd;
    }

    @Override
    public Request arg(long arg) {
        this.args.add(RESPEncoder.numToBytes(arg));
        return this;
    }

    @Override
    public Request arg(boolean arg) {
        this.arg(arg ? TRUE : FALSE);
        return this;
    }

    @Override
    public Request nullArg() {
        this.args.add(null);
        return this;
    }

    @Override
    public Request arg(byte[] arg) {
        if (arg == null) {
            return this.nullArg();
        }
        this.args.add(arg);
        return this;
    }

    @Override
    public Request arg(Buffer arg) {
        if (arg == null) {
            return this.nullArg();
        }
        if (arg.length() == 0) {
            this.args.add(EMPTY_BYTES);
            return this;
        }
        this.args.add(arg.getBytes());
        return this;
    }

    Buffer encode() {
        return this.encode(Buffer.buffer());
    }

    Buffer encode(Buffer buffer) {
        buffer.appendByte((byte)42).appendBytes(RESPEncoder.numToBytes(this.args.size() + 1)).appendBytes(EOL).appendBytes(this.cmd.getBytes());
        for (byte[] arg : this.args) {
            if (arg == null) {
                buffer.appendBytes(NULL_BULK);
                continue;
            }
            if (arg.length == 0) {
                buffer.appendBytes(EMPTY_BULK);
                continue;
            }
            buffer.appendByte((byte)36).appendBytes(RESPEncoder.numToBytes(arg.length)).appendBytes(EOL).appendBytes(arg).appendBytes(EOL);
        }
        return buffer;
    }

    List<byte[]> getArgs() {
        return this.args;
    }

    public List<byte[]> keys() {
        return this.cmd.extractKeys(this.args);
    }

    public String toString() {
        return this.encode().toString();
    }

    public boolean valid() {
        int arity = this.cmd.getArity();
        int arglen = this.args.size() + 1;
        if (arity >= 0) {
            return arity == arglen;
        }
        return -arity <= arglen;
    }
}

