/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.CommandImpl;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.RequestImpl;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.ZModem;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;

public class RedisClusterConnection
implements RedisConnection {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterConnection.class);
    private static final Random RANDOM = new Random();
    private static final int RETRIES = 16;
    private static final Map<Command, Function<List<Response>, Response>> REDUCERS = new HashMap<Command, Function<List<Response>, Response>>();
    private static final List<Command> MASTER_ONLY_COMMANDS = new ArrayList<Command>();
    private final VertxInternal vertx;
    private final RedisClusterConnectOptions connectOptions;
    private final Slots slots;
    private final Map<String, PooledRedisConnection> connections;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        REDUCERS.put(command, fn);
    }

    public static void addMasterOnlyCommand(Command command) {
        MASTER_ONLY_COMMANDS.add(command);
    }

    RedisClusterConnection(Vertx vertx, RedisClusterConnectOptions connectOptions, Slots slots, Map<String, PooledRedisConnection> connections) {
        this.vertx = (VertxInternal)vertx;
        this.connectOptions = connectOptions;
        this.slots = slots;
        this.connections = connections;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.exceptionHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.handler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection pause() {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.pause();
        }
        return this;
    }

    @Override
    public RedisConnection resume() {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.resume();
        }
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.fetch(amount);
        }
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> handler) {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            redisConnection.endHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public Future<Response> send(Request request) {
        PromiseInternal promise = this.vertx.promise();
        RequestImpl req = (RequestImpl)request;
        CommandImpl cmd = (CommandImpl)req.command();
        List<byte[]> args = req.getArgs();
        if (cmd.needsGetKeys()) {
            this.send(this.selectEndpoint(-1, cmd.isReadOnly(args), true), 16, req, (Handler<AsyncResult<Response>>)promise);
            return promise.future();
        }
        boolean forceMasterEndpoint = MASTER_ONLY_COMMANDS.contains(cmd);
        List<byte[]> keys = req.keys();
        switch (keys.size()) {
            case 0: {
                if (REDUCERS.containsKey(cmd)) {
                    ArrayList<Future> responses = new ArrayList<Future>(this.slots.size());
                    for (int i = 0; i < this.slots.size(); ++i) {
                        String[] endpoints = this.slots.endpointsForSlot(i);
                        PromiseInternal p = this.vertx.promise();
                        this.send(this.selectMasterOrReplicaEndpoint(cmd.isReadOnly(args), endpoints, forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)p);
                        responses.add(p.future());
                    }
                    Future.all(responses).onComplete(arg_0 -> RedisClusterConnection.lambda$send$0((Promise)promise, cmd, arg_0));
                } else {
                    this.send(this.selectEndpoint(-1, cmd.isReadOnly(args), forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
                }
                return promise.future();
            }
            case 1: {
                this.send(this.selectEndpoint(ZModem.generate(keys.get(0)), cmd.isReadOnly(args), forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
                return promise.future();
            }
        }
        int hashSlot = ZModem.generateMultiRaw(keys);
        if (hashSlot == -1) {
            if (!REDUCERS.containsKey(cmd)) {
                promise.fail(this.buildCrossslotFailureMsg(req));
                return promise.future();
            }
            Map<Integer, Request> requests = this.splitRequest(cmd, args);
            if (requests.isEmpty()) {
                promise.fail(this.buildCrossslotFailureMsg(req));
                return promise.future();
            }
            ArrayList<Future> responses = new ArrayList<Future>(requests.size());
            for (Map.Entry<Integer, Request> kv : requests.entrySet()) {
                PromiseInternal p = this.vertx.promise();
                this.send(this.selectEndpoint(kv.getKey(), cmd.isReadOnly(args), forceMasterEndpoint), 16, kv.getValue(), (Handler<AsyncResult<Response>>)p);
                responses.add(p.future());
            }
            Future.all(responses).onComplete(arg_0 -> RedisClusterConnection.lambda$send$1((Promise)promise, cmd, arg_0));
            return promise.future();
        }
        String[] endpoints = this.slots.endpointsForKey(hashSlot);
        this.send(this.selectMasterOrReplicaEndpoint(cmd.isReadOnly(args), endpoints, forceMasterEndpoint), 16, req, (Handler<AsyncResult<Response>>)promise);
        return promise.future();
    }

    private Map<Integer, Request> splitRequest(CommandImpl cmd, List<byte[]> args) {
        IdentityHashMap<Integer, Request> map = new IdentityHashMap<Integer, Request>();
        int lastKey = cmd.iterateKeys(args, (begin, keyIdx, keyStep) -> {
            int j;
            int slot = ZModem.generate((byte[])args.get(keyIdx));
            Request request = (Request)map.get(slot);
            if (request == null) {
                request = Request.cmd(cmd);
                for (j = 0; j < begin; ++j) {
                    request.arg((byte[])args.get(j));
                }
                map.put(slot, request);
            }
            request.arg((byte[])args.get(keyIdx));
            for (j = keyIdx + 1; j < keyIdx + keyStep; ++j) {
                request.arg((byte[])args.get(j));
            }
        });
        Collection col = map.values();
        col.forEach(req -> {
            for (int j = lastKey; j < args.size(); ++j) {
                req.arg((byte[])args.get(j));
            }
        });
        return map;
    }

    private void send(String endpoint, int retries, Request command, Handler<AsyncResult<Response>> handler) {
        PooledRedisConnection connection = this.connections.get(endpoint);
        if (connection == null) {
            handler.handle((Object)Future.failedFuture((String)("Missing connection to: " + endpoint)));
            return;
        }
        connection.send(command, (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                ErrorType cause = (ErrorType)send.cause();
                if (cause.is("MOVED")) {
                    handler.handle((Object)Future.failedFuture((Throwable)cause));
                    return;
                }
                if (cause.is("ASK")) {
                    connection.send(Request.cmd(Command.ASKING), (Handler<AsyncResult<Response>>)((Handler)asking -> {
                        if (asking.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)asking.cause()));
                            return;
                        }
                        String addr = cause.slice(' ', cause.is("ERR") ? 3 : 2);
                        if (addr == null) {
                            handler.handle((Object)Future.failedFuture((Throwable)cause));
                            return;
                        }
                        RedisURI uri = new RedisURI(endpoint);
                        this.send(uri.protocol() + "://" + uri.userinfo() + addr, retries - 1, command, handler);
                    }));
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.send(endpoint, retries - 1, command, handler));
                    return;
                }
                if (cause.is("NOAUTH") && this.connectOptions.getPassword() != null) {
                    connection.send(Request.cmd(Command.AUTH).arg(this.connectOptions.getPassword()), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                        if (auth.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                            return;
                        }
                        this.send(endpoint, retries - 1, command, handler);
                    }));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Handler failure", (Throwable)e);
            }
        }));
    }

    @Override
    public Future<List<Response>> batch(List<Request> requests) {
        PromiseInternal promise = this.vertx.promise();
        if (requests.isEmpty()) {
            LOG.debug((Object)"Empty batch");
            promise.complete(Collections.emptyList());
        } else {
            int currentSlot = -1;
            boolean readOnly = false;
            boolean forceMasterEndpoint = false;
            block4: for (Request request : requests) {
                int slot;
                RequestImpl req = (RequestImpl)request;
                CommandImpl cmd = (CommandImpl)req.command();
                List<byte[]> args = req.getArgs();
                readOnly |= cmd.isReadOnly(args);
                if (cmd.needsGetKeys()) {
                    forceMasterEndpoint = true;
                    continue;
                }
                List<byte[]> keys = req.keys();
                forceMasterEndpoint |= MASTER_ONLY_COMMANDS.contains(cmd);
                switch (keys.size()) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        slot = ZModem.generate(keys.get(0));
                        if (currentSlot == -1) {
                            currentSlot = slot;
                            continue block4;
                        }
                        if (currentSlot == slot) continue block4;
                        promise.fail(this.buildCrossslotFailureMsg(req));
                        return promise.future();
                    }
                }
                Iterator<byte[]> iterator = keys.iterator();
                if (!iterator.hasNext()) continue;
                byte[] key = iterator.next();
                slot = ZModem.generate(key);
                if (currentSlot == -1) {
                    currentSlot = slot;
                    continue;
                }
                if (currentSlot == slot) continue;
                promise.fail(this.buildCrossslotFailureMsg(req));
                return promise.future();
            }
            this.batch(this.selectEndpoint(currentSlot, readOnly, forceMasterEndpoint), 16, requests, (Handler<AsyncResult<List<Response>>>)promise);
        }
        return promise.future();
    }

    private void batch(String endpoint, int retries, List<Request> commands, Handler<AsyncResult<List<Response>>> handler) {
        RedisConnection connection = this.connections.get(endpoint);
        if (connection == null) {
            handler.handle((Object)Future.failedFuture((String)("Missing connection to: " + endpoint)));
            return;
        }
        connection.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)send -> {
            if (send.failed() && send.cause() instanceof ErrorType && retries >= 0) {
                ErrorType cause = (ErrorType)send.cause();
                if (cause.is("MOVED")) {
                    handler.handle((Object)Future.failedFuture((Throwable)cause));
                    return;
                }
                if (cause.is("ASK")) {
                    connection.send(Request.cmd(Command.ASKING), (Handler<AsyncResult<Response>>)((Handler)asking -> {
                        if (asking.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)asking.cause()));
                            return;
                        }
                        String addr = cause.slice(' ', cause.is("ERR") ? 3 : 2);
                        if (addr == null) {
                            handler.handle((Object)Future.failedFuture((Throwable)cause));
                            return;
                        }
                        RedisURI uri = new RedisURI(endpoint);
                        this.batch(uri.protocol() + "://" + uri.userinfo() + addr, retries - 1, commands, handler);
                    }));
                    return;
                }
                if (cause.is("TRYAGAIN") || cause.is("CLUSTERDOWN")) {
                    long backoff = (long)(Math.pow(2.0, 16 - Math.max(retries, 9)) * 10.0);
                    this.vertx.setTimer(backoff, t -> this.batch(endpoint, retries - 1, commands, handler));
                    return;
                }
                if (cause.is("NOAUTH") && this.connectOptions.getPassword() != null) {
                    connection.send(Request.cmd(Command.AUTH).arg(this.connectOptions.getPassword()), (Handler<AsyncResult<Response>>)((Handler)auth -> {
                        if (auth.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)auth.cause()));
                            return;
                        }
                        this.batch(endpoint, retries - 1, commands, handler);
                    }));
                    return;
                }
            }
            try {
                handler.handle(send);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Handler failure", (Throwable)e);
            }
        }));
    }

    @Override
    public Future<Void> close() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null) continue;
            futures.add(redisConnection.close());
        }
        return Future.all(futures).mapEmpty();
    }

    @Override
    public boolean pendingQueueFull() {
        for (RedisConnection redisConnection : this.connections.values()) {
            if (redisConnection == null || !redisConnection.pendingQueueFull()) continue;
            return true;
        }
        return false;
    }

    private String selectEndpoint(int keySlot, boolean readOnly, boolean forceMasterEndpoint) {
        if (keySlot == -1) {
            return this.slots.randomEndPoint(forceMasterEndpoint);
        }
        String[] endpoints = this.slots.endpointsForKey(keySlot);
        if (endpoints == null || endpoints.length == 0) {
            return this.connectOptions.getEndpoint();
        }
        return this.selectMasterOrReplicaEndpoint(readOnly, endpoints, forceMasterEndpoint);
    }

    private String selectMasterOrReplicaEndpoint(boolean readOnly, String[] endpoints, boolean forceMasterEndpoint) {
        if (forceMasterEndpoint) {
            return endpoints[0];
        }
        RedisReplicas useReplicas = this.connectOptions.getUseReplicas();
        if (readOnly && useReplicas != RedisReplicas.NEVER && endpoints.length > 1) {
            switch (useReplicas) {
                case ALWAYS: {
                    return endpoints[1 + RANDOM.nextInt(endpoints.length - 1)];
                }
                case SHARE: {
                    return endpoints[RANDOM.nextInt(endpoints.length)];
                }
            }
        }
        return endpoints[0];
    }

    private String buildCrossslotFailureMsg(RequestImpl req) {
        return "Keys of command or batch: \"" + req.toString() + "\" targets not all in the same hash slot (CROSSSLOT) and client side resharding is not supported";
    }

    private static /* synthetic */ void lambda$send$1(Promise promise, CommandImpl cmd, AsyncResult composite) {
        if (composite.failed()) {
            promise.fail(composite.cause());
        } else {
            promise.complete((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list()));
        }
    }

    private static /* synthetic */ void lambda$send$0(Promise promise, CommandImpl cmd, AsyncResult composite) {
        if (composite.failed()) {
            promise.fail(composite.cause());
        } else {
            promise.complete((Object)REDUCERS.get(cmd).apply(((CompositeFuture)composite.result()).list()));
        }
    }
}

