/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisClusterConnectOptionsConverter;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnectOptionsConverter;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RedisClusterConnectOptions
extends RedisConnectOptions {
    private RedisReplicas useReplicas;
    private long hashSlotCacheTTL;

    public RedisClusterConnectOptions(RedisOptions options) {
        super(options);
        this.setUseReplicas(options.getUseReplicas());
        this.setHashSlotCacheTTL(options.getHashSlotCacheTTL());
    }

    public RedisClusterConnectOptions() {
        this.useReplicas = RedisReplicas.NEVER;
        this.hashSlotCacheTTL = 1000L;
    }

    public RedisClusterConnectOptions(RedisClusterConnectOptions other) {
        this.useReplicas = other.useReplicas;
        this.hashSlotCacheTTL = other.hashSlotCacheTTL;
    }

    public RedisClusterConnectOptions(JsonObject json) {
        this();
        RedisConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisReplicas getUseReplicas() {
        return this.useReplicas;
    }

    public RedisClusterConnectOptions setUseReplicas(RedisReplicas useReplicas) {
        this.useReplicas = useReplicas;
        return this;
    }

    public long getHashSlotCacheTTL() {
        return this.hashSlotCacheTTL;
    }

    public RedisClusterConnectOptions setHashSlotCacheTTL(long hashSlotCacheTTL) {
        this.hashSlotCacheTTL = hashSlotCacheTTL;
        return this;
    }

    @Override
    public RedisClusterConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        return (RedisClusterConnectOptions)super.setMaxNestedArrays(maxNestedArrays);
    }

    @Override
    public RedisClusterConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        return (RedisClusterConnectOptions)super.setProtocolNegotiation(protocolNegotiation);
    }

    @Override
    public RedisClusterConnectOptions setPassword(String password) {
        return (RedisClusterConnectOptions)super.setPassword(password);
    }

    @Override
    public RedisClusterConnectOptions setEndpoints(List<String> endpoints) {
        return (RedisClusterConnectOptions)super.setEndpoints(endpoints);
    }

    @Override
    public RedisClusterConnectOptions setConnectionString(String connectionString) {
        return (RedisClusterConnectOptions)super.setConnectionString(connectionString);
    }

    @Override
    public RedisClusterConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        return (RedisClusterConnectOptions)super.setMaxWaitingHandlers(maxWaitingHandlers);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        RedisClusterConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

