/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.keys;

import io.vertx.redis.client.impl.keys.FindKeys;
import io.vertx.redis.client.impl.keys.KeyConsumer;
import java.util.List;

public class FindKeysRange
implements FindKeys {
    private final int lastKey;
    private final int keyStep;
    private final int limit;

    public FindKeysRange(int lastKey, int keyStep, int limit) {
        this.lastKey = lastKey;
        this.keyStep = keyStep;
        this.limit = limit;
    }

    @Override
    public int forEach(List<byte[]> args, int arity, int offset, KeyConsumer collector) {
        int i;
        int stop;
        if (this.lastKey >= 0) {
            stop = offset + this.lastKey;
        } else {
            stop = args.size() + this.lastKey;
            if (this.lastKey == -1 && this.limit > 1) {
                stop = offset + (stop - offset) / this.limit;
            }
        }
        for (i = offset; i <= stop; i += this.keyStep) {
            collector.accept(offset, i, this.keyStep);
        }
        return i;
    }
}

