/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisReplicationConnectOptionsConverter;
import io.vertx.redis.client.RedisTopology;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class RedisReplicationConnectOptions
extends RedisConnectOptions {
    private RedisTopology topology;
    private RedisReplicas useReplicas;

    public RedisReplicationConnectOptions() {
        this.topology = RedisTopology.DISCOVER;
        this.useReplicas = RedisReplicas.NEVER;
    }

    public RedisReplicationConnectOptions(RedisOptions options) {
        super(options);
        this.setTopology(options.getTopology());
        this.setUseReplicas(options.getUseReplicas());
    }

    public RedisReplicationConnectOptions(RedisReplicationConnectOptions other) {
        super(other);
        this.setTopology(other.getTopology());
        this.setUseReplicas(other.getUseReplicas());
    }

    public RedisReplicationConnectOptions(JsonObject json) {
        super(json);
        RedisReplicationConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisTopology getTopology() {
        return this.topology;
    }

    public RedisReplicationConnectOptions setTopology(RedisTopology topology) {
        this.topology = topology;
        return this;
    }

    public RedisReplicas getUseReplicas() {
        return this.useReplicas;
    }

    public RedisReplicationConnectOptions setUseReplicas(RedisReplicas useReplicas) {
        this.useReplicas = useReplicas;
        return this;
    }

    @Override
    public RedisReplicationConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        return (RedisReplicationConnectOptions)super.setMaxNestedArrays(maxNestedArrays);
    }

    @Override
    public RedisReplicationConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        return (RedisReplicationConnectOptions)super.setProtocolNegotiation(protocolNegotiation);
    }

    @Override
    public RedisReplicationConnectOptions setPreferredProtocolVersion(ProtocolVersion preferredProtocolVersion) {
        return (RedisReplicationConnectOptions)super.setPreferredProtocolVersion(preferredProtocolVersion);
    }

    @Override
    public RedisReplicationConnectOptions setPassword(String password) {
        return (RedisReplicationConnectOptions)super.setPassword(password);
    }

    @Override
    public RedisReplicationConnectOptions setEndpoints(List<String> endpoints) {
        return (RedisReplicationConnectOptions)super.setEndpoints(endpoints);
    }

    @Override
    public RedisReplicationConnectOptions addConnectionString(String connectionString) {
        return (RedisReplicationConnectOptions)super.addConnectionString(connectionString);
    }

    @Override
    public RedisReplicationConnectOptions setConnectionString(String connectionString) {
        return (RedisReplicationConnectOptions)super.setConnectionString(connectionString);
    }

    @Override
    public RedisReplicationConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        return (RedisReplicationConnectOptions)super.setMaxWaitingHandlers(maxWaitingHandlers);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        RedisReplicationConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

