/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisClusterConnection;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.NumberType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class RedisClusterClient
extends BaseRedisClient
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterClient.class);
    private final RedisClusterConnectOptions connectOptions;
    private final PoolOptions poolOptions;
    private final AtomicReference<Future<Slots>> slots = new AtomicReference();

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        RedisClusterConnection.addReducer(command, fn);
    }

    public static void addMasterOnlyCommand(Command command) {
        RedisClusterConnection.addMasterOnlyCommand(command);
    }

    public RedisClusterClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, RedisClusterConnectOptions connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.connectOptions = connectOptions;
        this.poolOptions = poolOptions;
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.getSlots(this.vertx.getOrCreateContext()).onSuccess(arg_0 -> this.lambda$connect$11((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void connect(Slots slots, Handler<AsyncResult<RedisConnection>> onConnected) {
        int totalUniqueEndpoints = slots.endpoints().length;
        if (this.poolOptions.getMaxSize() < totalUniqueEndpoints) {
            onConnected.handle((Object)Future.failedFuture((Throwable)new RedisConnectException("RedisOptions maxPoolSize < Cluster size(" + totalUniqueEndpoints + "): The pool is not able to hold all required connections!")));
            return;
        }
        ConcurrentHashMap.KeySetView failures = ConcurrentHashMap.newKeySet();
        AtomicInteger counter = new AtomicInteger();
        HashMap connections = new HashMap();
        for (String endpoint : slots.endpoints()) {
            this.connectionManager.getConnection(endpoint, RedisReplicas.NEVER != this.connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
                failures.add(err);
                this.connectionComplete(counter, slots, connections, failures, onConnected);
            }).onSuccess(cconn -> {
                Map map = connections;
                synchronized (map) {
                    connections.put(endpoint, cconn);
                }
                this.connectionComplete(counter, slots, connections, failures, onConnected);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionComplete(AtomicInteger counter, Slots slots, Map<String, PooledRedisConnection> connections, Set<Throwable> failures, Handler<AsyncResult<RedisConnection>> onConnected) {
        if (counter.incrementAndGet() == slots.endpoints().length) {
            if (!failures.isEmpty()) {
                Map<String, PooledRedisConnection> map = connections;
                synchronized (map) {
                    for (RedisConnection redisConnection : connections.values()) {
                        if (redisConnection == null) continue;
                        redisConnection.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
                    }
                }
                StringBuilder message = new StringBuilder("Failed to connect to all nodes of the cluster");
                for (Throwable throwable : failures) {
                    message.append("\n- ").append(throwable);
                }
                onConnected.handle((Object)Future.failedFuture((Throwable)new RedisConnectException(message.toString())));
            } else {
                onConnected.handle((Object)Future.succeededFuture((Object)new RedisClusterConnection((Vertx)this.vertx, this.connectOptions, slots, () -> this.slots.set(null), connections)));
            }
        }
    }

    private Future<Slots> getSlots(ContextInternal context) {
        PromiseInternal promise;
        Future future;
        do {
            Future<Slots> slots;
            if ((slots = this.slots.get()) == null) continue;
            return slots;
        } while (!this.slots.compareAndSet(null, (Future<Slots>)(future = (promise = context.promise()).future())));
        LOG.debug((Object)"Obtaining hash slot assignment");
        this.getSlots(this.connectOptions.getEndpoints(), 0, (Handler<AsyncResult<Slots>>)promise);
        return future;
    }

    private void getSlots(List<String> endpoints, int index, Handler<AsyncResult<Slots>> onGotSlots) {
        if (index >= endpoints.size()) {
            onGotSlots.handle((Object)Future.failedFuture((Throwable)new RedisConnectException("Cannot connect to any of the provided endpoints")));
            this.scheduleCachedSlotsExpiration();
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), RedisReplicas.NEVER != this.connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> this.getSlots(endpoints, index + 1, onGotSlots)).onSuccess(conn -> this.getSlots((String)endpoints.get(index), (RedisConnection)conn, (Handler<AsyncResult<Slots>>)((Handler)result -> {
            conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            if (result.failed()) {
                this.getSlots(endpoints, index + 1, onGotSlots);
            } else {
                Slots slots = (Slots)result.result();
                onGotSlots.handle((Object)Future.succeededFuture((Object)slots));
                this.scheduleCachedSlotsExpiration();
            }
        })));
    }

    private void getSlots(String endpoint, RedisConnection conn, Handler<AsyncResult<Slots>> onGetSlots) {
        conn.send(Request.cmd(Command.CLUSTER).arg("SLOTS"), (Handler<AsyncResult<Response>>)((Handler)send -> {
            if (send.failed()) {
                onGetSlots.handle((Object)Future.failedFuture((Throwable)send.cause()));
                return;
            }
            Response reply = (Response)send.result();
            if (reply == null || reply.size() == 0) {
                onGetSlots.handle((Object)Future.failedFuture((String)"SLOTS No slots available in the cluster."));
                return;
            }
            onGetSlots.handle((Object)Future.succeededFuture((Object)new Slots(endpoint, reply)));
        }));
    }

    private void scheduleCachedSlotsExpiration() {
        this.vertx.setTimer(this.connectOptions.getHashSlotCacheTTL(), ignored -> this.slots.set(null));
    }

    private /* synthetic */ void lambda$connect$11(Promise promise, Slots slots) {
        this.connect(slots, (Handler<AsyncResult<RedisConnection>>)promise);
    }

    static {
        RedisClusterClient.addReducer(Command.MSET, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DEL, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addReducer(Command.MGET, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.KEYS, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.FLUSHDB, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DBSIZE, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addMasterOnlyCommand(Command.WAIT);
        RedisClusterClient.addMasterOnlyCommand(Command.SUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.PSUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.SSUBSCRIBE);
        RedisClusterClient.addReducer(Command.UNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.PUNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.SUNSUBSCRIBE, list -> SimpleStringType.OK);
    }
}

